/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Utils;

public class WinPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private static final String MSG_UNABLE_START = "Unable to start the profiler. Please try running JMH as Administrator.";
    private static final String MSG_UNABLE_STOP = "Unable to stop the profiler. Please try running JMH as Administrator.";
    private final String xperfProviders;
    private final String symbolDir;
    private final String path;
    private volatile String pid;
    private OptionSpec<String> optXperfDir;
    private OptionSpec<String> optXperfProviders;
    private OptionSpec<String> optSymbolDir;

    public WinPerfAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "SampledProfile");
        try {
            String xperfDir = (String)this.set.valueOf(this.optXperfDir);
            this.xperfProviders = (String)this.set.valueOf(this.optXperfProviders);
            this.symbolDir = (String)this.set.valueOf(this.optSymbolDir);
            this.path = xperfDir != null && !xperfDir.isEmpty() ? xperfDir + File.separatorChar + "xperf" : "xperf";
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> errsOn = Utils.tryWith(this.path, "-on", this.xperfProviders);
        if (!errsOn.isEmpty()) {
            errsOn.add(MSG_UNABLE_START);
            throw new ProfilerException(errsOn.toString());
        }
        Collection<String> errsStop = Utils.tryWith(this.path, "-stop");
        if (!errsStop.isEmpty()) {
            errsStop.add(MSG_UNABLE_STOP);
            throw new ProfilerException(errsStop.toString());
        }
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optXperfDir = parser.accepts("xperf.dir", "Path to \"xperf\" installation directory. Empty by default, so that xperf is expected to be in PATH.").withRequiredArg().ofType(String.class).describedAs("path");
        this.optXperfProviders = parser.accepts("xperf.providers", "xperf providers to use.").withRequiredArg().ofType(String.class).describedAs("string").defaultsTo((Object)"loader+proc_thread+profile", (Object[])new String[0]);
        this.optSymbolDir = parser.accepts("symbol.dir", "Path to a directory with jvm.dll symbols (optional).").withRequiredArg().ofType(String.class).describedAs("string");
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
        Collection<String> errs = Utils.tryWith(this.path, "-on", this.xperfProviders);
        if (!errs.isEmpty()) {
            errs.add(MSG_UNABLE_START);
            throw new IllegalStateException(errs.toString());
        }
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        if (pid == 0L) {
            throw new IllegalStateException("perfasm needs the forked VM PID, but it is not initialized.");
        }
        this.pid = String.valueOf(pid);
        return super.afterTrial(br, pid, stdOut, stdErr);
    }

    @Override
    public String getDescription() {
        return "Windows xperf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        Collection<String> errs = Utils.tryWith(this.path, "-d", this.perfBinData.getAbsolutePath());
        if (!errs.isEmpty()) {
            errs.add(MSG_UNABLE_STOP);
            throw new IllegalStateException(errs.toString());
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.path, "-i", this.perfBinData.getAbsolutePath(), "-symbols", "-a", "dumper");
            if (this.symbolDir != null) {
                pb.environment().put("_NT_SYMBOL_PATH", this.symbolDir);
            }
            Process p = pb.start();
            FileOutputStream fos = new FileOutputStream(this.perfParsedData.file());
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipMs, double lenMs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String perfBinaryExtension() {
        return ".etl";
    }
}

