/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.util.FilterSupport;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractUnArchiver
extends AbstractLogEnabled
implements UnArchiver,
FinalizerEnabled,
FilterEnabled {
    private File destDirectory;
    private File destFile;
    private File sourceFile;
    private boolean overwrite = true;
    private FilterSupport filterSupport;
    private List finalizers;
    private FileSelector[] fileSelectors;
    private boolean useJvmChmod = false;
    private boolean ignorePermissions = false;

    public AbstractUnArchiver() {
    }

    public AbstractUnArchiver(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getDestDirectory() {
        return this.destDirectory;
    }

    public void setDestDirectory(File destDirectory) {
        this.destDirectory = destDirectory;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public final void extract() throws ArchiverException {
        this.validate();
        this.execute();
        this.runArchiveFinalizers();
    }

    public final void extract(String path, File outputDirectory) throws ArchiverException {
        this.validate(path, outputDirectory);
        this.execute(path, outputDirectory);
        this.runArchiveFinalizers();
    }

    public void setArchiveFilters(List filters) {
        this.filterSupport = new FilterSupport(filters, this.getLogger());
    }

    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList();
        }
        this.finalizers.add(finalizer);
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    private final void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            for (ArchiveFinalizer finalizer : this.finalizers) {
                finalizer.finalizeArchiveExtraction(this);
            }
        }
    }

    protected boolean include(InputStream inputStream, String name) throws ArchiveFilterException {
        return this.filterSupport == null || this.filterSupport.include(inputStream, name);
    }

    protected void validate(String path, File outputDirectory) {
    }

    protected void validate() throws ArchiverException {
        if (this.sourceFile == null) {
            throw new ArchiverException("The source file isn't defined.");
        }
        if (this.sourceFile.isDirectory()) {
            throw new ArchiverException("The source must not be a directory.");
        }
        if (!this.sourceFile.exists()) {
            throw new ArchiverException("The source file " + this.sourceFile + " doesn't exist.");
        }
        if (this.destDirectory == null && this.destFile == null) {
            throw new ArchiverException("The destination isn't defined.");
        }
        if (this.destDirectory != null && this.destFile != null) {
            throw new ArchiverException("You must choose between a destination directory and a destination file.");
        }
        if (this.destDirectory != null && !this.destDirectory.isDirectory()) {
            this.destFile = this.destDirectory;
            this.destDirectory = null;
        }
        if (this.destFile != null && this.destFile.isDirectory()) {
            this.destDirectory = this.destFile;
            this.destFile = null;
        }
    }

    public void setFileSelectors(FileSelector[] fileSelectors) {
        this.fileSelectors = fileSelectors;
    }

    public FileSelector[] getFileSelectors() {
        return this.fileSelectors;
    }

    protected boolean isSelected(String fileName, PlexusIoResource fileInfo) throws ArchiverException {
        if (this.fileSelectors != null) {
            for (int i = 0; i < this.fileSelectors.length; ++i) {
                try {
                    if (this.fileSelectors[i].isSelected((FileInfo)fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed to check, whether " + fileInfo.getName() + " is selected: " + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    protected abstract void execute() throws ArchiverException;

    protected abstract void execute(String var1, File var2) throws ArchiverException;

    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    public void setIgnorePermissions(boolean ignorePermissions) {
        this.ignorePermissions = ignorePermissions;
    }
}

