/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.warmup;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestWarmUp
extends TornadoTestBase {
    @Test
    public void test01() throws TornadoExecutionPlanException, InterruptedException {
        TaskGraph taskGraph = new TaskGraph("foo");
        FloatArray input = new FloatArray(1024);
        FloatArray output = new FloatArray(1024);
        input.init(0.1f);
        taskGraph.transferToDevice(1, new Object[]{input}).task("bar", (in, out) -> {
            for (int i = 0; i < in.getSize(); ++i) {
                out.set(i, in.get(i) * 2.0f);
            }
        }, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        try (TornadoExecutionPlan plan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            long startTime = System.currentTimeMillis();
            plan.withWarmUpTime(1000L);
            long endTime = System.currentTimeMillis();
            Assert.assertTrue((endTime - startTime > 1000L && endTime - startTime < 1008L ? 1 : 0) != 0);
            plan.withProfiler(ProfilerMode.CONSOLE).execute();
        }
    }

    @Test
    public void test02() throws TornadoExecutionPlanException, InterruptedException {
        TaskGraph taskGraph = new TaskGraph("foo");
        FloatArray input = new FloatArray(1024);
        FloatArray output = new FloatArray(1024);
        input.init(0.1f);
        taskGraph.transferToDevice(1, new Object[]{input}).task("bar", (in, out) -> {
            for (int i = 0; i < in.getSize(); ++i) {
                out.set(i, in.get(i) * 2.0f);
            }
        }, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        try (TornadoExecutionPlan plan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            plan.withWarmUpIterations(1000);
            plan.withProfiler(ProfilerMode.CONSOLE).execute();
        }
    }
}

