/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.virtual;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.virtual.TestVirtualDeviceFeatureExtraction;

public class TestVirtualDeviceKernel
extends TornadoTestBase {
    private static final String SOURCE_DIR = System.getProperty("tornado.print.kernel.dir");
    private static final int SIZE = 8192;

    private static void maxReduction(float[] input, @Reduce float[] result) {
        for (int i = 0; i < input.length; ++i) {
            result[0] = Math.max(result[0], input[i]);
        }
    }

    @After
    public void after() {
        File fileLog = new File(SOURCE_DIR);
        if (fileLog.exists()) {
            fileLog.delete();
        }
    }

    private void testVirtualDeviceKernel(String expectedCodeFile) throws TornadoExecutionPlanException {
        float[] input = new float[8192];
        float[] result = new float[1];
        IntStream.range(0, 8192).forEach(idx -> {
            input[idx] = idx;
        });
        Arrays.fill(result, Float.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestVirtualDeviceKernel::maxReduction, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        String tornadoSDK = System.getenv("TORNADOVM_HOME");
        String filePath = tornadoSDK + "/examples/generated/virtualDevice/" + expectedCodeFile;
        File fileLog = new File(SOURCE_DIR);
        File expectedKernelFile = new File(filePath);
        byte[] generatedKernel = null;
        byte[] expectedKernel = null;
        try {
            generatedKernel = Files.readAllBytes(fileLog.toPath());
            expectedKernel = Files.readAllBytes(expectedKernelFile.toPath());
        }
        catch (IOException e) {
            Assert.fail();
        }
        boolean fileEquivalent = TestVirtualDeviceFeatureExtraction.performComparison(generatedKernel, expectedKernel);
        Assert.assertTrue((String)"There is a mismatch between pre-compiled and JIT compiled kernels.", (boolean)fileEquivalent);
    }

    @Test
    public void testVirtualDeviceKernel() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        boolean coops = TornadoNativeArray.ARRAY_HEADER == 16L;
        String kernelFile = coops ? "virtualDeviceKernelGPU.cl" : "virtualDeviceKernelGPU_uncompressed.cl";
        this.testVirtualDeviceKernel(kernelFile);
    }
}

