/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.virtual;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestVirtualDeviceFeatureExtraction
extends TornadoTestBase {
    private static final byte TAB = 9;
    private static final byte NEWLINE = 10;
    private static final byte WHITESPACE = 32;
    private static final String FEATURE_DUMP_DIR = System.getProperty("tornado.features.dump.dir");
    private static final int SIZE = 8192;

    private static void maxReduction(float[] input, @Reduce float[] result) {
        for (int i = 0; i < input.length; ++i) {
            result[0] = Math.max(result[0], input[i]);
        }
    }

    public static long getByteSum(byte[] bytes) {
        long sum = 0L;
        for (byte entry : bytes) {
            if (entry == 9 || entry == 10 || entry == 32) continue;
            sum += (long)entry;
        }
        return sum;
    }

    public static boolean performComparison(byte[] source, byte[] expected) {
        long expectedSum;
        long sourceSum = TestVirtualDeviceFeatureExtraction.getByteSum(source);
        return sourceSum == (expectedSum = TestVirtualDeviceFeatureExtraction.getByteSum(expected));
    }

    @After
    public void after() {
        File fileLog = new File(FEATURE_DUMP_DIR);
        if (fileLog.exists()) {
            fileLog.delete();
        }
    }

    private void testVirtuaLDeviceFeatureExtraction(String expectedFeaturesFile) throws TornadoExecutionPlanException {
        float[] input = new float[8192];
        float[] result = new float[1];
        IntStream.range(0, 8192).forEach(idx -> {
            input[idx] = idx;
        });
        Arrays.fill(result, Float.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestVirtualDeviceFeatureExtraction::maxReduction, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        String tornadoSDK = System.getenv("TORNADOVM_HOME");
        String filePath = tornadoSDK + "/examples/generated/virtualDevice/" + expectedFeaturesFile;
        File fileLog = new File(FEATURE_DUMP_DIR);
        File expectedKernelFile = new File(filePath);
        byte[] inputBytes = null;
        byte[] expectedBytes = null;
        try {
            inputBytes = Files.readAllBytes(fileLog.toPath());
            expectedBytes = Files.readAllBytes(expectedKernelFile.toPath());
        }
        catch (IOException e) {
            Assert.fail();
        }
        boolean fileEquivalent = TestVirtualDeviceFeatureExtraction.performComparison(inputBytes, expectedBytes);
        Assert.assertTrue((boolean)fileEquivalent);
    }

    @Test
    public void testVirtualDeviceFeatures() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        this.testVirtuaLDeviceFeatureExtraction("virtualDeviceFeaturesGPU.json");
    }
}

