/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.vectortypes;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat4;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestVectorAllocation
extends TornadoTestBase {
    private static void testVectorAlloc(FloatArray a, FloatArray result) {
        for (int i = 0; i < a.getSize(); ++i) {
            Float2 x = new Float2(1.0f, 10.0f);
            result.set(i, a.get(i) + x.getX() * x.getY());
        }
    }

    private static void testVectorAlloc2(FloatArray a, VectorFloat4 result) {
        for (int i = 0; i < a.getSize(); ++i) {
            Float4 x = new Float4((float)a.getSize(), 10.0f, a.get(i), a.get(i) * 10.0f);
            result.set(i, x);
        }
    }

    private static void testVectorAlloc3(FloatArray a, VectorFloat3 result) {
        for (int i = 0; i < a.getSize(); ++i) {
            Float3 x = new Float3((float)a.getSize(), 10.0f, a.get(i));
            result.set(i, x);
        }
    }

    @Test
    public void testAllocation1() throws TornadoExecutionPlanException {
        int size = 8;
        FloatArray a = new FloatArray(size);
        FloatArray output = new FloatArray(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, (float)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestVectorAllocation::testVectorAlloc, (Object)a, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)(a.get(i) + 10.0f), (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testAllocation2() throws TornadoExecutionPlanException {
        int size = 8;
        FloatArray a = new FloatArray(size);
        VectorFloat4 output = new VectorFloat4(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, (float)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestVectorAllocation::testVectorAlloc2, (Object)a, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float4 sequential = new Float4((float)a.getSize(), 10.0f, a.get(i), a.get(i) * 10.0f);
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequential.getW(), (double)output.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void testAllocation3() throws TornadoExecutionPlanException {
        int size = 8;
        FloatArray a = new FloatArray(size);
        VectorFloat3 output = new VectorFloat3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, (float)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestVectorAllocation::testVectorAlloc3, (Object)a, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float3 sequential = new Float3((float)a.getSize(), 10.0f, a.get(i));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
        }
    }
}

