/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.vectortypes;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf16;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf2;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf3;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf4;
import uk.ac.manchester.tornado.api.types.collections.VectorHalf8;
import uk.ac.manchester.tornado.api.types.vectors.Half16;
import uk.ac.manchester.tornado.api.types.vectors.Half2;
import uk.ac.manchester.tornado.api.types.vectors.Half3;
import uk.ac.manchester.tornado.api.types.vectors.Half4;
import uk.ac.manchester.tornado.api.types.vectors.Half8;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestHalfFloats
extends TornadoTestBase {
    public static final double DELTA = 0.001;

    public static void testVectorDot(VectorHalf a, VectorHalf b, VectorHalf c) {
        HalfFloat h = VectorHalf.dot((VectorHalf)a, (VectorHalf)b);
        c.set(0, h);
    }

    private static void dotMethodHalf2(Half2 a, Half2 b, VectorHalf result) {
        HalfFloat dot = Half2.dot((Half2)a, (Half2)b);
        result.set(0, dot);
    }

    private static void dotMethodHalf3(Half3 a, Half3 b, VectorHalf result) {
        HalfFloat dot = Half3.dot((Half3)a, (Half3)b);
        result.set(0, dot);
    }

    private static void dotMethodHalf4(Half4 a, Half4 b, VectorHalf result) {
        HalfFloat dot = Half4.dot((Half4)a, (Half4)b);
        result.set(0, dot);
    }

    private static void dotMethodHalf8(Half8 a, Half8 b, VectorHalf result) {
        HalfFloat dot = Half8.dot((Half8)a, (Half8)b);
        result.set(0, dot);
    }

    private static void dotMethodHalf16(Half16 a, Half16 b, VectorHalf result) {
        HalfFloat dot = Half16.dot((Half16)a, (Half16)b);
        result.set(0, dot);
    }

    private static void testFloat3Add(Half3 a, Half3 b, VectorHalf3 results) {
        results.set(0, Half3.add((Half3)a, (Half3)b));
    }

    public static void addVectorHalf2(VectorHalf2 a, VectorHalf2 b, VectorHalf2 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Half2.add((Half2)a.get(i), (Half2)b.get(i)));
        }
    }

    public static void addVectorHalf3(VectorHalf3 a, VectorHalf3 b, VectorHalf3 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Half3.add((Half3)a.get(i), (Half3)b.get(i)));
        }
    }

    public static void addVectorHalf4(VectorHalf4 a, VectorHalf4 b, VectorHalf4 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Half4.add((Half4)a.get(i), (Half4)b.get(i)));
        }
    }

    public static void addVectorHalf8(VectorHalf8 a, VectorHalf8 b, VectorHalf8 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Half8.add((Half8)a.get(i), (Half8)b.get(i)));
        }
    }

    public static void addVectorHalf16(VectorHalf16 a, VectorHalf16 b, VectorHalf16 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Half16.add((Half16)a.get(i), (Half16)b.get(i)));
        }
    }

    public static void testVectorHalf8Storage(VectorHalf8 a, VectorHalf8 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, a.get(i));
        }
    }

    public static void dotProductFunctionMap(HalfFloatArray a, HalfFloatArray b, HalfFloatArray results) {
        for (int i = 0; i < a.getSize(); ++i) {
            results.set(i, HalfFloat.mult((HalfFloat)a.get(i), (HalfFloat)b.get(i)));
        }
    }

    public static void dotProductFunctionReduce(HalfFloatArray input, HalfFloatArray results) {
        HalfFloat sum = new HalfFloat(0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            sum = HalfFloat.add((HalfFloat)sum, (HalfFloat)input.get(i));
        }
        results.set(0, sum);
    }

    private static void vectorPhiTest(VectorHalf3 input, VectorHalf3 output) {
        Half3 sum = new Half3();
        for (int i = 0; i < input.getLength(); ++i) {
            sum = Half3.add((Half3)sum, (Half3)input.get(i));
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorHalf2(VectorHalf2 output) {
        VectorHalf2 vectorHalf2 = new VectorHalf2(output.getLength());
        for (int i = 0; i < vectorHalf2.getLength(); ++i) {
            vectorHalf2.set(i, new Half2(new HalfFloat((float)i), new HalfFloat((float)i)));
        }
        Half2 sum = new Half2(new HalfFloat(0.0f), new HalfFloat(0.0f));
        for (int i = 0; i < vectorHalf2.getLength(); ++i) {
            Half2 f = vectorHalf2.get(i);
            sum = Half2.add((Half2)f, (Half2)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorHalf4(VectorHalf4 output) {
        VectorHalf4 vectorHalf4 = new VectorHalf4(output.getLength());
        for (int i = 0; i < vectorHalf4.getLength(); ++i) {
            vectorHalf4.set(i, new Half4(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
        }
        Half4 sum = new Half4(new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f));
        for (int i = 0; i < vectorHalf4.getLength(); ++i) {
            Half4 f = vectorHalf4.get(i);
            sum = Half4.add((Half4)f, (Half4)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorHalf8(VectorHalf8 output) {
        VectorHalf8 vectorHalf8 = new VectorHalf8(output.getLength());
        for (int i = 0; i < vectorHalf8.getLength(); ++i) {
            vectorHalf8.set(i, new Half8(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
        }
        Half8 sum = new Half8(new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f));
        for (int i = 0; i < vectorHalf8.getLength(); ++i) {
            Half8 f = vectorHalf8.get(i);
            sum = Half8.add((Half8)f, (Half8)sum);
        }
        output.set(0, sum);
    }

    public static void vectorHalfUnary(VectorHalf4 vector) {
        for (int i = 0; i < vector.getLength(); ++i) {
            Half4 f4 = vector.get(i);
            HalfFloat a = f4.getX();
            vector.set(i, new Half4(a, f4.getY(), f4.getZ(), f4.getW()));
        }
    }

    private static void vectorComputation01(VectorHalf2 value, VectorHalf2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Half2 half2 = new Half2();
            half2.setX(HalfFloat.add((HalfFloat)value.get(i).getX(), (HalfFloat)value.get(i).getY()));
            half2.setY(HalfFloat.mult((HalfFloat)value.get(i).getX(), (HalfFloat)new HalfFloat(2.0f)));
            output.set(i, half2);
        }
    }

    private static void vectorComputation02(VectorHalf3 value, VectorHalf3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Half3 half3 = new Half3();
            half3.setX(HalfFloat.add((HalfFloat)value.get(i).getX(), (HalfFloat)value.get(i).getY()));
            half3.setY(HalfFloat.mult((HalfFloat)value.get(i).getZ(), (HalfFloat)new HalfFloat(2.0f)));
            output.set(i, half3);
        }
    }

    private static Half3 vectorComputation03(Half4 value) {
        Half3 output = new Half3();
        output.setX(HalfFloat.add((HalfFloat)value.getX(), (HalfFloat)value.getY()));
        output.setY(value.getY());
        output.setZ(value.getW());
        return output;
    }

    private static void vectorComputation03(VectorHalf4 value, VectorHalf3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            output.set(i, TestHalfFloats.vectorComputation03(value.get(i)));
        }
    }

    private static void vectorComputation04(VectorHalf8 value, VectorHalf2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Half2 half2 = new Half2();
            half2.setX(HalfFloat.add((HalfFloat)value.get(i).getS0(), (HalfFloat)value.get(i).getS1()));
            half2.setY(value.get(i).getS1());
            output.set(i, half2);
        }
    }

    @Test
    public void testSimpleDotProductVectorHalf() throws TornadoExecutionPlanException {
        VectorHalf vectorHalfA = new VectorHalf(2);
        vectorHalfA.fill(new HalfFloat(2.0f));
        VectorHalf vectorHalfB = new VectorHalf(2);
        vectorHalfB.fill(new HalfFloat(4.0f));
        VectorHalf vectorHalfC = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{vectorHalfA, vectorHalfB}).task("t0", TestHalfFloats::testVectorDot, (Object)vectorHalfA, (Object)vectorHalfB, (Object)vectorHalfC).transferToHost(1, new Object[]{vectorHalfC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)16.0, (double)vectorHalfC.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleDotProductHalf2() throws TornadoExecutionPlanException {
        Half2 a = new Half2(new HalfFloat(1.0f), new HalfFloat(2.0f));
        Half2 b = new Half2(new HalfFloat(3.0f), new HalfFloat(2.0f));
        VectorHalf output = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::dotMethodHalf2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)7.0, (double)output.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleDotProductHalf3() throws TornadoExecutionPlanException {
        Half3 a = new Half3(new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f));
        Half3 b = new Half3(new HalfFloat(3.0f), new HalfFloat(2.0f), new HalfFloat(1.0f));
        VectorHalf output = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::dotMethodHalf3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)10.0, (double)output.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleDotProductHalf4() throws TornadoExecutionPlanException {
        Half4 a = new Half4(new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f), new HalfFloat(4.0f));
        Half4 b = new Half4(new HalfFloat(4.0f), new HalfFloat(3.0f), new HalfFloat(2.0f), new HalfFloat(1.0f));
        VectorHalf output = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::dotMethodHalf4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)20.0, (double)output.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleDotProductHalf8() throws TornadoExecutionPlanException {
        Half8 a = new Half8(new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f), new HalfFloat(4.0f), new HalfFloat(5.0f), new HalfFloat(6.0f), new HalfFloat(7.0f), new HalfFloat(8.0f));
        Half8 b = new Half8(new HalfFloat(8.0f), new HalfFloat(7.0f), new HalfFloat(6.0f), new HalfFloat(5.0f), new HalfFloat(4.0f), new HalfFloat(3.0f), new HalfFloat(2.0f), new HalfFloat(1.0f));
        VectorHalf output = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::dotMethodHalf8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)120.0, (double)output.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleDotProductHalf16() throws TornadoExecutionPlanException {
        Half16 a = new Half16(new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f), new HalfFloat(4.0f), new HalfFloat(5.0f), new HalfFloat(6.0f), new HalfFloat(7.0f), new HalfFloat(8.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f));
        Half16 b = new Half16(new HalfFloat(8.0f), new HalfFloat(7.0f), new HalfFloat(6.0f), new HalfFloat(5.0f), new HalfFloat(4.0f), new HalfFloat(3.0f), new HalfFloat(2.0f), new HalfFloat(1.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f), new HalfFloat(0.0f));
        VectorHalf output = new VectorHalf(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::dotMethodHalf16, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)120.0, (double)output.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void testSimpleVectorAddition() throws TornadoExecutionPlanException {
        int size = 1;
        Half3 a = new Half3(new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f));
        Half3 b = new Half3(new HalfFloat(3.0f), new HalfFloat(2.0f), new HalfFloat(1.0f));
        VectorHalf3 output = new VectorHalf3(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::testFloat3Add, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)4.0, (double)output.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)4.0, (double)output.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)4.0, (double)output.get(i).getZ().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf2() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf2 a = new VectorHalf2(size);
        VectorHalf2 b = new VectorHalf2(size);
        VectorHalf2 output = new VectorHalf2(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half2(new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half2(new HalfFloat((float)(size - i)), new HalfFloat((float)(size - i))));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half2 sequential = new Half2(new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))));
            Assert.assertEquals((double)sequential.getX().getFloat32(), (double)output.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getY().getFloat32(), (double)output.get(i).getY().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf3() throws TornadoExecutionPlanException {
        int size = 8;
        VectorHalf3 a = new VectorHalf3(size);
        VectorHalf3 b = new VectorHalf3(size);
        VectorHalf3 output = new VectorHalf3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half3(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half3(new HalfFloat((float)(size - i)), new HalfFloat((float)(size - i)), new HalfFloat((float)(size - i))));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half3 sequential = new Half3(new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))));
            Assert.assertEquals((double)sequential.getX().getFloat32(), (double)output.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getY().getFloat32(), (double)output.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ().getFloat32(), (double)output.get(i).getZ().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat3toString() throws TornadoExecutionPlanException {
        int size = 2;
        VectorHalf3 a = new VectorHalf3(size);
        VectorHalf3 b = new VectorHalf3(size);
        VectorHalf3 output = new VectorHalf3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half3(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half3(new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void testVectorHalf4() throws TornadoExecutionPlanException {
        int size = 8;
        VectorHalf4 a = new VectorHalf4(size);
        VectorHalf4 b = new VectorHalf4(size);
        VectorHalf4 output = new VectorHalf4(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half4(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half4(new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half4 sequential = new Half4(new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)));
            Assert.assertEquals((double)sequential.getX().getFloat32(), (double)output.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getY().getFloat32(), (double)output.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ().getFloat32(), (double)output.get(i).getZ().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getW().getFloat32(), (double)output.get(i).getW().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf16() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf16 a = new VectorHalf16(size);
        VectorHalf16 b = new VectorHalf16(size);
        VectorHalf16 output = new VectorHalf16(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half16(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half16(new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf16, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half16 sequential = new Half16(new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)));
            Assert.assertEquals((double)sequential.getS0().getFloat32(), (double)output.get(i).getS0().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1().getFloat32(), (double)output.get(i).getS1().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2().getFloat32(), (double)output.get(i).getS2().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3().getFloat32(), (double)output.get(i).getS3().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4().getFloat32(), (double)output.get(i).getS4().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5().getFloat32(), (double)output.get(i).getS5().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6().getFloat32(), (double)output.get(i).getS6().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7().getFloat32(), (double)output.get(i).getS7().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS8().getFloat32(), (double)output.get(i).getS8().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS9().getFloat32(), (double)output.get(i).getS9().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS10().getFloat32(), (double)output.get(i).getS10().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS11().getFloat32(), (double)output.get(i).getS11().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS12().getFloat32(), (double)output.get(i).getS12().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS13().getFloat32(), (double)output.get(i).getS13().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS14().getFloat32(), (double)output.get(i).getS14().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS15().getFloat32(), (double)output.get(i).getS15().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf8() throws TornadoExecutionPlanException {
        int size = 8;
        VectorHalf8 a = new VectorHalf8(size);
        VectorHalf8 b = new VectorHalf8(size);
        VectorHalf8 output = new VectorHalf8(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half8(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
            b.set(i, new Half8(new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size - (float)i), new HalfFloat((float)size)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHalfFloats::addVectorHalf8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half8 sequential = new Half8(new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + (size - i))), new HalfFloat((float)(i + size)));
            Assert.assertEquals((double)sequential.getS0().getFloat32(), (double)output.get(i).getS0().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1().getFloat32(), (double)output.get(i).getS1().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2().getFloat32(), (double)output.get(i).getS2().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3().getFloat32(), (double)output.get(i).getS3().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4().getFloat32(), (double)output.get(i).getS4().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5().getFloat32(), (double)output.get(i).getS5().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6().getFloat32(), (double)output.get(i).getS6().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7().getFloat32(), (double)output.get(i).getS7().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf8_Storage() throws TornadoExecutionPlanException {
        int size = 8;
        VectorHalf8 a = new VectorHalf8(size);
        VectorHalf8 output = new VectorHalf8(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Half8(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestHalfFloats::testVectorHalf8Storage, (Object)a, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Half8 sequential = new Half8(new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i), new HalfFloat((float)i));
            Assert.assertEquals((double)sequential.getS0().getFloat32(), (double)output.get(i).getS0().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1().getFloat32(), (double)output.get(i).getS1().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2().getFloat32(), (double)output.get(i).getS2().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3().getFloat32(), (double)output.get(i).getS3().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4().getFloat32(), (double)output.get(i).getS4().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5().getFloat32(), (double)output.get(i).getS5().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6().getFloat32(), (double)output.get(i).getS6().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7().getFloat32(), (double)output.get(i).getS7().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testDotProduct() throws TornadoExecutionPlanException {
        int size = 8;
        HalfFloatArray a = new HalfFloatArray(size);
        HalfFloatArray b = new HalfFloatArray(size);
        HalfFloatArray outputMap = new HalfFloatArray(size);
        HalfFloatArray outputReduce = new HalfFloatArray(1);
        HalfFloatArray seqMap = new HalfFloatArray(size);
        HalfFloatArray seqReduce = new HalfFloatArray(1);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            a.set(i, new HalfFloat(r.nextFloat()));
            b.set(i, new HalfFloat(r.nextFloat()));
        }
        TestHalfFloats.dotProductFunctionMap(a, b, seqMap);
        TestHalfFloats.dotProductFunctionReduce(seqMap, seqReduce);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b, outputMap}).task("t0-MAP", TestHalfFloats::dotProductFunctionMap, (Object)a, (Object)b, (Object)outputMap).task("t1-REDUCE", TestHalfFloats::dotProductFunctionReduce, (Object)outputMap, (Object)outputReduce).transferToHost(1, new Object[]{outputReduce});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)seqReduce.get(0).getFloat32(), (double)outputReduce.get(0).getFloat32(), (double)0.001);
    }

    @Test
    public void vectorPhiTest() throws TornadoExecutionPlanException {
        VectorHalf3 input = new VectorHalf3(8);
        VectorHalf3 output = new VectorHalf3(1);
        input.fill(new HalfFloat(1.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestHalfFloats::vectorPhiTest, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)8.0, (double)output.get(0).getS0().getFloat32(), (double)0.001);
        Assert.assertEquals((double)8.0, (double)output.get(0).getS1().getFloat32(), (double)0.001);
        Assert.assertEquals((double)8.0, (double)output.get(0).getS2().getFloat32(), (double)0.001);
    }

    @Test
    public void privateVectorHalf2() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf2 sequentialOutput = new VectorHalf2(size);
        VectorHalf2 tornadoOutput = new VectorHalf2(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestHalfFloats::testPrivateVectorHalf2, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.testPrivateVectorHalf2(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void privateVectorHalf4() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf4 sequentialOutput = new VectorHalf4(size);
        VectorHalf4 tornadoOutput = new VectorHalf4(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestHalfFloats::testPrivateVectorHalf4, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.testPrivateVectorHalf4(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ().getFloat32(), (double)tornadoOutput.get(i).getZ().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getW().getFloat32(), (double)tornadoOutput.get(i).getW().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void privateVectorHalf8() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf8 sequentialOutput = new VectorHalf8(16);
        VectorHalf8 tornadoOutput = new VectorHalf8(16);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestHalfFloats::testPrivateVectorHalf8, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.testPrivateVectorHalf8(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getS0().getFloat32(), (double)tornadoOutput.get(i).getS0().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS1().getFloat32(), (double)tornadoOutput.get(i).getS1().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS2().getFloat32(), (double)tornadoOutput.get(i).getS2().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS3().getFloat32(), (double)tornadoOutput.get(i).getS3().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS4().getFloat32(), (double)tornadoOutput.get(i).getS4().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS5().getFloat32(), (double)tornadoOutput.get(i).getS5().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS6().getFloat32(), (double)tornadoOutput.get(i).getS6().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS7().getFloat32(), (double)tornadoOutput.get(i).getS7().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testVectorHalf4_Unary() throws TornadoExecutionPlanException {
        int size = 256;
        VectorHalf4 sequentialOutput = new VectorHalf4(size);
        VectorHalf4 output = new VectorHalf4(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestHalfFloats::vectorHalfUnary, (Object)output);
        taskGraph.transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.vectorHalfUnary(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)output.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)output.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ().getFloat32(), (double)output.get(i).getZ().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getW().getFloat32(), (double)output.get(i).getW().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod01() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf2 tornadoInput = new VectorHalf2(16);
        VectorHalf2 sequentialInput = new VectorHalf2(16);
        VectorHalf2 tornadoOutput = new VectorHalf2(16);
        VectorHalf2 sequentialOutput = new VectorHalf2(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Half2 half2 = new Half2(new HalfFloat(value), new HalfFloat(value));
            tornadoInput.set(i, half2);
            sequentialInput.set(i, half2);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestHalfFloats::vectorComputation01, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.vectorComputation01(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod02() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf3 tornadoInput = new VectorHalf3(16);
        VectorHalf3 sequentialInput = new VectorHalf3(16);
        VectorHalf3 tornadoOutput = new VectorHalf3(16);
        VectorHalf3 sequentialOutput = new VectorHalf3(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Half3 float3 = new Half3(new HalfFloat(value), new HalfFloat(value), new HalfFloat(value));
            tornadoInput.set(i, float3);
            sequentialInput.set(i, float3);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestHalfFloats::vectorComputation02, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.vectorComputation02(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ().getFloat32(), (double)tornadoOutput.get(i).getZ().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod03() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf4 tornadoInput = new VectorHalf4(16);
        VectorHalf4 sequentialInput = new VectorHalf4(16);
        VectorHalf3 tornadoOutput = new VectorHalf3(16);
        VectorHalf3 sequentialOutput = new VectorHalf3(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Half4 half4 = new Half4(new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value));
            tornadoInput.set(i, half4);
            sequentialInput.set(i, half4);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestHalfFloats::vectorComputation03, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.vectorComputation03(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ().getFloat32(), (double)tornadoOutput.get(i).getZ().getFloat32(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod04() throws TornadoExecutionPlanException {
        int size = 16;
        VectorHalf8 tornadoInput = new VectorHalf8(16);
        VectorHalf8 sequentialInput = new VectorHalf8(16);
        VectorHalf2 tornadoOutput = new VectorHalf2(16);
        VectorHalf2 sequentialOutput = new VectorHalf2(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Half8 half8 = new Half8(new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value), new HalfFloat(value));
            tornadoInput.set(i, half8);
            sequentialInput.set(i, half8);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestHalfFloats::vectorComputation04, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestHalfFloats.vectorComputation04(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX().getFloat32(), (double)tornadoOutput.get(i).getX().getFloat32(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY().getFloat32(), (double)tornadoOutput.get(i).getY().getFloat32(), (double)0.001);
        }
    }

    @Test(timeout=1000L)
    public void testAllocationIssue() {
        int size = 0x2000000;
        VectorHalf4 buffer = new VectorHalf4(size);
        for (int x = 0; x < size; ++x) {
            buffer.set(x, new Half4(new HalfFloat((float)x), new HalfFloat((float)x), new HalfFloat((float)x), new HalfFloat((float)x)));
        }
    }
}

