/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.vectortypes;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat16;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat2;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat4;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat8;
import uk.ac.manchester.tornado.api.types.collections.VectorInt16;
import uk.ac.manchester.tornado.api.types.collections.VectorInt2;
import uk.ac.manchester.tornado.api.types.collections.VectorInt4;
import uk.ac.manchester.tornado.api.types.collections.VectorInt8;
import uk.ac.manchester.tornado.api.types.vectors.Float16;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;
import uk.ac.manchester.tornado.api.types.vectors.Int16;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.Int4;
import uk.ac.manchester.tornado.api.types.vectors.Int8;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestFloats
extends TornadoTestBase {
    public static final double DELTA = 0.001;

    private static void dotMethodFloat2(Float2 a, Float2 b, VectorFloat result) {
        float dot = Float2.dot((Float2)a, (Float2)b);
        result.set(0, dot);
    }

    private static void dotMethodFloat3(Float3 a, Float3 b, VectorFloat result) {
        float dot = Float3.dot((Float3)a, (Float3)b);
        result.set(0, dot);
    }

    private static void dotMethodFloat4(Float4 a, Float4 b, VectorFloat result) {
        float dot = Float4.dot((Float4)a, (Float4)b);
        result.set(0, dot);
    }

    private static void dotMethodFloat8(Float8 a, Float8 b, VectorFloat result) {
        float dot = Float8.dot((Float8)a, (Float8)b);
        result.set(0, dot);
    }

    private static void dotMethodFloat16(Float16 a, Float16 b, VectorFloat result) {
        float dot = Float16.dot((Float16)a, (Float16)b);
        result.set(0, dot);
    }

    private static void testFloat3Add(Float3 a, Float3 b, VectorFloat3 results) {
        results.set(0, Float3.add((Float3)a, (Float3)b));
    }

    private static void addFloat(Float[] a, Float[] b, Float[] result) {
        for (int i = 0; i < a.length; ++i) {
            result[i] = Float.valueOf(a[i].floatValue() + b[i].floatValue());
        }
    }

    private static void addFloat2(Float2[] a, Float2[] b, Float2[] result) {
        for (int i = 0; i < a.length; ++i) {
            result[i] = Float2.add((Float2)a[i], (Float2)b[i]);
        }
    }

    public static void addVectorFloat2(VectorFloat2 a, VectorFloat2 b, VectorFloat2 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Float2.add((Float2)a.get(i), (Float2)b.get(i)));
        }
    }

    public static void addVectorFloat3(VectorFloat3 a, VectorFloat3 b, VectorFloat3 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Float3.add((Float3)a.get(i), (Float3)b.get(i)));
        }
    }

    public static void addVectorFloat4(VectorFloat4 a, VectorFloat4 b, VectorFloat4 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Float4.add((Float4)a.get(i), (Float4)b.get(i)));
        }
    }

    public static void addVectorFloat8(VectorFloat8 a, VectorFloat8 b, VectorFloat8 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Float8.add((Float8)a.get(i), (Float8)b.get(i)));
        }
    }

    public static void addVectorFloat16(VectorFloat16 a, VectorFloat16 b, VectorFloat16 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Float16.add((Float16)a.get(i), (Float16)b.get(i)));
        }
    }

    public static void testVectorFloat8Storage(VectorFloat8 a, VectorFloat8 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, a.get(i));
        }
    }

    public static void dotProductFunctionMap(FloatArray a, FloatArray b, FloatArray results) {
        for (int i = 0; i < a.getSize(); ++i) {
            results.set(i, a.get(i) * b.get(i));
        }
    }

    public static void dotProductFunctionReduce(FloatArray input, FloatArray results) {
        float sum = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            sum += input.get(i);
        }
        results.set(0, sum);
    }

    private static void vectorPhiTest(VectorFloat3 input, VectorFloat3 output) {
        Float3 sum = new Float3();
        for (int i = 0; i < input.getLength(); ++i) {
            sum = Float3.add((Float3)sum, (Float3)input.get(i));
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorFloat2(VectorFloat2 output) {
        VectorFloat2 vectorFloat2 = new VectorFloat2(output.getLength());
        for (int i = 0; i < vectorFloat2.getLength(); ++i) {
            vectorFloat2.set(i, new Float2((float)i, (float)i));
        }
        Float2 sum = new Float2(0.0f, 0.0f);
        for (int i = 0; i < vectorFloat2.getLength(); ++i) {
            Float2 f = vectorFloat2.get(i);
            sum = Float2.add((Float2)f, (Float2)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorFloat4(VectorFloat4 output) {
        VectorFloat4 vectorFloat4 = new VectorFloat4(output.getLength());
        for (int i = 0; i < vectorFloat4.getLength(); ++i) {
            vectorFloat4.set(i, new Float4((float)i, (float)i, (float)i, (float)i));
        }
        Float4 sum = new Float4(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < vectorFloat4.getLength(); ++i) {
            Float4 f = vectorFloat4.get(i);
            sum = Float4.add((Float4)f, (Float4)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorFloat8(VectorFloat8 output) {
        VectorFloat8 vectorFloat8 = new VectorFloat8(output.getLength());
        for (int i = 0; i < vectorFloat8.getLength(); ++i) {
            vectorFloat8.set(i, new Float8((float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i));
        }
        Float8 sum = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < vectorFloat8.getLength(); ++i) {
            Float8 f = vectorFloat8.get(i);
            sum = Float8.add((Float8)f, (Float8)sum);
        }
        output.set(0, sum);
    }

    public static void vectorFloatUnary(VectorFloat4 vector) {
        for (int i = 0; i < vector.getLength(); ++i) {
            Float4 f4 = vector.get(i);
            float a = -f4.getX();
            vector.set(i, new Float4(a, f4.getY(), f4.getZ(), f4.getW()));
        }
    }

    private static void vectorComputation01(VectorFloat2 value, VectorFloat2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float2 float2 = new Float2();
            float2.setX(value.get(i).getX() + value.get(i).getY());
            float2.setY(value.get(i).getX() * 2.0f);
            output.set(i, float2);
        }
    }

    private static void vectorComputation02(VectorFloat3 value, VectorFloat3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float3 float3 = new Float3();
            float3.setX(value.get(i).getX() + value.get(i).getY());
            float3.setY(value.get(i).getZ() * 2.0f);
            output.set(i, float3);
        }
    }

    private static Float3 vectorComputation03(Float4 value) {
        Float3 output = new Float3();
        output.setX(value.getX() + value.getY());
        output.setY(value.getY());
        output.setZ(value.getW());
        return output;
    }

    private static void vectorComputation03(VectorFloat4 value, VectorFloat3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            output.set(i, TestFloats.vectorComputation03(value.get(i)));
        }
    }

    private static void vectorComputation04(VectorFloat8 value, VectorFloat2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float2 float2 = new Float2();
            float2.setX(value.get(i).getS0() + value.get(i).getS1());
            float2.setY(value.get(i).getS1());
            output.set(i, float2);
        }
    }

    private static void vectorComputationMixedTypes(VectorFloat2 a, VectorInt2 b, VectorFloat2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float2 result = Float2.mult((Float2)a.get(i), (Int2)b.get(i));
            output.set(i, result);
        }
    }

    private static void vectorComputationMixedTypes(VectorFloat4 a, VectorInt4 b, VectorFloat4 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float4 result = Float4.mult((Float4)a.get(i), (Int4)b.get(i));
            output.set(i, result);
        }
    }

    private static void vectorComputationMixedTypes(VectorFloat8 a, VectorInt8 b, VectorFloat8 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float8 result = Float8.mult((Float8)a.get(i), (Int8)b.get(i));
            output.set(i, result);
        }
    }

    private static void vectorComputationMixedTypes(VectorFloat16 a, VectorInt16 b, VectorFloat16 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float16 result = Float16.mult((Float16)a.get(i), (Int16)b.get(i));
            output.set(i, result);
        }
    }

    private static void vectorComputationMixedTypes(VectorFloat4 a, VectorFloat4 b, VectorFloat4 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float4 result = Float4.mult((Float4)a.get(i), (Float4)b.get(i));
            output.set(i, result);
        }
    }

    @Test
    public void testSimpleDotProductFloat2() throws TornadoExecutionPlanException {
        Float2 a = new Float2(1.0f, 2.0f);
        Float2 b = new Float2(3.0f, 2.0f);
        VectorFloat output = new VectorFloat(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::dotMethodFloat2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)7.0, (double)output.get(0), (double)0.001);
    }

    @Test
    public void testSimpleDotProductFloat3() throws TornadoExecutionPlanException {
        Float3 a = new Float3(1.0f, 2.0f, 3.0f);
        Float3 b = new Float3(3.0f, 2.0f, 1.0f);
        VectorFloat output = new VectorFloat(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::dotMethodFloat3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)10.0, (double)output.get(0), (double)0.001);
    }

    @Test
    public void testSimpleDotProductFloat4() throws TornadoExecutionPlanException {
        Float4 a = new Float4(1.0f, 2.0f, 3.0f, 4.0f);
        Float4 b = new Float4(4.0f, 3.0f, 2.0f, 1.0f);
        VectorFloat output = new VectorFloat(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::dotMethodFloat4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)20.0, (double)output.get(0), (double)0.001);
    }

    @Test
    public void testSimpleDotProductFloat8() throws TornadoExecutionPlanException {
        Float8 a = new Float8(1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f);
        Float8 b = new Float8(8.0f, 7.0f, 6.0f, 5.0f, 4.0f, 3.0f, 2.0f, 1.0f);
        VectorFloat output = new VectorFloat(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::dotMethodFloat8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)120.0, (double)output.get(0), (double)0.001);
    }

    @Test
    public void testSimpleDotProductFloat16() throws TornadoExecutionPlanException {
        Float16 a = new Float16(1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        Float16 b = new Float16(8.0f, 7.0f, 6.0f, 5.0f, 4.0f, 3.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VectorFloat output = new VectorFloat(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::dotMethodFloat16, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)120.0, (double)output.get(0), (double)0.001);
    }

    @Test
    public void testSimpleVectorAddition() throws TornadoExecutionPlanException {
        int size = 1;
        Float3 a = new Float3(1.0f, 2.0f, 3.0f);
        Float3 b = new Float3(3.0f, 2.0f, 1.0f);
        VectorFloat3 output = new VectorFloat3(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::testFloat3Add, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)4.0, (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)4.0, (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)4.0, (double)output.get(i).getZ(), (double)0.001);
        }
    }

    @TornadoNotSupported
    public void testFloat1() throws TornadoExecutionPlanException {
        int size = 8;
        Float[] a = new Float[size];
        Float[] b = new Float[size];
        Object[] output = new Float[size];
        for (int i = 0; i < size; ++i) {
            a[i] = Float.valueOf(i);
            b[i] = Float.valueOf(i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addFloat, (Object)a, (Object)b, (Object)output).transferToHost(1, output);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)(i + i), (double)((Float)output[i]).floatValue(), (double)0.001);
        }
    }

    @TornadoNotSupported
    public void testFloat2() throws TornadoExecutionPlanException {
        int size = 8;
        Float2[] a = new Float2[size];
        Float2[] b = new Float2[size];
        Object[] output = new Float2[size];
        for (int i = 0; i < size; ++i) {
            a[i] = new Float2((float)i, (float)i);
            b[i] = new Float2((float)i, (float)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addFloat2, (Object)a, (Object)b, (Object)output).transferToHost(1, output);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float2 sequential = new Float2((float)(i + i), (float)(i + i));
            Assert.assertEquals((double)sequential.getX(), (double)output[i].getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output[i].getY(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat2() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat2 a = new VectorFloat2(size);
        VectorFloat2 b = new VectorFloat2(size);
        VectorFloat2 output = new VectorFloat2(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float2((float)i, (float)i));
            b.set(i, new Float2((float)(size - i), (float)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float2 sequential = new Float2((float)(i + (size - i)), (float)(i + (size - i)));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat3() throws TornadoExecutionPlanException {
        int size = 8;
        VectorFloat3 a = new VectorFloat3(size);
        VectorFloat3 b = new VectorFloat3(size);
        VectorFloat3 output = new VectorFloat3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float3((float)i, (float)i, (float)i));
            b.set(i, new Float3((float)(size - i), (float)(size - i), (float)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float3 sequential = new Float3((float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat3toString() throws TornadoExecutionPlanException {
        int size = 2;
        VectorFloat3 a = new VectorFloat3(size);
        VectorFloat3 b = new VectorFloat3(size);
        VectorFloat3 output = new VectorFloat3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float3((float)i, (float)i, (float)i));
            b.set(i, new Float3((float)size - (float)i, (float)size - (float)i, (float)size - (float)i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void testVectorFloat4() throws TornadoExecutionPlanException {
        int size = 8;
        VectorFloat4 a = new VectorFloat4(size);
        VectorFloat4 b = new VectorFloat4(size);
        VectorFloat4 output = new VectorFloat4(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float4((float)i, (float)i, (float)i, (float)i));
            b.set(i, new Float4((float)(size - i), (float)(size - i), (float)(size - i), (float)size));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float4 sequential = new Float4((float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequential.getW(), (double)output.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat16() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat16 a = new VectorFloat16(size);
        VectorFloat16 b = new VectorFloat16(size);
        VectorFloat16 output = new VectorFloat16(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float16((float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i));
            b.set(i, new Float16((float)(size - i), (float)(size - i), (float)(size - i), (float)size, (float)(size - i), (float)(size - i), (float)(size - i), (float)size, (float)(size - i), (float)(size - i), (float)(size - i), (float)size, (float)(size - i), (float)(size - i), (float)(size - i), (float)size));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat16, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float16 sequential = new Float16((float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size));
            Assert.assertEquals((double)sequential.getS0(), (double)output.get(i).getS0(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1(), (double)output.get(i).getS1(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2(), (double)output.get(i).getS2(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3(), (double)output.get(i).getS3(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4(), (double)output.get(i).getS4(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5(), (double)output.get(i).getS5(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6(), (double)output.get(i).getS6(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7(), (double)output.get(i).getS7(), (double)0.001);
            Assert.assertEquals((double)sequential.getS8(), (double)output.get(i).getS8(), (double)0.001);
            Assert.assertEquals((double)sequential.getS9(), (double)output.get(i).getS9(), (double)0.001);
            Assert.assertEquals((double)sequential.getS10(), (double)output.get(i).getS10(), (double)0.001);
            Assert.assertEquals((double)sequential.getS11(), (double)output.get(i).getS11(), (double)0.001);
            Assert.assertEquals((double)sequential.getS12(), (double)output.get(i).getS12(), (double)0.001);
            Assert.assertEquals((double)sequential.getS13(), (double)output.get(i).getS13(), (double)0.001);
            Assert.assertEquals((double)sequential.getS14(), (double)output.get(i).getS14(), (double)0.001);
            Assert.assertEquals((double)sequential.getS15(), (double)output.get(i).getS15(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat8() throws TornadoExecutionPlanException {
        int size = 8;
        VectorFloat8 a = new VectorFloat8(size);
        VectorFloat8 b = new VectorFloat8(size);
        VectorFloat8 output = new VectorFloat8(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float8((float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i));
            b.set(i, new Float8((float)(size - i), (float)(size - i), (float)(size - i), (float)size, (float)(size - i), (float)(size - i), (float)(size - i), (float)size));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestFloats::addVectorFloat8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float8 sequential = new Float8((float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + (size - i)), (float)(i + size));
            Assert.assertEquals((double)sequential.getS0(), (double)output.get(i).getS0(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1(), (double)output.get(i).getS1(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2(), (double)output.get(i).getS2(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3(), (double)output.get(i).getS3(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4(), (double)output.get(i).getS4(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5(), (double)output.get(i).getS5(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6(), (double)output.get(i).getS6(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7(), (double)output.get(i).getS7(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat8_Storage() throws TornadoExecutionPlanException {
        int size = 8;
        VectorFloat8 a = new VectorFloat8(size);
        VectorFloat8 output = new VectorFloat8(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Float8((float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestFloats::testVectorFloat8Storage, (Object)a, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Float8 sequential = new Float8((float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i, (float)i);
            Assert.assertEquals((double)sequential.getS0(), (double)output.get(i).getS0(), (double)0.001);
            Assert.assertEquals((double)sequential.getS1(), (double)output.get(i).getS1(), (double)0.001);
            Assert.assertEquals((double)sequential.getS2(), (double)output.get(i).getS2(), (double)0.001);
            Assert.assertEquals((double)sequential.getS3(), (double)output.get(i).getS3(), (double)0.001);
            Assert.assertEquals((double)sequential.getS4(), (double)output.get(i).getS4(), (double)0.001);
            Assert.assertEquals((double)sequential.getS5(), (double)output.get(i).getS5(), (double)0.001);
            Assert.assertEquals((double)sequential.getS6(), (double)output.get(i).getS6(), (double)0.001);
            Assert.assertEquals((double)sequential.getS7(), (double)output.get(i).getS7(), (double)0.001);
        }
    }

    @Test
    public void testDotProduct() throws TornadoExecutionPlanException {
        int size = 8;
        FloatArray a = new FloatArray(size);
        FloatArray b = new FloatArray(size);
        FloatArray outputMap = new FloatArray(size);
        FloatArray outputReduce = new FloatArray(1);
        FloatArray seqMap = new FloatArray(size);
        FloatArray seqReduce = new FloatArray(1);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            a.set(i, r.nextFloat());
            b.set(i, r.nextFloat());
        }
        TestFloats.dotProductFunctionMap(a, b, seqMap);
        TestFloats.dotProductFunctionReduce(seqMap, seqReduce);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b, outputMap}).task("t0-MAP", TestFloats::dotProductFunctionMap, (Object)a, (Object)b, (Object)outputMap).task("t1-REDUCE", TestFloats::dotProductFunctionReduce, (Object)outputMap, (Object)outputReduce).transferToHost(1, new Object[]{outputReduce});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)seqReduce.get(0), (double)outputReduce.get(0), (double)0.001);
    }

    @Test
    public void vectorPhiTest() throws TornadoExecutionPlanException {
        VectorFloat3 input = new VectorFloat3(8);
        VectorFloat3 output = new VectorFloat3(1);
        input.fill(1.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestFloats::vectorPhiTest, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)8.0, (double)output.get(0).getS0(), (double)0.001);
        Assert.assertEquals((double)8.0, (double)output.get(0).getS1(), (double)0.001);
        Assert.assertEquals((double)8.0, (double)output.get(0).getS2(), (double)0.001);
    }

    @Test
    public void privateVectorFloat2() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat2 sequentialOutput = new VectorFloat2(size);
        VectorFloat2 tornadoOutput = new VectorFloat2(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestFloats::testPrivateVectorFloat2, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.testPrivateVectorFloat2(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void privateVectorFloat4() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat4 sequentialOutput = new VectorFloat4(size);
        VectorFloat4 tornadoOutput = new VectorFloat4(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestFloats::testPrivateVectorFloat4, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.testPrivateVectorFloat4(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getW(), (double)tornadoOutput.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void privateVectorFloat8() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat8 sequentialOutput = new VectorFloat8(16);
        VectorFloat8 tornadoOutput = new VectorFloat8(16);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestFloats::testPrivateVectorFloat8, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.testPrivateVectorFloat8(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getS0(), (double)tornadoOutput.get(i).getS0(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS1(), (double)tornadoOutput.get(i).getS1(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS2(), (double)tornadoOutput.get(i).getS2(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS3(), (double)tornadoOutput.get(i).getS3(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS4(), (double)tornadoOutput.get(i).getS4(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS5(), (double)tornadoOutput.get(i).getS5(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS6(), (double)tornadoOutput.get(i).getS6(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS7(), (double)tornadoOutput.get(i).getS7(), (double)0.001);
        }
    }

    @Test
    public void testVectorFloat4_Unary() throws TornadoExecutionPlanException {
        int size = 256;
        VectorFloat4 sequentialOutput = new VectorFloat4(size);
        VectorFloat4 output = new VectorFloat4(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestFloats::vectorFloatUnary, (Object)output);
        taskGraph.transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.vectorFloatUnary(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)output.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getW(), (double)output.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod01() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat2 tornadoInput = new VectorFloat2(16);
        VectorFloat2 sequentialInput = new VectorFloat2(16);
        VectorFloat2 tornadoOutput = new VectorFloat2(16);
        VectorFloat2 sequentialOutput = new VectorFloat2(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Float2 float2 = new Float2(value, value);
            tornadoInput.set(i, float2);
            sequentialInput.set(i, float2);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestFloats::vectorComputation01, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.vectorComputation01(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod02() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat3 tornadoInput = new VectorFloat3(16);
        VectorFloat3 sequentialInput = new VectorFloat3(16);
        VectorFloat3 tornadoOutput = new VectorFloat3(16);
        VectorFloat3 sequentialOutput = new VectorFloat3(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Float3 float3 = new Float3(value, value, value);
            tornadoInput.set(i, float3);
            sequentialInput.set(i, float3);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestFloats::vectorComputation02, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.vectorComputation02(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod03() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat4 tornadoInput = new VectorFloat4(16);
        VectorFloat4 sequentialInput = new VectorFloat4(16);
        VectorFloat3 tornadoOutput = new VectorFloat3(16);
        VectorFloat3 sequentialOutput = new VectorFloat3(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Float4 float4 = new Float4(value, value, value, value);
            tornadoInput.set(i, float4);
            sequentialInput.set(i, float4);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestFloats::vectorComputation03, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.vectorComputation03(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod04() throws TornadoExecutionPlanException {
        int size = 16;
        VectorFloat8 tornadoInput = new VectorFloat8(16);
        VectorFloat8 sequentialInput = new VectorFloat8(16);
        VectorFloat2 tornadoOutput = new VectorFloat2(16);
        VectorFloat2 sequentialOutput = new VectorFloat2(16);
        for (int i = 0; i < 16; ++i) {
            float value = (float)Math.random();
            Float8 float8 = new Float8(value, value, value, value, value, value, value, value);
            tornadoInput.set(i, float8);
            sequentialInput.set(i, float8);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestFloats::vectorComputation04, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFloats.vectorComputation04(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }

    @Test(timeout=1000L)
    public void testAllocationIssue() {
        int size = 0x2000000;
        VectorFloat4 buffer = new VectorFloat4(size);
        for (int x = 0; x < size; ++x) {
            buffer.set(x, new Float4((float)x, (float)x, (float)x, (float)x));
        }
    }

    @Test
    public void testVectorFloat4Float4() throws TornadoExecutionPlanException {
        int size = 8192;
        VectorFloat4 a = new VectorFloat4(size);
        VectorFloat4 b = new VectorFloat4(size);
        VectorFloat4 output = new VectorFloat4(size);
        VectorFloat4 seq = new VectorFloat4(size);
        for (int x = 0; x < b.getLength(); ++x) {
            a.set(x, new Float4((float)x, (float)x, (float)x, (float)x));
            b.set(x, new Float4(0.0f, 1.0f, 2.0f, 3.0f));
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestFloats::vectorComputationMixedTypes, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TestFloats.vectorComputationMixedTypes(a, b, seq);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)seq.get(i).getX(), (double)output.get(i).getX(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getY(), (double)output.get(i).getY(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getZ(), (double)output.get(i).getZ(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getW(), (double)output.get(i).getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testVectorFloat2Int2() throws TornadoExecutionPlanException {
        int size = 8192;
        VectorFloat2 a = new VectorFloat2(size);
        VectorInt2 b = new VectorInt2(size);
        VectorFloat2 output = new VectorFloat2(size);
        VectorFloat2 seq = new VectorFloat2(size);
        Random r = new Random();
        for (int i = 0; i < b.getLength(); ++i) {
            a.set(i, new Float2(r.nextFloat(), r.nextFloat()));
            b.set(i, new Int2(r.nextInt(), r.nextInt()));
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestFloats::vectorComputationMixedTypes, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TestFloats.vectorComputationMixedTypes(a, b, seq);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)seq.get(i).getX(), (double)output.get(i).getX(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getY(), (double)output.get(i).getY(), (double)0.001);
            }
        }
    }

    @Test
    public void testVectorFloat4Int4() throws TornadoExecutionPlanException {
        int size = 8192;
        VectorFloat4 a = new VectorFloat4(size);
        VectorInt4 b = new VectorInt4(size);
        VectorFloat4 output = new VectorFloat4(size);
        VectorFloat4 seq = new VectorFloat4(size);
        Random r = new Random();
        for (int i = 0; i < b.getLength(); ++i) {
            a.set(i, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
            b.set(i, new Int4(r.nextInt(), r.nextInt(), r.nextInt(), r.nextInt()));
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestFloats::vectorComputationMixedTypes, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TestFloats.vectorComputationMixedTypes(a, b, seq);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            for (int i = 0; i < size; ++i) {
                Assert.assertEquals((double)seq.get(i).getX(), (double)output.get(i).getX(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getY(), (double)output.get(i).getY(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getZ(), (double)output.get(i).getZ(), (double)0.001);
                Assert.assertEquals((double)seq.get(i).getW(), (double)output.get(i).getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testVectorFloat8Int8() throws TornadoExecutionPlanException {
        int size = 8192;
        VectorFloat8 a = new VectorFloat8(size);
        VectorInt8 b = new VectorInt8(size);
        VectorFloat8 output = new VectorFloat8(size);
        VectorFloat8 seq = new VectorFloat8(size);
        Random r = new Random();
        IntStream.range(0, b.getLength()).forEach(i -> {
            Float8 vectorFloat = new Float8();
            IntStream.range(0, vectorFloat.size()).forEach(j -> vectorFloat.set(j, r.nextFloat()));
            a.set(i, vectorFloat);
            Int8 vectorInt = new Int8();
            IntStream.range(0, vectorInt.size()).forEach(j -> vectorInt.set(j, r.nextInt()));
            b.set(i, vectorInt);
        });
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestFloats::vectorComputationMixedTypes, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TestFloats.vectorComputationMixedTypes(a, b, seq);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            for (int i2 = 0; i2 < size; ++i2) {
                for (int k = 0; k < 8; ++k) {
                    Assert.assertEquals((double)seq.get(i2).get(k), (double)output.get(i2).get(k), (double)0.001);
                }
            }
        }
    }

    @Test
    public void testVectorFloat16Int16() throws TornadoExecutionPlanException {
        int size = 8192;
        VectorFloat16 a = new VectorFloat16(size);
        VectorInt16 b = new VectorInt16(size);
        VectorFloat16 output = new VectorFloat16(size);
        VectorFloat16 seq = new VectorFloat16(size);
        Random r = new Random();
        IntStream.range(0, b.getLength()).forEach(i -> {
            Float16 vectorFloat = new Float16();
            IntStream.range(0, vectorFloat.size()).forEach(j -> vectorFloat.set(j, r.nextFloat()));
            a.set(i, vectorFloat);
            Int16 vectorInt = new Int16();
            IntStream.range(0, vectorInt.size()).forEach(j -> vectorInt.set(j, r.nextInt()));
            b.set(i, vectorInt);
        });
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestFloats::vectorComputationMixedTypes, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TestFloats.vectorComputationMixedTypes(a, b, seq);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            for (int i2 = 0; i2 < size; ++i2) {
                for (int k = 0; k < 16; ++k) {
                    Assert.assertEquals((double)seq.get(i2).get(k), (double)output.get(i2).get(k), (double)0.001);
                }
            }
        }
    }
}

