/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.vectortypes;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble16;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble2;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble3;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble4;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble8;
import uk.ac.manchester.tornado.api.types.vectors.Double16;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.Double3;
import uk.ac.manchester.tornado.api.types.vectors.Double4;
import uk.ac.manchester.tornado.api.types.vectors.Double8;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestDoubles
extends TornadoTestBase {
    public static final double DELTA = 0.001;

    private static void addDouble2(Double2 a, Double2 b, VectorDouble results) {
        Double2 d2 = Double2.add((Double2)a, (Double2)b);
        double r = d2.getX() + d2.getY();
        results.set(0, r);
    }

    private static void addDouble3(Double3 a, Double3 b, VectorDouble results) {
        Double3 d3 = Double3.add((Double3)a, (Double3)b);
        double r = d3.getX() + d3.getY() + d3.getZ();
        results.set(0, r);
    }

    private static void addDouble4(Double4 a, Double4 b, VectorDouble results) {
        Double4 d4 = Double4.add((Double4)a, (Double4)b);
        double r = d4.getX() + d4.getY() + d4.getZ() + d4.getW();
        results.set(0, r);
    }

    private static void addDouble8(Double8 a, Double8 b, VectorDouble results) {
        Double8 d8 = Double8.add((Double8)a, (Double8)b);
        double r = d8.getS0() + d8.getS1() + d8.getS2() + d8.getS3() + d8.getS4() + d8.getS5() + d8.getS6() + d8.getS7();
        results.set(0, r);
    }

    private static void addDouble(DoubleArray a, DoubleArray b, DoubleArray result) {
        for (int i = 0; i < a.getSize(); ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
    }

    public static void dotProductFunctionMap(DoubleArray a, DoubleArray b, DoubleArray results) {
        for (int i = 0; i < a.getSize(); ++i) {
            results.set(i, a.get(i) * b.get(i));
        }
    }

    public static void dotProductFunctionReduce(DoubleArray input, DoubleArray results) {
        double sum = 0.0;
        for (int i = 0; i < input.getSize(); ++i) {
            sum += input.get(i);
        }
        results.set(0, sum);
    }

    public static void addVectorDouble2(VectorDouble2 a, VectorDouble2 b, VectorDouble2 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Double2.add((Double2)a.get(i), (Double2)b.get(i)));
        }
    }

    public static void addVectorDouble3(VectorDouble3 a, VectorDouble3 b, VectorDouble3 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Double3.add((Double3)a.get(i), (Double3)b.get(i)));
        }
    }

    public static void addVectorDouble4(VectorDouble4 a, VectorDouble4 b, VectorDouble4 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Double4.add((Double4)a.get(i), (Double4)b.get(i)));
        }
    }

    public static void addVectorDouble8(VectorDouble8 a, VectorDouble8 b, VectorDouble8 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Double8.add((Double8)a.get(i), (Double8)b.get(i)));
        }
    }

    public static void addVectorDouble16(VectorDouble16 a, VectorDouble16 b, VectorDouble16 results) {
        for (int i = 0; i < a.getLength(); ++i) {
            results.set(i, Double16.add((Double16)a.get(i), (Double16)b.get(i)));
        }
    }

    public static void testPrivateVectorDouble2(VectorDouble2 output) {
        VectorDouble2 vectorDouble2 = new VectorDouble2(output.getLength());
        for (int i = 0; i < vectorDouble2.getLength(); ++i) {
            vectorDouble2.set(i, new Double2((double)i, (double)i));
        }
        Double2 sum = new Double2(0.0, 0.0);
        for (int i = 0; i < vectorDouble2.getLength(); ++i) {
            Double2 f = vectorDouble2.get(i);
            sum = Double2.add((Double2)f, (Double2)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorDouble4(VectorDouble4 output) {
        VectorDouble4 vectorDouble4 = new VectorDouble4(output.getLength());
        for (int i = 0; i < vectorDouble4.getLength(); ++i) {
            vectorDouble4.set(i, new Double4((double)i, (double)i, (double)i, (double)i));
        }
        Double4 sum = new Double4(0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < vectorDouble4.getLength(); ++i) {
            Double4 f = vectorDouble4.get(i);
            sum = Double4.add((Double4)f, (Double4)sum);
        }
        output.set(0, sum);
    }

    public static void testPrivateVectorDouble8(VectorDouble8 output) {
        VectorDouble8 vectorDouble8 = new VectorDouble8(output.getLength());
        for (int i = 0; i < vectorDouble8.getLength(); ++i) {
            vectorDouble8.set(i, new Double8((double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i));
        }
        Double8 sum = new Double8(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < vectorDouble8.getLength(); ++i) {
            Double8 f = vectorDouble8.get(i);
            sum = Double8.add((Double8)f, (Double8)sum);
        }
        output.set(0, sum);
    }

    private static void vectorComputation01(VectorDouble2 value, VectorDouble2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Double2 double2 = new Double2();
            double2.setX(value.get(i).getX() + value.get(i).getY());
            double2.setY(value.get(i).getX() * 2.0);
            output.set(i, double2);
        }
    }

    private static void vectorComputation02(VectorDouble3 value, VectorDouble3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Double3 double3 = new Double3();
            double3.setX(value.get(i).getX() + value.get(i).getY());
            double3.setY(value.get(i).getZ() * 2.0);
            output.set(i, double3);
        }
    }

    private static Double3 vectorComputation03(Double4 value) {
        Double3 output = new Double3();
        output.setX(value.getX() + value.getY());
        output.setY(value.getY());
        output.setZ(value.getW());
        return output;
    }

    private static void vectorComputation03(VectorDouble4 value, VectorDouble3 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            output.set(i, TestDoubles.vectorComputation03(value.get(i)));
        }
    }

    private static void vectorComputation04(VectorDouble8 value, VectorDouble2 output) {
        for (int i = 0; i < output.getLength(); ++i) {
            Double2 double2 = new Double2();
            double2.setX(value.get(i).getS0() + value.get(i).getS1());
            double2.setY(value.get(i).getS1());
            output.set(i, double2);
        }
    }

    @Test
    public void testDoubleAdd2() throws TornadoExecutionPlanException {
        int size = 1;
        Double2 a = new Double2(1.0, 2.0);
        Double2 b = new Double2(3.0, 2.0);
        VectorDouble output = new VectorDouble(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addDouble2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)8.0, (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testDoubleAdd3() throws TornadoExecutionPlanException {
        int size = 1;
        Double3 a = new Double3(1.0, 2.0, 3.0);
        Double3 b = new Double3(3.0, 2.0, 1.0);
        VectorDouble output = new VectorDouble(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addDouble3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)12.0, (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testDoubleAdd4() throws TornadoExecutionPlanException {
        int size = 1;
        Double4 a = new Double4(1.0, 2.0, 3.0, 4.0);
        Double4 b = new Double4(4.0, 3.0, 2.0, 1.0);
        VectorDouble output = new VectorDouble(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addDouble4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)20.0, (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testDoubleAdd8() throws TornadoExecutionPlanException {
        int size = 1;
        Double8 a = new Double8(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Double8 b = new Double8(8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0);
        VectorDouble output = new VectorDouble(size);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addDouble8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)72.0, (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testDoubleAdd() throws TornadoExecutionPlanException {
        int size = 8;
        DoubleArray a = new DoubleArray(size);
        DoubleArray b = new DoubleArray(size);
        DoubleArray output = new DoubleArray(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, (double)i);
            b.set(i, (double)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addDouble, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)(i + i), (double)output.get(i), (double)0.001);
        }
    }

    @Test
    public void testDotProductDouble() throws TornadoExecutionPlanException {
        int size = 8;
        DoubleArray a = new DoubleArray(size);
        DoubleArray b = new DoubleArray(size);
        DoubleArray outputMap = new DoubleArray(size);
        DoubleArray outputReduce = new DoubleArray(1);
        DoubleArray seqMap = new DoubleArray(size);
        DoubleArray seqReduce = new DoubleArray(1);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            a.set(i, r.nextDouble());
            b.set(i, r.nextDouble());
        }
        TestDoubles.dotProductFunctionMap(a, b, seqMap);
        TestDoubles.dotProductFunctionReduce(seqMap, seqReduce);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b, outputMap}).task("t0-MAP", TestDoubles::dotProductFunctionMap, (Object)a, (Object)b, (Object)outputMap).task("t1-REDUCE", TestDoubles::dotProductFunctionReduce, (Object)outputMap, (Object)outputReduce).transferToHost(1, new Object[]{outputReduce});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)seqReduce.get(0), (double)outputReduce.get(0), (double)0.001);
    }

    @Test
    public void testVectorDouble2() throws TornadoExecutionPlanException {
        int size = 256;
        VectorDouble2 a = new VectorDouble2(size);
        VectorDouble2 b = new VectorDouble2(size);
        VectorDouble2 output = new VectorDouble2(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Double2((double)i, (double)i));
            b.set(i, new Double2((double)(size - i), (double)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addVectorDouble2, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Double2 sequential = new Double2((double)(i + (size - i)), (double)(i + (size - i)));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void testVectorDouble3() throws TornadoExecutionPlanException {
        int size = 64;
        VectorDouble3 a = new VectorDouble3(size);
        VectorDouble3 b = new VectorDouble3(size);
        VectorDouble3 output = new VectorDouble3(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Double3((double)i, (double)i, (double)i));
            b.set(i, new Double3((double)(size - i), (double)(size - i), (double)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addVectorDouble3, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Double3 sequential = new Double3((double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testVectorDouble4() throws TornadoExecutionPlanException {
        int size = 64;
        VectorDouble4 a = new VectorDouble4(size);
        VectorDouble4 b = new VectorDouble4(size);
        VectorDouble4 output = new VectorDouble4(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Double4((double)i, (double)i, (double)i, (double)i));
            b.set(i, new Double4((double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addVectorDouble4, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Double4 sequential = new Double4((double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)));
            Assert.assertEquals((double)sequential.getX(), (double)output.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequential.getY(), (double)output.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequential.getZ(), (double)output.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequential.getW(), (double)output.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void testVectorDouble8() throws TornadoExecutionPlanException {
        int size = 64;
        VectorDouble8 a = new VectorDouble8(size);
        VectorDouble8 b = new VectorDouble8(size);
        VectorDouble8 output = new VectorDouble8(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Double8((double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i));
            b.set(i, new Double8((double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addVectorDouble8, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Double8 sequential = new Double8((double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)));
            for (int j = 0; j < 8; ++j) {
                Assert.assertEquals((double)sequential.get(j), (double)output.get(i).get(j), (double)0.001);
            }
        }
    }

    @Test
    public void testVectorDouble16() throws TornadoExecutionPlanException {
        int size = 64;
        VectorDouble16 a = new VectorDouble16(size);
        VectorDouble16 b = new VectorDouble16(size);
        VectorDouble16 output = new VectorDouble16(size);
        for (int i = 0; i < size; ++i) {
            a.set(i, new Double16((double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i, (double)i));
            b.set(i, new Double16((double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i), (double)(size - i)));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestDoubles::addVectorDouble16, (Object)a, (Object)b, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < size; ++i) {
            Double16 sequential = new Double16((double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)), (double)(i + (size - i)));
            for (int j = 0; j < 16; ++j) {
                Assert.assertEquals((double)sequential.get(j), (double)output.get(i).get(j), (double)0.001);
            }
        }
    }

    @Test
    public void privateVectorDouble2() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble2 sequentialOutput = new VectorDouble2(size);
        VectorDouble2 tornadoOutput = new VectorDouble2(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestDoubles::testPrivateVectorDouble2, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.testPrivateVectorDouble2(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void privateVectorDouble4() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble4 sequentialOutput = new VectorDouble4(size);
        VectorDouble4 tornadoOutput = new VectorDouble4(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestDoubles::testPrivateVectorDouble4, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.testPrivateVectorDouble4(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getW(), (double)tornadoOutput.get(i).getW(), (double)0.001);
        }
    }

    @Test
    public void privateVectorDouble8() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble8 sequentialOutput = new VectorDouble8(16);
        VectorDouble8 tornadoOutput = new VectorDouble8(16);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestDoubles::testPrivateVectorDouble8, (Object)tornadoOutput);
        taskGraph.transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.testPrivateVectorDouble8(sequentialOutput);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getS0(), (double)tornadoOutput.get(i).getS0(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS1(), (double)tornadoOutput.get(i).getS1(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS2(), (double)tornadoOutput.get(i).getS2(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS3(), (double)tornadoOutput.get(i).getS3(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS4(), (double)tornadoOutput.get(i).getS4(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS5(), (double)tornadoOutput.get(i).getS5(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS6(), (double)tornadoOutput.get(i).getS6(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getS7(), (double)tornadoOutput.get(i).getS7(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod01() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble2 tornadoInput = new VectorDouble2(16);
        VectorDouble2 sequentialInput = new VectorDouble2(16);
        VectorDouble2 tornadoOutput = new VectorDouble2(16);
        VectorDouble2 sequentialOutput = new VectorDouble2(16);
        for (int i = 0; i < 16; ++i) {
            double value = Math.random();
            Double2 double2 = new Double2(value, value);
            tornadoInput.set(i, double2);
            sequentialInput.set(i, double2);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestDoubles::vectorComputation01, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.vectorComputation01(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod02() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble3 tornadoInput = new VectorDouble3(16);
        VectorDouble3 sequentialInput = new VectorDouble3(16);
        VectorDouble3 tornadoOutput = new VectorDouble3(16);
        VectorDouble3 sequentialOutput = new VectorDouble3(16);
        for (int i = 0; i < 16; ++i) {
            double value = Math.random();
            Double3 double3 = new Double3(value, value, value);
            tornadoInput.set(i, double3);
            sequentialInput.set(i, double3);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestDoubles::vectorComputation02, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.vectorComputation02(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod03() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble4 tornadoInput = new VectorDouble4(16);
        VectorDouble4 sequentialInput = new VectorDouble4(16);
        VectorDouble3 tornadoOutput = new VectorDouble3(16);
        VectorDouble3 sequentialOutput = new VectorDouble3(16);
        for (int i = 0; i < 16; ++i) {
            double value = Math.random();
            Double4 double4 = new Double4(value, value, value, value);
            tornadoInput.set(i, double4);
            sequentialInput.set(i, double4);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestDoubles::vectorComputation03, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.vectorComputation03(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getZ(), (double)tornadoOutput.get(i).getZ(), (double)0.001);
        }
    }

    @Test
    public void testInternalSetMethod04() throws TornadoExecutionPlanException {
        int size = 16;
        VectorDouble8 tornadoInput = new VectorDouble8(16);
        VectorDouble8 sequentialInput = new VectorDouble8(16);
        VectorDouble2 tornadoOutput = new VectorDouble2(16);
        VectorDouble2 sequentialOutput = new VectorDouble2(16);
        for (int i = 0; i < 16; ++i) {
            double value = Math.random();
            Double8 double8 = new Double8(value, value, value, value, value, value, value, value);
            tornadoInput.set(i, double8);
            sequentialInput.set(i, double8);
        }
        TaskGraph graph = new TaskGraph("s0").transferToDevice(1, new Object[]{tornadoInput}).task("t0", TestDoubles::vectorComputation04, (Object)tornadoInput, (Object)tornadoOutput).transferToHost(1, new Object[]{tornadoOutput});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestDoubles.vectorComputation04(sequentialInput, sequentialOutput);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((double)sequentialOutput.get(i).getX(), (double)tornadoOutput.get(i).getX(), (double)0.001);
            Assert.assertEquals((double)sequentialOutput.get(i).getY(), (double)tornadoOutput.get(i).getY(), (double)0.001);
        }
    }
}

