/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceFP16NotSupported;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceFP64NotSupported;
import uk.ac.manchester.tornado.api.exceptions.TornadoNoOpenCLPlatformException;
import uk.ac.manchester.tornado.unittests.common.SPIRVOptNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoVMMultiDeviceNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoVMOpenCLNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoVMPTXNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoVMSPIRVNotSupported;
import uk.ac.manchester.tornado.unittests.tools.Exceptions.UnsupportedConfigurationException;

public class TornadoHelper {
    public static final boolean OPTIMIZE_LOAD_STORE_SPIRV = Boolean.parseBoolean(System.getProperty("tornado.spirv.loadstore", "False"));

    private static void printResult(Result result) {
        System.out.printf("Test ran: %s, Failed: %s%n", result.getRunCount(), result.getFailureCount());
    }

    private static void printResult(int success, int failed, int notSupported) {
        System.out.printf("Test ran: %s, Failed: %s, Unsupported: %s%n", success + failed + notSupported, failed, notSupported);
    }

    private static void printResult(int success, int failed, int notSupported, StringBuilder buffer) {
        buffer.append(String.format("Test ran: %s, Failed: %s, Unsupported: %s%n", success + failed + notSupported, failed, notSupported));
    }

    static boolean getProperty(String property) {
        if (System.getProperty(property) != null) {
            return System.getProperty(property).toLowerCase().equals("true");
        }
        return false;
    }

    private static Method getMethodForName(Class<?> klass, String nameMethod) {
        Method method = null;
        for (Method m : klass.getMethods()) {
            if (!m.getName().equals(nameMethod)) continue;
            method = m;
        }
        return method;
    }

    private static TestSuiteCollection getTestMethods(Class<?> klass) {
        Method[] methods = klass.getMethods();
        ArrayList<Method> methodsToTest = new ArrayList<Method>();
        HashSet<Method> unsupportedMethods = new HashSet<Method>();
        HashSet<Method> spirvNotSupportedMethods = new HashSet<Method>();
        for (Method m : methods) {
            Annotation[] annotations = m.getAnnotations();
            boolean testEnabled = false;
            boolean ignoreTest = false;
            for (Annotation a : annotations) {
                if (a instanceof Ignore) {
                    ignoreTest = true;
                    continue;
                }
                if (a instanceof Test) {
                    testEnabled = true;
                    continue;
                }
                if (!(a instanceof TornadoNotSupported)) continue;
                testEnabled = true;
                unsupportedMethods.add(m);
            }
            if (!(testEnabled & !ignoreTest)) continue;
            methodsToTest.add(m);
        }
        return new TestSuiteCollection(methodsToTest, unsupportedMethods, spirvNotSupportedMethods);
    }

    static void runTestVerbose(String klassName, String methodName) throws ClassNotFoundException {
        Class<?> klass = Class.forName(klassName);
        ArrayList<Object> methodsToTest = new ArrayList<Method>();
        TestSuiteCollection suite = null;
        if (methodName == null) {
            suite = TornadoHelper.getTestMethods(klass);
            methodsToTest = suite.methodsToTest;
        } else {
            Method method = TornadoHelper.getMethodForName(klass, methodName);
            methodsToTest.add(method);
        }
        StringBuilder bufferConsole = new StringBuilder();
        StringBuilder bufferFile = new StringBuilder();
        int successCounter = 0;
        int failedCounter = 0;
        int notSupported = 0;
        bufferConsole.append("Test: " + String.valueOf(klass));
        bufferFile.append("Test: " + String.valueOf(klass));
        if (methodName != null) {
            bufferConsole.append("#" + methodName);
            bufferFile.append("#" + methodName);
        }
        bufferConsole.append("\n");
        bufferFile.append("\n");
        for (Method method : methodsToTest) {
            String message = String.format("%-50s", "\tRunning test: \u001b[34m" + method.getName() + "\u001b[0m");
            bufferConsole.append(message);
            bufferFile.append(message);
            if (suite != null && suite.unsupportedMethods.contains(method)) {
                message = String.format("%20s", " ................ \u001b[33m [NOT VALID TEST: UNSUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            Request request = Request.method(klass, (String)method.getName());
            Result result = new JUnitCore().run(request);
            if (result.wasSuccessful()) {
                message = String.format("%20s", " ................ \u001b[32m [PASS] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++successCounter;
                continue;
            }
            if (result.getFailures().stream().filter(e -> e.getException() instanceof UnsupportedConfigurationException).count() > 0L) {
                message = String.format("%20s", " ................ \u001b[35m [UNSUPPORTED CONFIGURATION: At least 2 accelerators are required] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoVMPTXNotSupported)) {
                message = String.format("%20s", " ................ \u001b[35m [PTX CONFIGURATION UNSUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoNoOpenCLPlatformException)) {
                message = String.format("%20s", " ................ \u001b[35m [OPENCL CONFIGURATION UNSUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoVMMultiDeviceNotSupported)) {
                message = String.format("%20s", " ................ \u001b[35m [[UNSUPPORTED] MULTI-DEVICE CONFIGURATION REQUIRED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoVMOpenCLNotSupported)) {
                message = String.format("%20s", " ................ \u001b[35m [OPENCL CONFIGURATION UNSUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoVMSPIRVNotSupported)) {
                message = String.format("%20s", " ................ \u001b[35m [SPIRV CONFIGURATION UNSUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof SPIRVOptNotSupported) && OPTIMIZE_LOAD_STORE_SPIRV) {
                message = String.format("%20s", " ................ \u001b[31m [SPIRV OPTIMIZATION NOT SUPPORTED] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++failedCounter;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoDeviceFP64NotSupported)) {
                message = String.format("%20s", " ................ \u001b[33m [FP64 UNSUPPORTED FOR CURRENT DEVICE] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            if (result.getFailures().stream().anyMatch(e -> e.getException() instanceof TornadoDeviceFP16NotSupported)) {
                message = String.format("%20s", " ................ \u001b[33m [FP16 UNSUPPORTED FOR CURRENT DEVICE] \u001b[0m\n");
                bufferConsole.append(message);
                bufferFile.append(message);
                ++notSupported;
                continue;
            }
            message = String.format("%20s", " ................ \u001b[31m [FAILED] \u001b[0m\n");
            bufferConsole.append(message);
            bufferFile.append(message);
            ++failedCounter;
            for (Failure failure : result.getFailures()) {
                bufferConsole.append("\t\t\\_[REASON] " + failure.getMessage() + "\n");
                bufferFile.append("\t\t\\_[REASON] " + failure.getMessage() + "\n\t" + failure.getTrace() + "\n" + String.valueOf(failure.getDescription()) + "\n" + String.valueOf(failure.getException()));
            }
        }
        TornadoHelper.printResult(successCounter, failedCounter, notSupported, bufferConsole);
        TornadoHelper.printResult(successCounter, failedCounter, notSupported, bufferFile);
        System.out.println(bufferConsole);
        try (BufferedWriter w = new BufferedWriter(new FileWriter("tornado_unittests.log", true));){
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            w.write("\n" + simpleDateFormat.format(date) + "\n");
            w.write(bufferFile.toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    static void runTestClassAndMethod(String klassName, String methodName) throws ClassNotFoundException {
        Request request = Request.method(Class.forName(klassName), (String)methodName);
        Result result = new JUnitCore().run(request);
        TornadoHelper.printResult(result);
    }

    static void runTestClass(String klassName) throws ClassNotFoundException {
        Request request = Request.aClass(Class.forName(klassName));
        Result result = new JUnitCore().run(request);
        TornadoHelper.printResult(result);
    }

    static class TestSuiteCollection {
        ArrayList<Method> methodsToTest;
        HashSet<Method> unsupportedMethods;

        TestSuiteCollection(ArrayList<Method> methodsToTest, HashSet<Method> unsupportedMethods, HashSet<Method> spirvUnsupportedMethods) {
            this.methodsToTest = methodsToTest;
            this.unsupportedMethods = unsupportedMethods;
        }
    }
}

