/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.temporary.values;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestTemporaryValues
extends TornadoTestBase {
    private static void computeWithTemporaryValues(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            float valueA = a.get(i);
            float valueB = b.get(i);
            a.set(i, valueA + b.get(i));
            b.set(i, valueA * 2.0f);
            c.set(i, valueA + valueB);
        }
    }

    @Test
    public void testTemporaryValues01() throws TornadoExecutionPlanException {
        int numElements = 8;
        FloatArray aTornado = new FloatArray(8);
        FloatArray bTornado = new FloatArray(8);
        FloatArray cTornado = new FloatArray(8);
        FloatArray aJava = new FloatArray(8);
        FloatArray bJava = new FloatArray(8);
        FloatArray cJava = new FloatArray(8);
        Random r = new Random();
        IntStream.range(0, aJava.getSize()).forEach(idx -> {
            aTornado.set(idx, r.nextFloat());
            aJava.set(idx, aTornado.get(idx));
            bTornado.set(idx, r.nextFloat());
            bJava.set(idx, bTornado.get(idx));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{aTornado, bTornado}).task("t0", TestTemporaryValues::computeWithTemporaryValues, (Object)aTornado, (Object)bTornado, (Object)cTornado).transferToHost(1, new Object[]{aTornado, bTornado, cTornado});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTemporaryValues.computeWithTemporaryValues(aJava, bJava, cJava);
        for (int i = 0; i < aJava.getSize(); ++i) {
            Assert.assertEquals((float)aJava.get(i), (float)aTornado.get(i), (float)0.001f);
            Assert.assertEquals((float)bJava.get(i), (float)bTornado.get(i), (float)0.001f);
            Assert.assertEquals((float)cJava.get(i), (float)cTornado.get(i), (float)0.001f);
        }
    }
}

