/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.tasks;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestSingleTaskSingleDevice
extends TornadoTestBase {
    public static void simpleTask(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    @Test
    public void testSimpleTask() throws TornadoExecutionPlanException {
        int numElements = 4096;
        FloatArray a = new FloatArray(4096);
        FloatArray b = new FloatArray(4096);
        FloatArray c = new FloatArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestSingleTaskSingleDevice::simpleTask, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }

    @Test
    public void testSimpleTaskOnDevice0() throws TornadoExecutionPlanException {
        int numElements = 4096;
        FloatArray a = new FloatArray(4096);
        FloatArray b = new FloatArray(4096);
        FloatArray c = new FloatArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(0);
        boolean deviceNumber = false;
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestSingleTaskSingleDevice::simpleTask, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withDevice(driver.getDevice(0)).execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }

    @Test
    public void testSimpleTaskOnDevice1() throws TornadoExecutionPlanException {
        int numElements = 4096;
        FloatArray a = new FloatArray(4096);
        FloatArray b = new FloatArray(4096);
        FloatArray c = new FloatArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(0);
        int deviceNumber = 0;
        if (driver.getNumDevices() > 1) {
            deviceNumber = 1;
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestSingleTaskSingleDevice::simpleTask, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withDevice(driver.getDevice(deviceNumber)).execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }
}

