/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.tasks;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMultipleTasksSingleDevice
extends TornadoTestBase {
    public static void task0Initialization(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 10);
        }
    }

    public static void task1Multiplication(IntArray a, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) * alpha);
        }
    }

    public static void task2Saxpy(IntArray a, IntArray b, IntArray c, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            c.set(i, alpha * a.get(i) + b.get(i));
        }
    }

    @Test
    public void testTwoTasks() throws TornadoExecutionPlanException {
        int numElements = 1024;
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleTasksSingleDevice::task0Initialization, (Object)a).task("t1", TestMultipleTasksSingleDevice::task1Multiplication, (Object)a, (Object)12).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)120L, (long)a.get(i));
        }
    }

    @Test
    public void testThreeTasks() throws TornadoExecutionPlanException {
        int numElements = 1024;
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleTasksSingleDevice::task0Initialization, (Object)a).task("t1", TestMultipleTasksSingleDevice::task1Multiplication, (Object)a, (Object)12).task("t3", TestMultipleTasksSingleDevice::task2Saxpy, (Object)a, (Object)a, (Object)b, (Object)12).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int val = 1560;
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)val, (long)b.get(i));
        }
    }

    @Test
    public void testFourTasks() throws TornadoExecutionPlanException {
        int numElements = 1024;
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray c = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleTasksSingleDevice::task0Initialization, (Object)a).task("t1", TestMultipleTasksSingleDevice::task1Multiplication, (Object)a, (Object)12).task("t2", TestMultipleTasksSingleDevice::task0Initialization, (Object)b).task("t3", TestMultipleTasksSingleDevice::task2Saxpy, (Object)a, (Object)b, (Object)c, (Object)12).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int val = 1450;
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)val, (long)c.get(i));
        }
    }

    @Test
    public void testFiveTasks() throws TornadoExecutionPlanException {
        int numElements = 1024;
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray c = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleTasksSingleDevice::task0Initialization, (Object)a).task("t1", TestMultipleTasksSingleDevice::task1Multiplication, (Object)a, (Object)12).task("t2", TestMultipleTasksSingleDevice::task0Initialization, (Object)b).task("t3", TestMultipleTasksSingleDevice::task2Saxpy, (Object)a, (Object)b, (Object)b, (Object)12).task("t4", TestMultipleTasksSingleDevice::task2Saxpy, (Object)b, (Object)a, (Object)c, (Object)12).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int val = 1450;
        val = 12 * val + 120;
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)val, (long)c.get(i));
        }
    }
}

