/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.tasks;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.common.TornadoVMMultiDeviceNotSupported;

public class TestMultipleTasksMultipleDevices
extends TornadoTestBase {
    private static final int NUM_ELEMENTS = 8192;
    private static final String[] DEVICES_FOR_TASKS = new String[]{"s0.t0.device", "s0.t1.device", "s0.t2.device"};
    private static final String[] DEFAULT_DEVICES = new String[]{"0:0", "0:1", "0:0"};
    private static IntArray a;
    private static IntArray b;
    private static IntArray c;
    private static IntArray d;
    private static IntArray e;

    public static void task0Initialization(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, i);
        }
    }

    public static void task1Multiplication(IntArray a, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) * i);
        }
    }

    public static void task2Saxpy(IntArray a, IntArray b, IntArray c, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            c.set(i, alpha * a.get(i) + b.get(i));
        }
    }

    public static void taskMultiplication(IntArray a, IntArray b, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) * i);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        TestMultipleTasksMultipleDevices.assertAvailableDevices();
        TestMultipleTasksMultipleDevices.setDefaultDevices();
        System.setProperty("tornado.concurrent.devices", "True");
        a = new IntArray(8192);
        b = new IntArray(8192);
        c = new IntArray(8192);
        d = new IntArray(8192);
        e = new IntArray(8192);
        IntStream.range(0, 8192).forEach(i -> {
            a.set(i, 30 + i);
            b.set(i, 1 + i);
            c.set(i, 120 + i);
            e.set(i, i);
        });
    }

    private static void assertAvailableDevices() {
        String driverAndDevice = System.getProperty("tornado.unittests.device", "0:0");
        String[] parts = driverAndDevice.split(":");
        int backendIndex = Integer.parseInt(parts[0]);
        if (TornadoRuntimeProvider.getTornadoRuntime().getBackend(backendIndex).getNumDevices() < 2) {
            throw new TornadoVMMultiDeviceNotSupported("This test needs at least 2 devices enabled on backend " + backendIndex);
        }
    }

    public static void setDefaultDevices() {
        for (int i = 0; i < DEVICES_FOR_TASKS.length; ++i) {
            String taskProperty = DEVICES_FOR_TASKS[i];
            String defaultDevice = DEFAULT_DEVICES[i];
            if (System.getProperty(taskProperty) != null) continue;
            System.setProperty(taskProperty, defaultDevice);
        }
    }

    @Test
    public void testTwoTasksTwoDevices() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMultipleTasksMultipleDevices::task0Initialization, (Object)b).task("t1", TestMultipleTasksMultipleDevices::task1Multiplication, (Object)a, (Object)12).transferToHost(1, new Object[]{a, b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)((30L + (long)i) * (long)i), (long)a.get(i));
            Assert.assertEquals((long)i, (long)b.get(i));
        }
    }

    @Test
    public void testThreeTasksTwoDevices() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b, c, e}).task("t0", TestMultipleTasksMultipleDevices::task0Initialization, (Object)b).task("t1", TestMultipleTasksMultipleDevices::task1Multiplication, (Object)a, (Object)12).task("t2", TestMultipleTasksMultipleDevices::task2Saxpy, (Object)c, (Object)e, (Object)d, (Object)12).transferToHost(1, new Object[]{a, b, d});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)((30L + (long)i) * (long)i), (long)a.get(i));
            Assert.assertEquals((long)i, (long)b.get(i));
            Assert.assertEquals((long)(12L * (long)c.get(i) + (long)e.get(i)), (long)d.get(i));
        }
    }

    @Test
    public void testTwoTasksTwoDevicesSharedReadOnlyRead() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b, d, c}).task("t0", TestMultipleTasksMultipleDevices::taskMultiplication, (Object)a, (Object)b, (Object)12).task("t1", TestMultipleTasksMultipleDevices::task2Saxpy, (Object)c, (Object)b, (Object)d, (Object)12).transferToHost(1, new Object[]{a, c, d});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)(b.get(i) * i), (long)a.get(i));
            Assert.assertEquals((long)(12L * (long)c.get(i) + (long)b.get(i)), (long)d.get(i));
        }
    }
}

