/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.tasks;

import java.util.Random;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMultipleFunctions
extends TornadoTestBase {
    private static int operation(int a, int b) {
        return a + b;
    }

    public static void vectorAddInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, TestMultipleFunctions.operation(a.get(i), b.get(i)));
        }
    }

    private static int operation2(int a, int b) {
        return a + TestMultipleFunctions.operation(a, b);
    }

    public static void vectorAddInteger2(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, TestMultipleFunctions.operation2(a.get(i), b.get(i)));
        }
    }

    private static int operation3(int a, int b) {
        return a + TestMultipleFunctions.operation2(a, b);
    }

    public static void vectorAddInteger3(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, TestMultipleFunctions.operation3(a.get(i), b.get(i)));
        }
    }

    private static int foo(int a) {
        return a + a;
    }

    private static int bar(int a) {
        return a * a;
    }

    private static float foo(float a) {
        return a + a;
    }

    private static float bar(float a) {
        return a * a;
    }

    private static Float4 foo(Float4 a) {
        return Float4.add((Float4)a, (Float4)a);
    }

    private static Float4 bar(Float4 a) {
        return Float4.mult((Float4)a, (Float4)a);
    }

    public static void vectorAddInteger4(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, TestMultipleFunctions.foo(a.get(i)) + TestMultipleFunctions.bar(b.get(i)));
        }
    }

    public static void vectorAddFloats(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, TestMultipleFunctions.foo(a.get(i)) + TestMultipleFunctions.bar(b.get(i)));
        }
    }

    public static void vectorTypes(Float4 a, Float4 b, Float4 c) {
        c.set(Float4.add((Float4)TestMultipleFunctions.foo(a), (Float4)TestMultipleFunctions.bar(b)));
    }

    public static void callee2(IntArray calleeReadWrite, IntArray calleeRead) {
        for (int i = 0; i < calleeReadWrite.getSize(); ++i) {
            calleeReadWrite.set(i, calleeReadWrite.get(i) - calleeRead.get(i));
        }
    }

    private static void functionA(IntArray arr) {
        TestMultipleFunctions.functionB(arr);
        TestMultipleFunctions.functionC(arr);
    }

    private static void functionB(IntArray arr) {
        TestMultipleFunctions.functionD(arr);
    }

    private static void functionC(IntArray arr) {
        TestMultipleFunctions.functionD(arr);
    }

    private static void functionD(IntArray arr) {
        arr.set(0, -1);
    }

    @Test
    public void test01() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorAddInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            TestCase.assertEquals((int)(a.get(i2) + b.get(i2)), (int)c.get(i2));
        }
    }

    @Test
    public void test02() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorAddInteger2, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            TestCase.assertEquals((int)(a.get(i2) + (a.get(i2) + b.get(i2))), (int)c.get(i2));
        }
    }

    @Test
    public void test03() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorAddInteger3, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            TestCase.assertEquals((int)(a.get(i2) + (a.get(i2) + (a.get(i2) + b.get(i2)))), (int)c.get(i2));
        }
    }

    @Test
    public void test04() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorAddInteger4, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            TestCase.assertEquals((int)(a.get(i2) + a.get(i2) + b.get(i2) * b.get(i2)), (int)c.get(i2));
        }
    }

    @Test
    public void test05() throws TornadoExecutionPlanException {
        int numElements = 32768;
        FloatArray a = new FloatArray(32768);
        FloatArray b = new FloatArray(32768);
        FloatArray c = new FloatArray(32768);
        FloatArray checker = new FloatArray(32768);
        Random r = new Random();
        IntStream.range(0, 32768).sequential().forEach(i -> {
            a.set(i, (float)r.nextInt(10));
            b.set(i, (float)r.nextInt(10));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorAddFloats, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMultipleFunctions.vectorAddFloats(a, b, checker);
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            TestCase.assertEquals((float)checker.get(i2), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVector01() throws TornadoExecutionPlanException {
        Float4 a = new Float4(1.0f, 2.0f, 3.0f, 4.0f);
        Float4 b = new Float4(4.0f, 3.0f, 2.0f, 1.0f);
        Float4 c = new Float4();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMultipleFunctions::vectorTypes, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Float4 result = Float4.add((Float4)TestMultipleFunctions.foo(a), (Float4)TestMultipleFunctions.bar(b));
        TestCase.assertEquals((Object)Float.valueOf(result.getX()), (Object)Float.valueOf(c.getX()));
        TestCase.assertEquals((Object)Float.valueOf(result.getY()), (Object)Float.valueOf(c.getY()));
        TestCase.assertEquals((Object)Float.valueOf(result.getW()), (Object)Float.valueOf(c.getW()));
        TestCase.assertEquals((Object)Float.valueOf(result.getZ()), (Object)Float.valueOf(c.getZ()));
    }

    public void caller1(IntArray calleeRead, int ignoreParam1, IntArray callerReadCalleeWrite, int ignoreParam2, IntArray callerRead, IntArray callerWrite) {
        for (int i = 0; i < callerRead.getSize(); ++i) {
            callerWrite.set(i, callerRead.get(i) + callerReadCalleeWrite.get(i) + 10);
        }
        this.callee1(calleeRead, callerReadCalleeWrite);
    }

    public void callee1(IntArray calleeRead, IntArray calleeWrite) {
        for (int i = 0; i < calleeRead.getSize(); ++i) {
            calleeWrite.set(i, calleeRead.get(i) + 1);
        }
    }

    public void caller2(IntArray calleeReadWrite, IntArray calleeRead) {
        TestMultipleFunctions.callee2(calleeReadWrite, calleeRead);
    }

    public void caller3(IntArray callerReadWrite, IntArray callee1Read, IntArray callee1Write, IntArray callee2ReadWrite, IntArray callee2Read) {
        for (int i = 0; i < callerReadWrite.getSize(); ++i) {
            callerReadWrite.set(i, callerReadWrite.get(i) + 20);
        }
        this.callee1(callee1Read, callee1Write);
        TestMultipleFunctions.callee2(callee2ReadWrite, callee2Read);
    }

    @Test
    public void testSingleTask() throws TornadoExecutionPlanException {
        int i;
        TestArrays testArrays = new TestArrays();
        this.caller1(testArrays.calleeReadSeq, testArrays.ignoreParam1, testArrays.callerReadCalleeWriteSeq, testArrays.ignoreParam2, testArrays.callerReadSeq, testArrays.callerWriteSeq);
        TestMultipleFunctions testTaskAccesses = new TestMultipleFunctions();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{testArrays.calleeReadTor, testArrays.ignoreParam1, testArrays.callerReadTor}).task("t0", testTaskAccesses::caller1, (Object)testArrays.calleeReadTor, (Object)testArrays.ignoreParam1, (Object)testArrays.callerReadCalleeWriteTor, (Object)testArrays.ignoreParam2, (Object)testArrays.callerReadTor, (Object)testArrays.callerWriteTor).transferToHost(1, new Object[]{testArrays.callerReadCalleeWriteTor, testArrays.callerWriteTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (i = 0; i < testArrays.calleeReadTor.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.calleeReadSeq.get(i), (long)testArrays.calleeReadTor.get(i));
        }
        for (i = 0; i < testArrays.callerReadCalleeWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerReadCalleeWriteSeq.get(i), (long)testArrays.callerReadCalleeWriteTor.get(i));
        }
        for (i = 0; i < testArrays.callerReadSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerReadSeq.get(i), (long)testArrays.callerReadTor.get(i));
        }
        for (i = 0; i < testArrays.callerWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerWriteSeq.get(i), (long)testArrays.callerWriteSeq.get(i));
        }
    }

    @Test
    public void testMultipleTasks() throws TornadoExecutionPlanException {
        int i;
        TestArrays testArrays = new TestArrays();
        this.caller1(testArrays.calleeReadSeq, testArrays.ignoreParam1, testArrays.callerReadCalleeWriteSeq, testArrays.ignoreParam2, testArrays.callerReadSeq, testArrays.callerWriteSeq);
        this.caller2(testArrays.callerReadSeq, testArrays.calleeReadSeq);
        TestMultipleFunctions testTaskAccesses = new TestMultipleFunctions();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{testArrays.calleeReadTor}).task("t0", testTaskAccesses::caller1, (Object)testArrays.calleeReadTor, (Object)testArrays.ignoreParam1, (Object)testArrays.callerReadCalleeWriteTor, (Object)testArrays.ignoreParam2, (Object)testArrays.callerReadTor, (Object)testArrays.callerWriteTor).task("t1", testTaskAccesses::caller2, (Object)testArrays.callerReadTor, (Object)testArrays.calleeReadTor).transferToHost(1, new Object[]{testArrays.callerReadCalleeWriteTor, testArrays.callerWriteTor, testArrays.callerReadTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (i = 0; i < testArrays.calleeReadTor.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.calleeReadSeq.get(i), (long)testArrays.calleeReadTor.get(i));
        }
        for (i = 0; i < testArrays.callerReadCalleeWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerReadCalleeWriteSeq.get(i), (long)testArrays.callerReadCalleeWriteTor.get(i));
        }
        for (i = 0; i < testArrays.callerReadSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerReadSeq.get(i), (long)testArrays.callerReadTor.get(i));
        }
        for (i = 0; i < testArrays.callerWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)testArrays.callerWriteSeq.get(i), (long)testArrays.callerWriteSeq.get(i));
        }
    }

    @Test
    public void testMultipleTasksMultipleCallees() {
        int i;
        TestArrays arrays = new TestArrays();
        this.caller1(arrays.calleeReadSeq, arrays.ignoreParam1, arrays.callerReadCalleeWriteSeq, arrays.ignoreParam2, arrays.callerReadSeq, arrays.callerWriteSeq);
        this.caller2(arrays.callerReadSeq, arrays.calleeReadSeq);
        this.caller3(arrays.callerReadWriteSeq, arrays.calleeReadSeq, arrays.callee1WriteSeq, arrays.callerReadCalleeWriteSeq, arrays.callee2ReadSeq);
        TestMultipleFunctions testTaskAccesses = new TestMultipleFunctions();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrays.calleeReadTor, arrays.callee2ReadTor}).task("t0", testTaskAccesses::caller1, (Object)arrays.calleeReadTor, (Object)arrays.ignoreParam1, (Object)arrays.callerReadCalleeWriteTor, (Object)arrays.ignoreParam2, (Object)arrays.callerReadTor, (Object)arrays.callerWriteTor).task("t1", testTaskAccesses::caller2, (Object)arrays.callerReadTor, (Object)arrays.calleeReadTor).task("t2", testTaskAccesses::caller3, (Object)arrays.callerReadWriteTor, (Object)arrays.calleeReadTor, (Object)arrays.callee1WriteTor, (Object)arrays.callerReadCalleeWriteTor, (Object)arrays.callee2ReadTor).transferToHost(1, new Object[]{arrays.callerReadCalleeWriteTor, arrays.callerWriteTor, arrays.callerReadTor, arrays.callerReadWriteTor, arrays.callee1WriteTor, arrays.callerReadCalleeWriteTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (i = 0; i < arrays.calleeReadTor.getSize(); ++i) {
            Assert.assertEquals((long)arrays.calleeReadSeq.get(i), (long)arrays.calleeReadTor.get(i));
        }
        for (i = 0; i < arrays.callerReadCalleeWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callerReadCalleeWriteSeq.get(i), (long)arrays.callerReadCalleeWriteTor.get(i));
        }
        for (i = 0; i < arrays.callerReadSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callerReadSeq.get(i), (long)arrays.callerReadTor.get(i));
        }
        for (i = 0; i < arrays.callerWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callerWriteSeq.get(i), (long)arrays.callerWriteSeq.get(i));
        }
        for (i = 0; i < arrays.callerReadWriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callerReadWriteSeq.get(i), (long)arrays.callerReadWriteTor.get(i));
        }
        for (i = 0; i < arrays.callee1WriteSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callee1WriteSeq.get(i), (long)arrays.callee1WriteTor.get(i));
        }
        for (i = 0; i < arrays.callee2ReadSeq.getSize(); ++i) {
            Assert.assertEquals((long)arrays.callee2ReadSeq.get(i), (long)arrays.callee2ReadTor.get(i));
        }
    }

    @Test
    public void testNoDoubleCompilation() throws TornadoExecutionPlanException {
        IntArray arr = new IntArray(1);
        arr.init(0);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMultipleFunctions::functionA, (Object)arr).transferToHost(1, new Object[]{arr});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)-1L, (long)arr.get(0));
    }

    private static class TestArrays {
        final int N1 = 1024;
        IntArray calleeReadTor = new IntArray(1024);
        IntArray callerReadCalleeWriteTor = new IntArray(1024);
        IntArray callerReadTor = new IntArray(1024);
        IntArray callerWriteTor = new IntArray(1024);
        IntArray callerReadWriteTor = new IntArray(1024);
        IntArray callee1WriteTor = new IntArray(1024);
        IntArray callee2ReadTor = new IntArray(1024);
        IntArray calleeReadSeq = new IntArray(1024);
        IntArray callerReadCalleeWriteSeq = new IntArray(1024);
        IntArray callerReadSeq = new IntArray(1024);
        IntArray callerWriteSeq = new IntArray(1024);
        IntArray callerReadWriteSeq = new IntArray(1024);
        IntArray callee1WriteSeq = new IntArray(1024);
        IntArray callee2ReadSeq = new IntArray(1024);
        int ignoreParam1 = 10;
        int ignoreParam2 = -500;

        public TestArrays() {
            Random random = new Random();
            for (int i = 0; i < 1024; ++i) {
                this.calleeReadTor.set(i, random.nextInt());
                this.calleeReadSeq.set(i, this.calleeReadTor.get(i));
                this.callerReadCalleeWriteTor.set(i, random.nextInt());
                this.callerReadCalleeWriteSeq.set(i, this.callerReadCalleeWriteTor.get(i));
                this.callerReadTor.set(i, random.nextInt());
                this.callerReadSeq.set(i, this.callerReadTor.get(i));
                this.callerWriteTor.set(i, random.nextInt());
                this.callerWriteSeq.set(i, this.callerWriteTor.get(i));
                this.callerReadWriteTor.set(i, random.nextInt());
                this.callerReadWriteSeq.set(i, this.callerReadWriteTor.get(i));
                this.callee1WriteTor.set(i, random.nextInt());
                this.callee1WriteSeq.set(i, this.callee1WriteTor.get(i));
                this.callee2ReadTor.set(i, random.nextInt());
                this.callee2ReadSeq.set(i, this.callee2ReadTor.get(i));
            }
        }
    }
}

