/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.slam.utils;

import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageByte4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat8;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.utils.VolumeOps;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Short3;
import uk.ac.manchester.tornado.api.types.volumes.VolumeShort2;
import uk.ac.manchester.tornado.unittests.slam.utils.GraphicsMath;

public class Renderer {
    private static final float INVALID = -2.0f;

    public static void renderLight(ImageByte4 output, ImageFloat3 verticies, ImageFloat3 normals, Float3 light, Float3 ambient) {
        for (int y = 0; y < output.Y(); ++y) {
            for (int x = 0; x < output.X(); ++x) {
                Float3 normal = normals.get(x, y);
                Byte4 pixel = new Byte4(0, 0, 0, -1);
                if (normal.getX() != -2.0f) {
                    Float3 vertex = Float3.normalise((Float3)Float3.sub((Float3)light, (Float3)verticies.get(x, y)));
                    float dir = Math.max(Float3.dot((Float3)normal, (Float3)vertex), 0.0f);
                    Float3 col = Float3.add((Float3)ambient, (float)dir);
                    col = Float3.clamp((Float3)col, (float)0.0f, (float)1.0f);
                    col = Float3.scale((Float3)col, (float)255.0f);
                    pixel = new Byte4((byte)col.getX(), (byte)col.getY(), (byte)col.getZ(), -1);
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void renderVolume(ImageByte4 output, VolumeShort2 volume, Float3 volumeDims, Matrix4x4Float view, float nearPlane, float farPlane, float smallStep, float largeStep, Float3 light, Float3 ambient) {
        for (int y = 0; y < output.Y(); ++y) {
            for (int x = 0; x < output.X(); ++x) {
                Byte4 pixel;
                Float4 hit = GraphicsMath.raycastPoint(volume, volumeDims, x, y, view, nearPlane, farPlane, smallStep, largeStep);
                if (hit.getW() > 0.0f) {
                    Float3 test = hit.asFloat3();
                    Float3 surfNorm = VolumeOps.grad((VolumeShort2)volume, (Float3)volumeDims, (Float3)test);
                    if (Float3.length((Float3)surfNorm) > 0.0f) {
                        Float3 diff = Float3.normalise((Float3)Float3.sub((Float3)light, (Float3)test));
                        Float3 normalizedSurfNorm = Float3.normalise((Float3)surfNorm);
                        float dir = Math.max(Float3.dot((Float3)normalizedSurfNorm, (Float3)diff), 0.0f);
                        Float3 col = Float3.add((Float3)new Float3(dir, dir, dir), (Float3)ambient);
                        col = Float3.clamp((Float3)col, (float)0.0f, (float)1.0f);
                        col = Float3.mult((Float3)col, (float)255.0f);
                        pixel = new Byte4((byte)col.getX(), (byte)col.getY(), (byte)col.getZ(), 0);
                    } else {
                        pixel = new Byte4();
                    }
                } else {
                    pixel = new Byte4();
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void renderNorms(ImageByte3 output, ImageFloat3 normals) {
        for (int y = 0; y < normals.Y(); ++y) {
            for (int x = 0; x < normals.X(); ++x) {
                Float3 normal = normals.get(x, y);
                Byte3 pixel = new Byte3();
                if (normal.getX() != -2.0f) {
                    Float3.normalise((Float3)normal);
                    Float3.mult((Float3)normal, (float)128.0f);
                    Float3.add((Float3)normal, (float)128.0f);
                    pixel.setX((byte)normal.getX());
                    pixel.setY((byte)normal.getY());
                    pixel.setZ((byte)normal.getZ());
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void renderVertex(ImageByte3 output, ImageFloat3 vertices) {
        for (int y = 0; y < vertices.Y(); ++y) {
            for (int x = 0; x < vertices.X(); ++x) {
                Float3 vertex = vertices.get(x, y);
                Byte3 pixel = new Byte3();
                if (vertex.getZ() != 0.0f) {
                    Float3.normalise((Float3)vertex);
                    Float3.mult((Float3)vertex, (float)128.0f);
                    Float3.add((Float3)vertex, (float)128.0f);
                    pixel.setX((byte)vertex.getZ());
                    pixel.setY((byte)0);
                    pixel.setZ((byte)0);
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void renderTrack(ImageByte3 output, ImageFloat8 track) {
        for (int y = 0; y < track.Y(); ++y) {
            for (int x = 0; x < track.X(); ++x) {
                Byte3 pixel = null;
                int result = (int)track.get(x, y).getS7();
                switch (result) {
                    case 1: {
                        pixel = new Byte3(-128, -128, -128);
                        break;
                    }
                    case -1: {
                        pixel = new Byte3(0, 0, 0);
                        break;
                    }
                    case -2: {
                        pixel = new Byte3(-1, 0, 0);
                        break;
                    }
                    case -3: {
                        pixel = new Byte3(0, -1, 0);
                        break;
                    }
                    case -4: {
                        pixel = new Byte3(0, 0, -1);
                        break;
                    }
                    case -5: {
                        pixel = new Byte3(-1, -1, 0);
                        break;
                    }
                    default: {
                        pixel = new Byte3(-1, -128, -128);
                    }
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void renderDepth(ImageByte4 output, ImageFloat depthMap, float nearPlane, float farPlane) {
        Byte4 blackPixel = new Byte4(-1, -1, -1, 0);
        Byte4 zero = new Byte4();
        for (int y = 0; y < depthMap.Y(); ++y) {
            for (int x = 0; x < depthMap.X(); ++x) {
                float depth = depthMap.get(x, y);
                Byte4 pixel = null;
                if (depth < nearPlane) {
                    pixel = blackPixel;
                } else if (depth >= farPlane) {
                    pixel = zero;
                } else {
                    float h = (depth - nearPlane) / (farPlane - nearPlane) * 6.0f;
                    int sextant = (int)h;
                    float fract = h - (float)sextant;
                    float mid1 = 0.25f + 0.5f * fract;
                    float mid2 = 0.75f - 0.5f * fract;
                    switch (sextant) {
                        case 0: {
                            pixel = new Byte4(-65, (byte)(255.0f * mid1), 64, 0);
                            break;
                        }
                        case 1: {
                            pixel = new Byte4((byte)(255.0f * mid2), -65, 64, 0);
                            break;
                        }
                        case 2: {
                            pixel = new Byte4(64, -65, (byte)(255.0f * mid1), 0);
                            break;
                        }
                        case 3: {
                            pixel = new Byte4(64, (byte)(255.0f * mid2), -65, 0);
                            break;
                        }
                        case 4: {
                            pixel = new Byte4((byte)(255.0f * mid1), 64, -65, 0);
                            break;
                        }
                        case 5: {
                            pixel = new Byte4(-65, 64, (byte)(255.0f * mid2), 0);
                            break;
                        }
                        default: {
                            pixel = zero;
                        }
                    }
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void gs2rgb(Short3 rgb, float d) {
        float v = 0.75f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float m = 0.25f;
        float sv = 0.6667f;
        d = (float)((double)d * 6.0);
        int sextant = (int)d;
        float fract = d - (float)sextant;
        float vsf = 0.75f * sv * fract;
        float mid1 = m + vsf;
        float mid2 = 0.75f - vsf;
        switch (sextant) {
            case 0: {
                r = 0.75f;
                g = mid1;
                b = m;
                break;
            }
            case 1: {
                r = mid2;
                g = 0.75f;
                b = m;
                break;
            }
            case 2: {
                r = m;
                g = 0.75f;
                b = mid1;
                break;
            }
            case 3: {
                r = m;
                g = mid2;
                b = 0.75f;
                break;
            }
            case 4: {
                r = mid1;
                g = m;
                b = 0.75f;
                break;
            }
            case 5: {
                r = 0.75f;
                g = m;
                b = mid2;
                break;
            }
        }
        rgb.setX((short)(r * 255.0f));
        rgb.setY((short)(g * 255.0f));
        rgb.setZ((short)(b * 255.0f));
    }

    public static void renderRGB(ImageByte3 output, ImageByte3 video) {
        for (int y = 0; y < video.Y(); ++y) {
            for (int x = 0; x < video.X(); ++x) {
                output.set(x, y, video.get(x, y));
            }
        }
    }
}

