/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.slam.utils;

import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;

public class ImagingOps {
    public static void resizeImage6(ImageFloat dest, ImageFloat src, int scaleFactor, float eDelta, int radius) {
        for (int y = 0; y < dest.Y(); ++y) {
            for (int x = 0; x < dest.X(); ++x) {
                int cx = TornadoMath.clamp((int)(scaleFactor * x), (int)0, (int)(src.X() - 1));
                int cy = TornadoMath.clamp((int)(scaleFactor * y), (int)0, (int)(src.Y() - 1));
                float sum = 0.0f;
                float t = 0.0f;
                float center = src.get(cx, cy);
                for (int yy = -radius + 1; yy <= radius; ++yy) {
                    for (int xx = -radius + 1; xx <= radius; ++xx) {
                        int py;
                        int px = TornadoMath.clamp((int)(cx + xx), (int)0, (int)(src.X() - 1));
                        float current = src.get(px, py = TornadoMath.clamp((int)(cy + yy), (int)0, (int)(src.Y() - 1)));
                        if (!(Math.abs(current - center) < eDelta)) continue;
                        sum += 1.0f;
                        t += current;
                    }
                }
                float value = sum > 0.0f ? t / sum : 0.0f;
                dest.set(x, y, value);
            }
        }
    }

    public static void mm2metersKernel(ImageFloat dest, ImageFloat src, int scaleFactor) {
        for (int y = 0; y < dest.Y(); ++y) {
            for (int x = 0; x < dest.X(); ++x) {
                int sx = scaleFactor * x;
                int sy = scaleFactor * y;
                float value = src.get(sx, sy) * 0.001f;
                dest.set(x, y, value);
            }
        }
    }

    public static void resizeImage(ImageFloat dest, ImageFloat src, int scaleFactor) {
        for (int y = 0; y < dest.Y(); ++y) {
            for (int x = 0; x < dest.X(); ++x) {
                int cx = TornadoMath.clamp((int)(scaleFactor * x), (int)0, (int)(src.X() - 1));
                int cy = TornadoMath.clamp((int)(scaleFactor * y), (int)0, (int)(src.Y() - 1));
                float center = src.get(cx, cy);
                dest.set(x, y, center);
            }
        }
    }

    public static void resizeImage(ImageByte3 dest, ImageByte3 src, int scaleFactor) {
        for (int y = 0; y < dest.Y(); ++y) {
            for (int x = 0; x < dest.X(); ++x) {
                int cx = TornadoMath.clamp((int)(scaleFactor * x), (int)0, (int)(src.X() - 1));
                int cy = TornadoMath.clamp((int)(scaleFactor * y), (int)0, (int)(src.Y() - 1));
                Byte3 center = src.get(cx, cy);
                dest.set(x, y, center);
            }
        }
    }

    public static void bilateralFilter(ImageFloat dest, ImageFloat src, FloatArray gaussian, float eDelta, int radius) {
        float eDSquared2 = eDelta * eDelta * 2.0f;
        for (int y = 0; y < src.Y(); ++y) {
            for (int x = 0; x < src.X(); ++x) {
                float center = src.get(x, y);
                if (center > 0.0f) {
                    float sum = 0.0f;
                    float t = 0.0f;
                    for (int yy = -radius; yy <= radius; ++yy) {
                        for (int xx = -radius; xx <= radius; ++xx) {
                            int py;
                            int px = TornadoMath.clamp((int)(x + xx), (int)0, (int)(src.X() - 1));
                            float currentPixel = src.get(px, py = TornadoMath.clamp((int)(y + yy), (int)0, (int)(src.Y() - 1)));
                            if (!(currentPixel > 0.0f)) continue;
                            float mod = FloatOps.sq((float)(currentPixel - center));
                            float factor = gaussian.get(xx + radius) * gaussian.get(yy + radius) * TornadoMath.exp((float)(-mod / eDSquared2));
                            t += factor * currentPixel;
                            sum += factor;
                        }
                    }
                    dest.set(x, y, t / sum);
                    continue;
                }
                dest.set(x, y, 0.0f);
            }
        }
    }
}

