/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.slam.utils;

import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.utils.VolumeOps;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.volumes.VolumeShort2;

public class GraphicsMath {
    private static final float INVALID = -2.0f;

    public static void vertex2normal(ImageFloat3 normals, ImageFloat3 verticies) {
        for (int y = 0; y < normals.Y(); ++y) {
            for (int x = 0; x < normals.X(); ++x) {
                Float3 left = verticies.get(Math.max(x - 1, 0), y);
                Float3 right = verticies.get(Math.min(x + 1, verticies.X() - 1), y);
                Float3 up = verticies.get(x, Math.max(y - 1, 0));
                Float3 down = verticies.get(x, Math.min(y + 1, verticies.Y() - 1));
                Float3 dxv = Float3.sub((Float3)right, (Float3)left);
                Float3 dyv = Float3.sub((Float3)down, (Float3)up);
                boolean invalidNormal = left.getZ() == 0.0f || right.getZ() == 0.0f || up.getZ() == 0.0f || down.getZ() == 0.0f;
                Float3 normal = invalidNormal ? new Float3(-2.0f, 0.0f, 0.0f) : Float3.normalise((Float3)Float3.cross((Float3)dyv, (Float3)dxv));
                normals.set(x, y, normal);
            }
        }
    }

    public static void depth2vertex(ImageFloat3 vertices, ImageFloat depths, Matrix4x4Float invK) {
        for (int y = 0; y < depths.Y(); ++y) {
            for (int x = 0; x < depths.X(); ++x) {
                float depth = depths.get(x, y);
                Float3 pix = new Float3((float)x, (float)y, 1.0f);
                Float3 vertex = depth > 0.0f ? Float3.mult((Float3)GraphicsMath.rotate(invK, pix), (float)depth) : new Float3();
                vertices.set(x, y, vertex);
            }
        }
    }

    public static Float3 rotate(Matrix4x4Float m, Float3 x) {
        return new Float3(Float3.dot((Float3)m.row(0).asFloat3(), (Float3)x), Float3.dot((Float3)m.row(1).asFloat3(), (Float3)x), Float3.dot((Float3)m.row(2).asFloat3(), (Float3)x));
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static void getInverseCameraMatrix(Float4 k, Matrix4x4Float m) {
        m.fill(0.0f);
        m.set(0, 0, 1.0f / k.getX());
        m.set(0, 2, -k.getZ() / k.getX());
        m.set(1, 1, 1.0f / k.getY());
        m.set(1, 2, -k.getW() / k.getY());
        m.set(2, 2, 1.0f);
        m.set(3, 3, 1.0f);
    }

    public static void getCameraMatrix(Float4 k, Matrix4x4Float m) {
        m.fill(0.0f);
        m.set(0, 0, k.getX());
        m.set(1, 1, k.getY());
        m.set(0, 2, k.getZ());
        m.set(1, 2, k.getW());
        m.set(2, 2, 1.0f);
        m.set(3, 3, 1.0f);
    }

    public static Float3 rigidTransform(Matrix4x4Float matrix, Float3 point) {
        Float3 translation = matrix.column(3).asFloat3();
        Float3 rotation = new Float3(Float3.dot((Float3)matrix.row(0).asFloat3(), (Float3)point), Float3.dot((Float3)matrix.row(1).asFloat3(), (Float3)point), Float3.dot((Float3)matrix.row(2).asFloat3(), (Float3)point));
        return Float3.add((Float3)rotation, (Float3)translation);
    }

    public static Float4 raycastPoint(VolumeShort2 volume, Float3 dim, int x, int y, Matrix4x4Float view, float nearPlane, float farPlane, float smallStep, float largeStep) {
        float tfar;
        Float3 position = new Float3((float)x, (float)y, 1.0f);
        Float3 origin = view.column(3).asFloat3();
        Float3 direction = GraphicsMath.rotate(view, position);
        Float3 invR = Float3.div((Float3)new Float3(1.0f, 1.0f, 1.0f), (Float3)direction);
        Float3 tbot = Float3.mult((Float3)Float3.mult((Float3)invR, (Float3)origin), (float)-1.0f);
        Float3 ttop = Float3.mult((Float3)invR, (Float3)Float3.sub((Float3)dim, (Float3)origin));
        Float3 tmin = Float3.min((Float3)ttop, (Float3)tbot);
        Float3 tmax = Float3.max((Float3)ttop, (Float3)tbot);
        float largestTmin = Float3.max((Float3)tmin);
        float smallestTmax = Float3.min((Float3)tmax);
        float tnear = TornadoMath.max((float)largestTmin, (float)nearPlane);
        if (tnear < (tfar = TornadoMath.min((float)smallestTmax, (float)farPlane))) {
            float t;
            float stepsize = largeStep;
            Float3 pos = Float3.add((Float3)Float3.mult((Float3)direction, (float)t), (Float3)origin);
            float interp = VolumeOps.interp((VolumeShort2)volume, (Float3)dim, (Float3)pos);
            float interpChanged = 0.0f;
            if (interp > 0.0f) {
                for (t = tnear; t < tfar && !((interpChanged = VolumeOps.interp((VolumeShort2)volume, (Float3)dim, (Float3)(pos = Float3.add((Float3)Float3.mult((Float3)direction, (float)t), (Float3)origin)))) < 0.0f); t += stepsize) {
                    if (interpChanged < 0.8f) {
                        stepsize = smallStep;
                    }
                    interp = interpChanged;
                }
                if (interpChanged < 0.0f) {
                    pos = Float3.add((Float3)Float3.mult((Float3)direction, (float)(t += stepsize * interpChanged / (interp - interpChanged))), (Float3)origin);
                    return new Float4(pos.getX(), pos.getY(), pos.getZ(), t);
                }
            }
        }
        return new Float4();
    }
}

