/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.slam.utils;

import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.vectors.Float3;

public class FloatSE3 {
    final Matrix4x4Float matrix = new Matrix4x4Float();
    Float3 translation = new Float3();

    public FloatSE3(FloatArray v) {
        assert (v.getSize() == 6);
        this.matrix.identity();
        this.exp(v);
        Float3 value = new Float3(v.get(0), v.get(1), v.get(2));
        this.matrix.set(0, 3, value.getX());
        this.matrix.set(1, 3, value.getY());
        this.matrix.set(2, 3, value.getZ());
    }

    public static Matrix4x4Float toMatrix4(float[] v) {
        Matrix4x4Float result = new Matrix4x4Float();
        result.identity();
        result.set(0, 1, -v[5]);
        result.set(0, 2, v[4]);
        result.set(1, 2, -v[3]);
        result.set(1, 0, v[5]);
        result.set(2, 0, -v[4]);
        result.set(2, 1, v[3]);
        result.set(0, 3, v[0]);
        result.set(1, 3, v[1]);
        result.set(2, 3, v[2]);
        return result;
    }

    public static Matrix4x4Float toMatrix4(FloatArray v) {
        Matrix4x4Float result = new Matrix4x4Float();
        result.identity();
        result.set(0, 1, -v.get(5));
        result.set(0, 2, v.get(4));
        result.set(1, 2, -v.get(3));
        result.set(1, 0, v.get(5));
        result.set(2, 0, -v.get(4));
        result.set(2, 1, v.get(3));
        result.set(0, 3, v.get(0));
        result.set(1, 3, v.get(1));
        result.set(2, 3, v.get(2));
        return result;
    }

    public void exp(FloatArray mu) {
        float b;
        float a;
        float one6Th = 0.16666667f;
        float one20Th = 0.05f;
        Float3 muLo = new Float3(mu.get(0), mu.get(1), mu.get(2));
        Float3 w = new Float3(mu.get(3), mu.get(4), mu.get(5));
        float thetaSq = Float3.dot((Float3)w, (Float3)w);
        float theta = TornadoMath.sqrt((float)thetaSq);
        Float3 crossProduct = Float3.cross((Float3)w, (Float3)muLo);
        if (thetaSq < 1.0E-8f) {
            a = 1.0f - 0.16666667f * thetaSq;
            b = 0.5f;
            this.translation = Float3.add((Float3)muLo, (Float3)Float3.mult((Float3)crossProduct, (float)0.5f));
        } else {
            float c;
            if (thetaSq < 1.0E-6f) {
                c = 0.16666667f * (1.0f - 0.05f * thetaSq);
                a = 1.0f - thetaSq * c;
                b = (float)(0.5 - 0.0416666679084301 * (double)thetaSq);
            } else {
                float invTheta = 1.0f / theta;
                a = (float)(Math.sin(theta) * (double)invTheta);
                b = (float)((1.0 - Math.cos(theta)) * (double)this.sq(invTheta));
                c = (1.0f - a) * this.sq(invTheta);
            }
            Float3 wcp = Float3.cross((Float3)w, (Float3)crossProduct);
            Float3 bTemp = Float3.add((Float3)Float3.mult((Float3)crossProduct, (float)b), (Float3)Float3.mult((Float3)wcp, (float)c));
            this.translation = Float3.add((Float3)muLo, (Float3)bTemp);
        }
        this.rodriguesSo3Exp(w, a, b);
    }

    private void rodriguesSo3Exp(Float3 w, float a, float b) {
        this.setMatrixValue(0, 0, 1.0f - b * (this.sq(w.getX()) + this.sq(w.getY())), this.matrix);
        this.setMatrixValue(1, 1, 1.0f - b * (this.sq(w.getX()) + this.sq(w.getZ())), this.matrix);
        this.setMatrixValue(2, 2, 1.0f - b * (this.sq(w.getY()) + this.sq(w.getZ())), this.matrix);
        this.setMatrixValue(0, 1, b * (w.getX() * w.getY()) - a * w.getZ(), this.matrix);
        this.setMatrixValue(1, 0, b * (w.getX() * w.getY()) + a * w.getZ(), this.matrix);
        this.setMatrixValue(0, 2, b * (w.getX() * w.getZ()) + a * w.getY(), this.matrix);
        this.setMatrixValue(2, 0, b * (w.getX() * w.getZ()) - a * w.getY(), this.matrix);
        this.setMatrixValue(1, 2, b * (w.getY() * w.getZ()) - a * w.getX(), this.matrix);
        this.setMatrixValue(2, 1, b * (w.getY() * w.getZ()) + a * w.getX(), this.matrix);
    }

    private void setMatrixValue(int row, int col, float value, Matrix4x4Float matrix) {
        matrix.set(row, col, value);
    }

    public Float3 getTranslation() {
        return this.matrix.column(3).asFloat3();
    }

    public void setTranslation(Float3 trans) {
        for (int i = 0; i < 3; ++i) {
            this.matrix.column(3).asFloat3().set(trans);
        }
    }

    public Matrix4x4Float getMatrix() {
        return this.matrix;
    }

    public void multiply(FloatSE3 m) {
        TornadoInternalError.unimplemented((String)"Multiply FloatSE3 not supported yet.");
    }

    private float sq(float value) {
        return value * value;
    }

    public Matrix4x4Float toMatrix4() {
        Matrix4x4Float newMatrix = new Matrix4x4Float();
        newMatrix.set(this.matrix);
        newMatrix.set(3, 3, 1.0f);
        return newMatrix;
    }

    public String toString() {
        return this.matrix.toString();
    }
}

