/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.slam;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat4;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageByte4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat8;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.utils.VolumeOps;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.vectors.Short2;
import uk.ac.manchester.tornado.api.types.volumes.VolumeShort2;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.slam.utils.FloatSE3;
import uk.ac.manchester.tornado.unittests.slam.utils.GraphicsMath;
import uk.ac.manchester.tornado.unittests.slam.utils.ImagingOps;
import uk.ac.manchester.tornado.unittests.slam.utils.Renderer;

public class GraphicsTests
extends TornadoTestBase {
    private static void testPhiNode(ImageFloat3 vertices, ImageFloat depths, Matrix4x4Float invK) {
        float depth = depths.get(0, 0);
        Float3 pix = new Float3(0.0f, 0.0f, 1.0f);
        Float3 vertex = depth > 0.0f ? Float3.mult((Float3)GraphicsTests.rotate(invK, pix), (float)depth) : new Float3(0.0f, 0.0f, 0.0f);
        vertices.set(0, 0, vertex);
    }

    private static void testPhiNode2(ImageFloat3 vertices, ImageFloat depths, Matrix4x4Float invK) {
        float depth = depths.get(0, 0);
        Float3 pix = new Float3(0.0f, 0.0f, 1.0f);
        Float3 vertex = depth > 0.0f ? Float3.mult((Float3)GraphicsTests.rotate(invK, pix), (float)depth) : new Float3();
        vertices.set(0, 0, vertex);
    }

    private static Float3 rotate(Matrix4x4Float m, Float3 v) {
        return new Float3(Float3.dot((Float3)m.row(0).asFloat3(), (Float3)v), Float3.dot((Float3)m.row(1).asFloat3(), (Float3)v), Float3.dot((Float3)m.row(2).asFloat3(), (Float3)v));
    }

    private static void testRotate(Matrix4x4Float m, VectorFloat3 v, VectorFloat3 result) {
        for (int i = 0; i < v.getLength(); ++i) {
            Float3 r = GraphicsTests.rotate(m, v.get(i));
            result.set(i, r);
        }
    }

    public static void trackPose(ImageFloat8 results, ImageFloat3 verticies, ImageFloat3 normals, ImageFloat3 referenceVerticies, ImageFloat3 referenceNormals, Matrix4x4Float currentPose, Matrix4x4Float view, float distanceThreshold, float normalThreshold) {
        Float8 NO_INPUT = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        Float8 NOT_IN_IMAGE = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f);
        Float8 NO_CORRESPONDENCE = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -3.0f);
        Float8 TOO_FAR = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -4.0f);
        Float8 WRONG_NORMAL = new Float8(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -5.0f);
        for (int y = 0; y < results.Y(); ++y) {
            for (int x = 0; x < results.X(); ++x) {
                boolean isNotInImage;
                if (normals.get(x, y).getX() == -2.0f) {
                    results.set(x, y, NO_INPUT);
                    continue;
                }
                Float3 projectedVertex = GraphicsMath.rigidTransform(currentPose, verticies.get(x, y));
                Float3 projectedPos = GraphicsMath.rigidTransform(view, projectedVertex);
                Float2 projectedPixel = Float2.add((Float2)Float2.mult((Float2)projectedPos.asFloat2(), (float)(1.0f / projectedPos.getZ())), (float)0.5f);
                boolean bl = isNotInImage = projectedPixel.getX() < 0.0f || projectedPixel.getX() > (float)(referenceVerticies.X() - 1) || projectedPixel.getY() < 0.0f || projectedPixel.getY() > (float)(referenceVerticies.Y() - 1);
                if (isNotInImage) {
                    results.set(x, y, NOT_IN_IMAGE);
                    continue;
                }
                Int2 refPixel = new Int2((int)projectedPixel.getX(), (int)projectedPixel.getY());
                Float3 referenceNormal = referenceNormals.get(refPixel.getX(), refPixel.getY());
                if (referenceNormal.getX() == -2.0f) {
                    results.set(x, y, NO_CORRESPONDENCE);
                    continue;
                }
                Float3 diff = Float3.sub((Float3)referenceVerticies.get(refPixel.getX(), refPixel.getY()), (Float3)projectedVertex);
                if (Float3.length((Float3)diff) > distanceThreshold) {
                    results.set(x, y, TOO_FAR);
                    continue;
                }
                Float3 projectedNormal = GraphicsMath.rotate(currentPose, normals.get(x, y));
                if (Float3.dot((Float3)projectedNormal, (Float3)referenceNormal) < normalThreshold) {
                    results.set(x, y, WRONG_NORMAL);
                    continue;
                }
                Float3 b = Float3.cross((Float3)projectedVertex, (Float3)referenceNormal);
                Float8 tracking = new Float8(referenceNormal.getX(), referenceNormal.getY(), referenceNormal.getZ(), b.getX(), b.getY(), b.getZ(), Float3.dot((Float3)referenceNormal, (Float3)diff), 1.0f);
                results.set(x, y, tracking);
            }
        }
    }

    public static void computeRigidTransform(Matrix4x4Float matrix, VectorFloat3 points, VectorFloat3 output) {
        for (int i = 0; i < points.getLength(); ++i) {
            Float3 p = GraphicsMath.rigidTransform(matrix, points.get(i));
            output.set(i, p);
        }
    }

    public static void testNormaliseFunction(VectorFloat3 input, VectorFloat3 output) {
        for (int i = 0; i < input.getLength(); ++i) {
            Float3 norm = Float3.normalise((Float3)input.get(i));
            Float3 res = new Float3(norm.getX(), norm.getY(), norm.getZ());
            output.set(i, res);
        }
    }

    public static void raycast(ImageFloat3 verticies, ImageFloat3 normals, VolumeShort2 volume, Float3 volumeDims, Matrix4x4Float view, float nearPlane, float farPlane, float largeStep, float smallStep) {
        for (int y = 0; y < verticies.Y(); ++y) {
            for (int x = 0; x < verticies.X(); ++x) {
                Float3 normal;
                Float3 position;
                Float4 hit = GraphicsMath.raycastPoint(volume, volumeDims, x, y, view, nearPlane, farPlane, smallStep, largeStep);
                if (hit.getW() > 0.0f) {
                    position = hit.asFloat3();
                    Float3 surfNorm = VolumeOps.grad((VolumeShort2)volume, (Float3)volumeDims, (Float3)position);
                    normal = Float3.length((Float3)surfNorm) != 0.0f ? Float3.normalise((Float3)surfNorm) : new Float3(-2.0f, 0.0f, 0.0f);
                } else {
                    normal = new Float3(-2.0f, 0.0f, 0.0f);
                    position = new Float3();
                }
                verticies.set(x, y, position);
                normals.set(x, y, normal);
            }
        }
    }

    public static void testRayCastPointIsolation(ImageFloat4 output, ImageFloat3 verticies, VolumeShort2 volume, Float3 volumeDims, Matrix4x4Float view, float nearPlane, float farPlane, float largeStep, float smallStep) {
        for (int i = 0; i < verticies.X(); ++i) {
            for (int j = 0; j < verticies.Y(); ++j) {
                Float4 hit = GraphicsMath.raycastPoint(volume, volumeDims, i, j, view, nearPlane, farPlane, smallStep, largeStep);
                output.set(i, j, hit);
            }
        }
    }

    public static void integrate(ImageFloat filteredDepthImage, Matrix4x4Float invTrack, Matrix4x4Float K, Float3 volumeDims, VolumeShort2 volume, float mu, float maxWeight) {
        Float3 tmp = new Float3(0.0f, 0.0f, volumeDims.getZ() / (float)volume.Z());
        Float3 integrateDelta = GraphicsTests.rotate(invTrack, tmp);
        Float3 cameraDelta = GraphicsTests.rotate(K, integrateDelta);
        for (int y = 0; y < volume.Y(); ++y) {
            for (int x = 0; x < volume.X(); ++x) {
                Int3 pix = new Int3(x, y, 0);
                Float3 pos = GraphicsMath.rigidTransform(invTrack, GraphicsTests.pos(volume, volumeDims, pix));
                Float3 cameraX = GraphicsMath.rigidTransform(K, pos);
                for (int z = 0; z < volume.Z(); ++z) {
                    float diff;
                    Int2 px;
                    float depth;
                    Float2 pixel;
                    if (!(pos.getZ() < 1.0E-4f || (pixel = new Float2(cameraX.getX() / cameraX.getZ() + 0.5f, cameraX.getY() / cameraX.getZ() + 0.5f)).getX() < 0.0f || pixel.getX() > (float)(filteredDepthImage.X() - 1) || pixel.getY() < 0.0f || pixel.getY() > (float)(filteredDepthImage.Y() - 1) || (depth = filteredDepthImage.get((px = new Int2((int)pixel.getX(), (int)pixel.getY())).getX(), px.getY())) == 0.0f || !((diff = (depth - cameraX.getZ()) * TornadoMath.sqrt((float)(1.0f + FloatOps.sq((float)(pos.getX() / pos.getZ())) + FloatOps.sq((float)(pos.getY() / pos.getZ()))))) > -mu))) {
                        float sdf = TornadoMath.min((float)1.0f, (float)(diff / mu));
                        Short2 inputValue = volume.get(x, y, z);
                        Float2 constantValue1 = new Float2(3.051944E-5f, 1.0f);
                        Float2 constantValue2 = new Float2(32766.0f, 1.0f);
                        Float2 data = Float2.mult((Float2)new Float2((float)inputValue.getX(), (float)inputValue.getY()), (Float2)constantValue1);
                        float dx = TornadoMath.clamp((float)((data.getY() * data.getX() + sdf) / (data.getY() + 1.0f)), (float)-1.0f, (float)1.0f);
                        float dy = TornadoMath.min((float)(data.getY() + 1.0f), (float)maxWeight);
                        Float2 floatValue = Float2.mult((Float2)new Float2(dx, dy), (Float2)constantValue2);
                        Short2 outputValue = new Short2((short)floatValue.getX(), (short)floatValue.getY());
                        volume.set(x, y, z, outputValue);
                    }
                    pos = Float3.add((Float3)pos, (Float3)integrateDelta);
                    cameraX = Float3.add((Float3)cameraX, (Float3)cameraDelta);
                }
            }
        }
    }

    private static Float3 pos(VolumeShort2 volume, Float3 volumeDims, Int3 p) {
        return new Float3(((float)p.getX() + 0.5f) * volumeDims.getX() / (float)volume.X(), ((float)p.getY() + 0.5f) * volumeDims.getY() / (float)volume.Y(), ((float)p.getZ() + 0.5f) * volumeDims.getZ() / (float)volume.Z());
    }

    public static void volumeOps(VectorFloat3 output, VolumeShort2 volume, Float3 dim, Float3 point) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float3 f = VolumeOps.grad((VolumeShort2)volume, (Float3)dim, (Float3)point);
            output.set(i, f);
        }
    }

    public static void getCameraMatrix(Float4 k, Matrix4x4Float m) {
        m.fill(0.0f);
        m.set(0, 0, k.getX());
        m.set(1, 1, k.getY());
        m.set(0, 2, k.getZ());
        m.set(1, 2, k.getW());
        m.set(2, 2, 1.0f);
        m.set(3, 3, 1.0f);
    }

    public static void reduceValues(FloatArray sums, int startIndex, ImageFloat8 trackingResults, int resultIndex) {
        int jtj = startIndex + 7;
        int info = startIndex + 28;
        Float8 value = trackingResults.get(resultIndex);
        int result = (int)value.getS7();
        float error = value.getS6();
        if (result < 1) {
            boolean condA = result == -4;
            boolean condB = result == -5;
            boolean condC = result > -4;
            sums.set(info + 1, sums.get(info + 1) + (float)condA);
            sums.set(info + 2, sums.get(info + 2) + (float)condB);
            sums.set(info + 3, sums.get(info + 3) + (float)condC);
            return;
        }
        sums.set(startIndex, sums.get(startIndex) + error * error);
        sums.set(startIndex + 0 + 1, sums.get(startIndex + 0 + 1) + error * value.getS0());
        sums.set(startIndex + 1 + 1, sums.get(startIndex + 1 + 1) + error * value.getS1());
        sums.set(startIndex + 2 + 1, sums.get(startIndex + 2 + 1) + error * value.getS2());
        sums.set(startIndex + 3 + 1, sums.get(startIndex + 3 + 1) + error * value.getS3());
        sums.set(startIndex + 4 + 1, sums.get(startIndex + 4 + 1) + error * value.getS4());
        sums.set(startIndex + 5 + 1, sums.get(startIndex + 5 + 1) + error * value.getS5());
        sums.set(jtj + 0, sums.get(jtj + 0) + value.getS0() * value.getS0());
        sums.set(jtj + 1, sums.get(jtj + 1) + value.getS0() * value.getS1());
        sums.set(jtj + 2, sums.get(jtj + 2) + value.getS0() * value.getS2());
        sums.set(jtj + 3, sums.get(jtj + 3) + value.getS0() * value.getS3());
        sums.set(jtj + 4, sums.get(jtj + 4) + value.getS0() * value.getS4());
        sums.set(jtj + 5, sums.get(jtj + 1) + value.getS0() * value.getS5());
        sums.set(jtj + 6, sums.get(jtj + 6) + value.getS1() * value.getS1());
        sums.set(jtj + 7, sums.get(jtj + 1) + value.getS1() * value.getS2());
        sums.set(jtj + 8, sums.get(jtj + 8) + value.getS1() * value.getS3());
        sums.set(jtj + 9, sums.get(jtj + 9) + value.getS1() * value.getS4());
        sums.set(jtj + 10, sums.get(jtj + 10) + value.getS1() * value.getS5());
        sums.set(jtj + 11, sums.get(jtj + 11) + value.getS2() * value.getS2());
        sums.set(jtj + 12, sums.get(jtj + 12) + value.getS2() * value.getS3());
        sums.set(jtj + 13, sums.get(jtj + 13) + value.getS2() * value.getS4());
        sums.set(jtj + 14, sums.get(jtj + 1) + value.getS2() * value.getS5());
        sums.set(jtj + 15, sums.get(jtj + 15) + value.getS3() * value.getS3());
        sums.set(jtj + 16, sums.get(jtj + 16) + value.getS3() * value.getS4());
        sums.set(jtj + 17, sums.get(jtj + 17) + value.getS3() * value.getS5());
        sums.set(jtj + 18, sums.get(jtj + 18) + value.getS4() * value.getS4());
        sums.set(jtj + 19, sums.get(jtj + 19) + value.getS4() * value.getS5());
        sums.set(jtj + 20, sums.get(jtj + 20) + value.getS5() * value.getS5());
        sums.set(info, sums.get(info) + 1.0f);
    }

    public static void mapReduce(FloatArray output, ImageFloat8 input) {
        int numThreads = output.getSize() / 32;
        int numElements = input.X() * input.Y();
        for (int i = 0; i < numThreads; ++i) {
            int j;
            int startIndex = i * 32;
            for (j = 0; j < 32; ++j) {
                output.set(startIndex + j, 0.0f);
            }
            for (j = i; j < numElements; j += numThreads) {
                GraphicsTests.reduceValues(output, startIndex, input, j);
            }
        }
    }

    public static void mapReduce2(FloatArray output, ImageFloat8 input) {
        int startIndex = 0;
        GraphicsTests.reduceValues(output, startIndex, input, 0);
    }

    public static void mapReduce3(VectorFloat4 output, VectorFloat4 input) {
        for (int i = 0; i < input.getLength(); ++i) {
            Float4 f = input.get(i);
            Float4 ff = new Float4(f.get(3), f.get(2), f.get(1), f.get(0));
            output.set(i, ff);
        }
    }

    public static void testVSKernel(int[] x, int[] y, int[] z, VolumeShort2 v, float[] output) {
        for (int i = 0; i < x.length; ++i) {
            output[i] = VolumeOps.vs1((int)x[i], (int)y[i], (int)z[i], (VolumeShort2)v);
        }
    }

    @Test
    public void testMm2Meters() {
        int scaleFactor = 2;
        int srcSize = 100;
        int destSize = srcSize / scaleFactor;
        ImageFloat src = new ImageFloat(srcSize, srcSize);
        ImageFloat dest = new ImageFloat(destSize, destSize);
        ImageFloat destSeq = new ImageFloat(destSize, destSize);
        Random r = new Random();
        for (int i = 0; i < srcSize * srcSize; ++i) {
            src.set(i, r.nextFloat());
        }
        ImagingOps.mm2metersKernel(destSeq, src, scaleFactor);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{src}).task("t0", ImagingOps::mm2metersKernel, (Object)dest, (Object)src, (Object)scaleFactor).transferToHost(1, new Object[]{dest});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < destSize * destSize; ++i) {
            Assert.assertEquals((double)dest.get(i), (double)destSeq.get(i), (double)0.001);
        }
    }

    private void generateGaussian(FloatArray gaussian, int radius, float delta) {
        for (int i = 0; i < gaussian.getSize(); ++i) {
            int x = i - radius;
            gaussian.set(i, (float)Math.exp((float)(-(x * x)) / (2.0f * delta * delta)));
        }
    }

    @Test
    public void testBilateralFilter() {
        int scaleFactor = 2;
        int size = 100;
        int scaledSize = size / scaleFactor;
        ImageFloat src = new ImageFloat(scaledSize, scaledSize);
        ImageFloat dest = new ImageFloat(scaledSize, scaledSize);
        ImageFloat destSeq = new ImageFloat(scaledSize, scaledSize);
        float e_delta = 0.1f;
        int radius = 2;
        float delta = 4.0f;
        FloatArray gaussian = new FloatArray(radius * 2 + 1);
        this.generateGaussian(gaussian, radius, delta);
        Random r = new Random();
        for (int i = 0; i < scaledSize * scaledSize; ++i) {
            src.set(i, r.nextFloat());
        }
        ImagingOps.bilateralFilter(destSeq, src, gaussian, e_delta, radius);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{src, gaussian}).task("t0", ImagingOps::bilateralFilter, (Object)dest, (Object)src, (Object)gaussian, (Object)Float.valueOf(e_delta), (Object)radius).transferToHost(1, new Object[]{dest});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < scaledSize * scaledSize; ++i) {
            Assert.assertEquals((String)("index = " + i), (double)destSeq.get(i), (double)dest.get(i), (double)0.001);
        }
    }

    @Test
    public void testResizeImage6() {
        int scaleFactor = 2;
        int size = 100;
        int scaledSize = size / scaleFactor;
        ImageFloat src = new ImageFloat(scaledSize, scaledSize);
        ImageFloat dest = new ImageFloat(scaledSize, scaledSize);
        ImageFloat destSeq = new ImageFloat(scaledSize, scaledSize);
        float e_delta = 0.1f;
        int radius = 2;
        float delta = 4.0f;
        FloatArray gaussian = new FloatArray(radius * 2 + 1);
        this.generateGaussian(gaussian, radius, delta);
        Random r = new Random();
        for (int i = 0; i < scaledSize * scaledSize; ++i) {
            src.set(i, r.nextFloat());
        }
        ImagingOps.resizeImage6(destSeq, src, scaleFactor, e_delta * 3.0f, radius);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{src}).task("t0", ImagingOps::resizeImage6, (Object)dest, (Object)src, (Object)scaleFactor, (Object)Float.valueOf(e_delta * 3.0f), (Object)radius).transferToHost(1, new Object[]{dest});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < scaledSize * scaledSize; ++i) {
            Assert.assertEquals((String)("index = " + i), (double)destSeq.get(i), (double)dest.get(i), (double)0.001);
        }
    }

    @Test
    public void testRotate() {
        int size = 4;
        Random r = new Random();
        Matrix4x4Float matrix4 = new Matrix4x4Float();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4.set(i, j, (float)j + r.nextFloat());
            }
        }
        VectorFloat3 vector3 = new VectorFloat3(4);
        VectorFloat3 result = new VectorFloat3(4);
        VectorFloat3 sequential = new VectorFloat3(4);
        for (int i = 0; i < 4; ++i) {
            vector3.set(i, new Float3(1.0f, 2.0f, 3.0f));
        }
        GraphicsTests.testRotate(matrix4, vector3, sequential);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrix4, vector3}).task("t0", GraphicsTests::testRotate, (Object)matrix4, (Object)vector3, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 4; ++i) {
            Float3 o = result.get(i);
            Float3 s = sequential.get(i);
            Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
            Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
            Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
        }
    }

    @Test
    public void testDepth2Vertex() {
        int size = 4;
        Random r = new Random();
        Matrix4x4Float matrix4 = new Matrix4x4Float();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4.set(i, j, (float)j + r.nextFloat());
            }
        }
        ImageFloat3 vertext = new ImageFloat3(4, 4);
        ImageFloat depth = new ImageFloat(4, 4);
        ImageFloat3 sequential = new ImageFloat3(4, 4);
        for (int i = 0; i < 4; ++i) {
            depth.set(i, r.nextFloat());
            for (int j = 0; j < 4; ++j) {
                vertext.set(i, j, new Float3(1.0f, 2.0f, 3.0f));
            }
        }
        GraphicsMath.depth2vertex(sequential, depth, matrix4);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrix4, vertext, depth}).task("t0", GraphicsMath::depth2vertex, (Object)vertext, (Object)depth, (Object)matrix4).transferToHost(1, new Object[]{vertext});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Float3 o = vertext.get(i, j);
                Float3 s = sequential.get(i, j);
                Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
                Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
                Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
            }
        }
    }

    @Test
    public void testVertex2Normal() {
        int size = 100;
        ImageFloat3 pyramidNormals = new ImageFloat3(100, 100);
        ImageFloat3 pyramidVertices = new ImageFloat3(100, 100);
        ImageFloat3 sequentialNormals = new ImageFloat3(100, 100);
        float min = -100.0f;
        float max = 100.0f;
        this.fillImageFloat3(pyramidVertices, min, max);
        GraphicsMath.vertex2normal(sequentialNormals, pyramidVertices);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", GraphicsMath::vertex2normal, (Object)pyramidNormals, (Object)pyramidVertices).transferToHost(1, new Object[]{pyramidNormals});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                Float3 o = pyramidNormals.get(i, j);
                Float3 s = sequentialNormals.get(i, j);
                Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
                Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
                Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
            }
        }
    }

    private void fillImageFloat3(ImageFloat3 imageFloat3, float min, float max) {
        Random r = new Random();
        for (int i = 0; i < imageFloat3.X(); ++i) {
            for (int j = 0; j < imageFloat3.Y(); ++j) {
                float x = min + r.nextFloat() * (max - min);
                float y = min + r.nextFloat() * (max - min);
                float z = min + r.nextFloat() * (max - min);
                imageFloat3.set(i, j, new Float3(x, y, z));
            }
        }
    }

    private void fillMatrix4x4Float(Matrix4x4Float matrix, float min, float max) {
        Random r = new Random();
        for (int i = 0; i < matrix.getNumRows(); ++i) {
            for (int j = 0; j < matrix.getNumColumns(); ++j) {
                float x = min + r.nextFloat() * (max - min);
                matrix.set(i, j, x);
            }
        }
    }

    @Test
    public void testTrackPose() {
        int size = 100;
        ImageFloat8 pyramidTrackingResults = new ImageFloat8(100, 100);
        ImageFloat3 pyramidNormals = new ImageFloat3(100, 100);
        ImageFloat3 pyramidVertices = new ImageFloat3(100, 100);
        ImageFloat3 referenceViewVertices = new ImageFloat3(200, 200);
        ImageFloat3 referenceViewNormals = new ImageFloat3(200, 200);
        Matrix4x4Float pyramidPose = new Matrix4x4Float();
        Matrix4x4Float projectReference = new Matrix4x4Float();
        float distanceThreshold = 0.1f;
        float normalThreshold = 0.8f;
        ImageFloat8 sequantialPyramidTrackingResults = new ImageFloat8(100, 100);
        float min = -100.0f;
        float max = 100.0f;
        this.fillImageFloat3(pyramidNormals, min, max);
        this.fillImageFloat3(pyramidVertices, min, max);
        this.fillImageFloat3(referenceViewNormals, min, max);
        this.fillImageFloat3(referenceViewVertices, min, max);
        this.fillMatrix4x4Float(pyramidPose, min, max);
        this.fillMatrix4x4Float(projectReference, min, max);
        GraphicsTests.trackPose(sequantialPyramidTrackingResults, pyramidVertices, pyramidNormals, referenceViewVertices, referenceViewNormals, pyramidPose, projectReference, distanceThreshold, normalThreshold);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{pyramidVertices, pyramidNormals, referenceViewVertices, referenceViewNormals, pyramidPose, projectReference}).task("t0", GraphicsTests::trackPose, (Object)pyramidTrackingResults, (Object)pyramidVertices, (Object)pyramidNormals, (Object)referenceViewVertices, (Object)referenceViewNormals, (Object)pyramidPose, (Object)projectReference, (Object)Float.valueOf(distanceThreshold), (Object)Float.valueOf(normalThreshold)).transferToHost(1, new Object[]{pyramidTrackingResults});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                Float8 o = pyramidTrackingResults.get(i);
                Float8 s = sequantialPyramidTrackingResults.get(i);
                Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
                Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
                Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
                Assert.assertEquals((double)s.getS3(), (double)o.getS3(), (double)0.001);
                Assert.assertEquals((double)s.getS4(), (double)o.getS4(), (double)0.001);
                Assert.assertEquals((double)s.getS5(), (double)o.getS5(), (double)0.001);
                Assert.assertEquals((double)s.getS6(), (double)o.getS6(), (double)0.001);
                Assert.assertEquals((double)s.getS7(), (double)o.getS7(), (double)0.001);
            }
        }
    }

    @Test
    public void testPhiNode() {
        int size = 4;
        Random r = new Random();
        Matrix4x4Float matrix4 = new Matrix4x4Float();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4.set(i, j, (float)j + r.nextFloat());
            }
        }
        ImageFloat3 vertices = new ImageFloat3(4, 4);
        ImageFloat3 verticesSeq = new ImageFloat3(4, 4);
        ImageFloat depth = new ImageFloat(4, 4);
        for (int i = 0; i < 4; ++i) {
            depth.set(i, r.nextFloat());
            for (int j = 0; j < 4; ++j) {
                vertices.set(i, j, new Float3(1.0f, 2.0f, 3.0f));
            }
        }
        GraphicsTests.testPhiNode(verticesSeq, depth, matrix4);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{depth, matrix4}).task("t0", GraphicsTests::testPhiNode, (Object)vertices, (Object)depth, (Object)matrix4).transferToHost(1, new Object[]{vertices});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        Float3 o = vertices.get(0);
        Float3 s = verticesSeq.get(0);
        Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.01);
        Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.01);
        Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.01);
    }

    @Test
    public void testPhiNode2() {
        int size = 4;
        Random r = new Random();
        Matrix4x4Float matrix4 = new Matrix4x4Float();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4.set(i, j, (float)j + r.nextFloat());
            }
        }
        ImageFloat3 vertices = new ImageFloat3(4, 4);
        ImageFloat3 verticesSeq = new ImageFloat3(4, 4);
        ImageFloat depth = new ImageFloat(4, 4);
        for (int i = 0; i < 4; ++i) {
            depth.set(i, r.nextFloat());
            for (int j = 0; j < 4; ++j) {
                vertices.set(i, j, new Float3(1.0f, 2.0f, 3.0f));
            }
        }
        GraphicsTests.testPhiNode2(verticesSeq, depth, matrix4);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{depth, matrix4}).task("t0", GraphicsTests::testPhiNode2, (Object)vertices, (Object)depth, (Object)matrix4).transferToHost(1, new Object[]{vertices});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        Float3 o = vertices.get(0);
        Float3 s = verticesSeq.get(0);
        Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.01);
        Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.01);
        Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.01);
    }

    @Test
    public void testRigidTrasform() {
        int size = 4;
        Random r = new Random();
        Matrix4x4Float matrix4 = new Matrix4x4Float();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix4.set(i, j, (float)j + r.nextFloat());
            }
        }
        VectorFloat3 point = new VectorFloat3(4);
        for (int i = 0; i < 4; ++i) {
            point.set(i, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
        }
        VectorFloat3 sequential = new VectorFloat3(4);
        VectorFloat3 output = new VectorFloat3(4);
        GraphicsTests.computeRigidTransform(matrix4, point, sequential);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrix4, point}).task("t0", GraphicsTests::computeRigidTransform, (Object)matrix4, (Object)point, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 4; ++i) {
            Float3 o = output.get(i);
            Float3 s = sequential.get(i);
            Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
            Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
            Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
        }
    }

    @Test
    public void testNormalise() {
        int size = 128;
        Random r = new Random();
        int min = -100;
        int max = 100;
        float x = (float)min + r.nextFloat() * (float)(max - min);
        float y = (float)min + r.nextFloat() * (float)(max - min);
        float z = (float)min + r.nextFloat() * (float)(max - min);
        VectorFloat3 input = new VectorFloat3(size);
        VectorFloat3 outSeq = new VectorFloat3(size);
        VectorFloat3 out = new VectorFloat3(size);
        for (int i = 0; i < size; ++i) {
            input.set(i, new Float3(x, y, z));
        }
        GraphicsTests.testNormaliseFunction(input, outSeq);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", GraphicsTests::testNormaliseFunction, (Object)input, (Object)out).transferToHost(1, new Object[]{out});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < size; ++i) {
            Float3 o = out.get(i);
            Float3 s = outSeq.get(i);
            Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
            Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
            Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
        }
    }

    @Test
    public void raycastTest() {
        Float3 s;
        Float3 o;
        int j;
        int i;
        int size = 128;
        Random r = new Random();
        Matrix4x4Float view = new Matrix4x4Float();
        ImageFloat3 verticies = new ImageFloat3(128, 128);
        ImageFloat3 normals = new ImageFloat3(128, 128);
        VolumeShort2 volume = new VolumeShort2(128, 128, 128);
        Float3 volumeDims = new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat());
        float nearPlane = r.nextFloat();
        float farPlane = r.nextFloat();
        float largeStep = r.nextFloat();
        float smallStep = r.nextFloat();
        ImageFloat3 verticiesSequential = new ImageFloat3(128, 128);
        ImageFloat3 normalsSequential = new ImageFloat3(128, 128);
        float min = -100.0f;
        float max = 100.0f;
        this.fillMatrix4x4Float(view, min, max);
        for (int i2 = 0; i2 < 128; ++i2) {
            for (int j2 = 0; j2 < 128; ++j2) {
                for (int k = 0; k < 128; ++k) {
                    volume.set(i2, j2, k, new Short2((short)(r.nextInt() + i2 + j2 + k), (short)(r.nextInt() + i2 + j2 - k)));
                }
            }
        }
        GraphicsTests.raycast(verticiesSequential, normalsSequential, volume, volumeDims, view, nearPlane, farPlane, largeStep, smallStep);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{volume, volumeDims, view}).task("t0", GraphicsTests::raycast, (Object)verticies, (Object)normals, (Object)volume, (Object)volumeDims, (Object)view, (Object)Float.valueOf(nearPlane), (Object)Float.valueOf(farPlane), (Object)Float.valueOf(largeStep), (Object)Float.valueOf(smallStep)).transferToHost(1, new Object[]{verticies, normals});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (i = 0; i < 128; ++i) {
            for (j = 0; j < 128; ++j) {
                o = verticies.get(i, j);
                s = verticiesSequential.get(i, j);
                Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
                Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
                Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
            }
        }
        for (i = 0; i < 128; ++i) {
            for (j = 0; j < 128; ++j) {
                o = normals.get(i, j);
                s = normalsSequential.get(i, j);
                Assert.assertEquals((double)s.getS0(), (double)o.getS0(), (double)0.001);
                Assert.assertEquals((double)s.getS1(), (double)o.getS1(), (double)0.001);
                Assert.assertEquals((double)s.getS2(), (double)o.getS2(), (double)0.001);
            }
        }
    }

    @Test
    public void testRaycastPoint() {
        int size = 128;
        Random r = new Random();
        Matrix4x4Float view = new Matrix4x4Float();
        ImageFloat3 verticies = new ImageFloat3(128, 128);
        VolumeShort2 volume = new VolumeShort2(128, 128, 128);
        Float3 volumeDims = new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat());
        float nearPlane = r.nextFloat();
        float farPlane = r.nextFloat();
        float largeStep = r.nextFloat();
        float smallStep = r.nextFloat();
        ImageFloat4 output = new ImageFloat4(128, 128);
        ImageFloat4 outputSeq = new ImageFloat4(128, 128);
        float min = -100.0f;
        float max = 100.0f;
        this.fillMatrix4x4Float(view, min, max);
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 128; ++k) {
                    volume.set(i, j, k, new Short2((short)(r.nextInt() + i + j + k), (short)(r.nextInt() + i + j - k)));
                }
            }
        }
        GraphicsTests.testRayCastPointIsolation(outputSeq, verticies, volume, volumeDims, view, nearPlane, farPlane, largeStep, smallStep);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{verticies, volume, volumeDims, view}).task("t0", GraphicsTests::testRayCastPointIsolation, (Object)output, (Object)verticies, (Object)volume, (Object)volumeDims, (Object)view, (Object)Float.valueOf(nearPlane), (Object)Float.valueOf(farPlane), (Object)Float.valueOf(largeStep), (Object)Float.valueOf(smallStep)).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < output.X(); ++i) {
            for (int j = 0; j < output.Y(); ++j) {
                Float4 o = output.get(i, j);
                Float4 s = outputSeq.get(i, j);
                Assert.assertEquals((double)s.getX(), (double)o.getX(), (double)0.001);
                Assert.assertEquals((double)s.getY(), (double)o.getY(), (double)0.001);
                Assert.assertEquals((double)s.getZ(), (double)o.getZ(), (double)0.001);
                Assert.assertEquals((double)s.getW(), (double)o.getW(), (double)0.001);
            }
        }
    }

    private float random(Random r) {
        return r.nextFloat() * 10.0f;
    }

    private float random(Random r, float min, float max) {
        return min + r.nextFloat() * (max - min);
    }

    @Test
    public void testIntegrate() {
        int j;
        int i;
        int size = 100;
        Random r = new Random();
        Matrix4x4Float invTrack = new Matrix4x4Float();
        Matrix4x4Float m2 = new Matrix4x4Float();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                invTrack.set(i2, j2, (float)j2 + this.random(r));
                m2.set(i2, j2, (float)j2 + this.random(r));
            }
        }
        ImageFloat filteredDepthImage = new ImageFloat(100, 100);
        VolumeShort2 volume = new VolumeShort2(100, 100, 100);
        VolumeShort2 sequential = new VolumeShort2(100, 100, 100);
        Float3 volumeDims = new Float3(this.random(r), this.random(r), this.random(r));
        float mu = this.random(r);
        float maxW = this.random(r);
        for (i = 0; i < 100; ++i) {
            for (j = 0; j < 100; ++j) {
                filteredDepthImage.set(i, j, this.random(r));
            }
        }
        for (i = 0; i < 100; ++i) {
            for (j = 0; j < 100; ++j) {
                for (int k = 0; k < 100; ++k) {
                    volume.set(i, j, k, new Short2(2, 3));
                    sequential.set(i, j, k, new Short2(2, 3));
                }
            }
        }
        GraphicsTests.integrate(filteredDepthImage, invTrack, m2, volumeDims, sequential, mu, maxW);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{filteredDepthImage, invTrack, m2, volumeDims}).task("t0", GraphicsTests::integrate, (Object)filteredDepthImage, (Object)invTrack, (Object)m2, (Object)volumeDims, (Object)volume, (Object)Float.valueOf(mu), (Object)Float.valueOf(maxW)).transferToHost(1, new Object[]{volume});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        int c = 0;
        while (c++ < 10) {
            executionPlan.execute();
        }
        for (int i3 = 0; i3 < 100; ++i3) {
            for (int j3 = 0; j3 < 100; ++j3) {
                for (int k = 0; k < 100; ++k) {
                    Short2 got = volume.get(i3, j3, k);
                    Short2 expected = sequential.get(i3, j3, k);
                    Assert.assertEquals((long)expected.getX(), (long)got.getX());
                    Assert.assertEquals((long)expected.getY(), (long)got.getY());
                }
            }
        }
    }

    @Test
    public void testRenderTrack() {
        int size = 4;
        Random r = new Random();
        ImageByte3 output = new ImageByte3(4, 4);
        ImageByte3 sequential = new ImageByte3(4, 4);
        ImageFloat8 track = new ImageFloat8(4, 4);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                track.set(i, j, new Float8(this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r)));
            }
        }
        Renderer.renderTrack(sequential, track);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{track}).task("t0", Renderer::renderTrack, (Object)output, (Object)track).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Byte3 o = output.get(i, j);
                Byte3 expected = sequential.get(i, j);
                Assert.assertEquals((long)expected.getX(), (long)o.getX());
                Assert.assertEquals((long)expected.getY(), (long)o.getY());
                Assert.assertEquals((long)expected.getZ(), (long)o.getZ());
            }
        }
    }

    @Test
    public void testVolumeGrad() {
        int size = 128;
        Random r = new Random();
        float min = 1.0f;
        float max = 2.0f;
        VolumeShort2 volume = new VolumeShort2(128, 128, 128);
        VectorFloat3 output = new VectorFloat3(16384);
        VectorFloat3 outputSeq = new VectorFloat3(16384);
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 128; ++k) {
                    volume.set(i, j, k, new Short2((short)this.random(r, min, max), (short)this.random(r, min, max)));
                }
            }
        }
        Float3 dim = new Float3(this.random(r, min, max), this.random(r, min, max), this.random(r, min, max));
        Float3 point = new Float3(this.random(r, 0.0f, 1.0f), this.random(r, 0.0f, 1.0f), this.random(r, 0.0f, 1.0f));
        GraphicsTests.volumeOps(outputSeq, volume, dim, point);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{volume, dim, point}).task("t0", GraphicsTests::volumeOps, (Object)output, (Object)volume, (Object)dim, (Object)point).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < output.getLength(); ++i) {
            Float3 o = output.get(i);
            Float3 s = outputSeq.get(i);
            Assert.assertEquals((String)("difference on index " + i + " s0"), (float)s.getS0(), (float)o.getS0(), (float)0.01f);
            Assert.assertEquals((String)("difference on index " + i + " s1"), (float)s.getS1(), (float)o.getS1(), (float)0.01f);
            Assert.assertEquals((String)("difference on index " + i + " s2"), (float)s.getS2(), (float)o.getS2(), (float)0.01f);
        }
    }

    @Test
    public void testCameraMatrix() {
        Float4 f = new Float4(1.0f, 2.0f, 3.0f, 4.0f);
        Matrix4x4Float m = new Matrix4x4Float();
        Matrix4x4Float seq = new Matrix4x4Float();
        GraphicsTests.getCameraMatrix(f, seq);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{f}).task("t0", GraphicsTests::getCameraMatrix, (Object)f, (Object)m).transferToHost(1, new Object[]{m});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < m.getNumRows(); ++i) {
            for (int j = 0; j < m.getNumColumns(); ++j) {
                Assert.assertEquals((float)seq.get(i, j), (float)m.get(i, j), (float)0.01f);
            }
        }
    }

    private Matrix4x4Float getInitPose(Float3 volumeDims) {
        FloatArray pos = new FloatArray(6);
        Float3 float3Pos = Float3.mult((Float3)new Float3(0.5f, 0.5f, 0.0f), (Float3)volumeDims);
        pos.set(0, float3Pos.getX());
        pos.set(1, float3Pos.getY());
        pos.set(2, float3Pos.getZ());
        Matrix4x4Float view = new FloatSE3(pos).toMatrix4();
        return view;
    }

    @Test
    public void testRenderVolume() {
        int size = 128;
        Random r = new Random();
        Int3 volumeSize = new Int3(256, 256, 256);
        ImageByte4 output = new ImageByte4(128, 128);
        ImageByte4 outputSeq = new ImageByte4(128, 128);
        VolumeShort2 volume = new VolumeShort2(volumeSize.getX(), volumeSize.getY(), volumeSize.getZ());
        VolumeShort2 volumeSeq = new VolumeShort2(volumeSize.getX(), volumeSize.getY(), volumeSize.getZ());
        Float3 volumeDims = new Float3(5.0f, 5.0f, 5.0f);
        Float3 volumeDimsSeq = new Float3(5.0f, 5.0f, 5.0f);
        Matrix4x4Float scenePose = this.getInitPose(volumeDims);
        Matrix4x4Float scenePoseSeq = this.getInitPose(volumeDimsSeq);
        float nearPlane = 0.4f;
        float farPlane = 8.0f;
        float largeStep = 0.075f;
        float smallStep = Float3.min((Float3)volumeDims) / (float)Int3.max((Int3)volumeSize);
        Float3 light = new Float3(1.0f, 1.0f, -1.0f);
        Float3 ambient = new Float3(0.1f, 0.1f, 0.1f);
        for (int i = 0; i < volume.X(); ++i) {
            for (int j = 0; j < volume.Y(); ++j) {
                for (int z = 0; z < volume.Z(); ++z) {
                    short r1 = (short)r.nextInt();
                    short r2 = (short)r.nextInt();
                    volume.set(i, j, z, new Short2(r1, r2));
                    volumeSeq.set(i, j, z, new Short2(r1, r2));
                }
            }
        }
        Renderer.renderVolume(outputSeq, volumeSeq, volumeDimsSeq, scenePoseSeq, nearPlane, farPlane * 2.0f, smallStep, largeStep, light, ambient);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{volume, volumeDims, scenePose, light, ambient}).task("t0", Renderer::renderVolume, (Object)output, (Object)volume, (Object)volumeDims, (Object)scenePose, (Object)Float.valueOf(nearPlane), (Object)Float.valueOf(farPlane * 2.0f), (Object)Float.valueOf(smallStep), (Object)Float.valueOf(largeStep), (Object)light, (Object)ambient).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < output.X(); ++i) {
            for (int j = 0; j < output.Y(); ++j) {
                Byte4 o = output.get(i, j);
                Byte4 s = outputSeq.get(i, j);
                Assert.assertEquals((String)("index = " + i + ", " + j), (long)s.getX(), (long)o.getX());
                Assert.assertEquals((String)("index = " + i + ", " + j), (long)s.getY(), (long)o.getY());
                Assert.assertEquals((String)("index = " + i + ", " + j), (long)s.getZ(), (long)o.getZ());
                Assert.assertEquals((String)("index = " + i + ", " + j), (long)s.getW(), (long)o.getW());
            }
        }
    }

    private Float8 createFloat8() {
        Random r = new Random();
        Float8 float8 = new Float8(this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r), this.random(r));
        return float8;
    }

    private Float4 createFloat4() {
        Random r = new Random();
        Float4 float4 = new Float4(this.random(r), this.random(r), this.random(r), this.random(r));
        return float4;
    }

    @Test
    public void testMapReduceSlam() {
        int size = 64;
        FloatArray output = new FloatArray(64);
        FloatArray outputSeq = new FloatArray(64);
        ImageFloat8 image = new ImageFloat8(64, 64);
        for (int i = 0; i < image.X(); ++i) {
            for (int j = 0; j < image.X(); ++j) {
                Float8 f = this.createFloat8();
                image.set(i, j, f);
            }
        }
        GraphicsTests.mapReduce(outputSeq, image);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{image}).task("t0", GraphicsTests::mapReduce, (Object)output, (Object)image).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < output.getSize(); ++i) {
            Assert.assertEquals((float)outputSeq.get(i), (float)output.get(i), (float)0.1f);
        }
    }

    @Test
    public void testMapReduceSlam2() {
        int size = 64;
        FloatArray output = new FloatArray(64);
        FloatArray outputSeq = new FloatArray(64);
        ImageFloat8 image = new ImageFloat8(64, 64);
        for (int i = 0; i < image.X(); ++i) {
            for (int j = 0; j < image.X(); ++j) {
                Float8 f = this.createFloat8();
                image.set(i, j, f);
            }
        }
        GraphicsTests.mapReduce2(outputSeq, image);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", GraphicsTests::mapReduce2, (Object)output, (Object)image).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < output.getSize(); ++i) {
            Assert.assertEquals((float)outputSeq.get(i), (float)output.get(i), (float)0.1f);
        }
    }

    @Ignore
    public void testMapReduceSlam3() {
        int size = 16;
        VectorFloat4 input = new VectorFloat4(16);
        VectorFloat4 output = new VectorFloat4(16);
        for (int i = 0; i < input.getLength(); ++i) {
            Float4 f = this.createFloat4();
            input.set(i, f);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", GraphicsTests::mapReduce3, (Object)output, (Object)input).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
    }

    @Test
    public void testVS() {
        int size = 256;
        int[] x = new int[size];
        int[] y = new int[size];
        int[] z = new int[size];
        float[] output = new float[size];
        float[] seq = new float[size];
        IntStream.range(0, size).parallel().forEach(i -> {
            x[i] = i;
            y[i] = i;
            z[i] = i;
        });
        VolumeShort2 volume = new VolumeShort2(size, size, size);
        for (int i2 = 0; i2 < volume.X(); ++i2) {
            for (int j = 0; j < volume.Y(); ++j) {
                for (int k = 0; k < volume.Z(); ++k) {
                    volume.set(i2, j, k, new Short2(1, 2));
                }
            }
        }
        GraphicsTests.testVSKernel(x, y, z, volume, seq);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{x, y, z, volume}).task("t0", GraphicsTests::testVSKernel, (Object)x, (Object)y, (Object)z, (Object)volume, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i3 = 0; i3 < output.length; ++i3) {
            Assert.assertEquals((float)seq[i3], (float)output[i3], (float)0.001f);
        }
    }

    public final class Constants {
        public static final int X = 0;
        public static final int Y = 1;
        public static final int Z = 2;
        public static final int W = 3;
        public static final float INVALID = -2.0f;
        public static final int BLACK = -1;
        public static final int RED = -2;
        public static final int GREEN = -3;
        public static final int BLUE = -4;
        public static final int YELLOW = -5;
        public static final int GREY = 1;

        private Constants(GraphicsTests this$0) {
        }
    }
}

