/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsLong
extends TornadoTestBase {
    private static final int SIZE = 4096;

    private static void reductionAnnotation(LongArray input, @Reduce LongArray result) {
        result.set(0, 0L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testReductionSum() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(4096);
        LongArray result = new LongArray(1);
        result.init(0L);
        IntStream.range(0, 4096).parallel().forEach(i -> input.set(i, 2L));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLong::reductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        TestReductionsLong.reductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private static void multReductionAnnotation(LongArray input, @Reduce LongArray result) {
        result.set(0, 0L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) * input.get(i));
        }
    }

    @Test
    public void testMultiplicationReduction() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(64);
        LongArray result = new LongArray(1);
        input.set(10, (long)new Random().nextInt(100));
        input.set(50, (long)new Random().nextInt(100));
        boolean neutral = true;
        result.init(1L);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLong::multReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        sequential.init(0L);
        TestReductionsLong.multReductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private static void maxReductionAnnotation(LongArray input, @Reduce LongArray result) {
        result.set(0, 0L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((long)result.get(0), (long)input.get(i)));
        }
    }

    @Test
    public void testMaxReduction() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, (long)r.nextInt(10000)));
        LongArray result = new LongArray(1);
        result.init(Long.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLong::maxReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        TestReductionsLong.maxReductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private static void minReductionAnnotation(LongArray input, @Reduce LongArray result) {
        result.set(0, 0L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((long)result.get(0), (long)input.get(i)));
        }
    }

    @Test
    public void testMinReduction() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(4096);
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, (long)(idx + 1)));
        LongArray result = new LongArray(1);
        result.init(Integer.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsLong::minReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        sequential.init(Long.MAX_VALUE);
        TestReductionsLong.minReductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private static void maxReductionAnnotation2(LongArray input, @Reduce LongArray result) {
        result.set(0, -9223372036854775807L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((long)result.get(0), (long)(input.get(i) * 2L)));
        }
    }

    @Test
    public void testMaxReduction2() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(4096);
        LongArray result = new LongArray(1);
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, (long)idx));
        long neutral = Long.MIN_VALUE;
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLong::maxReductionAnnotation2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        sequential.init(neutral);
        TestReductionsLong.maxReductionAnnotation2(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private static void minReductionAnnotation2(LongArray input, @Reduce LongArray result) {
        result.set(0, 0L);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((long)result.get(0), (long)(input.get(i) * 50L)));
        }
    }

    @Test
    public void testMinReduction2() throws TornadoExecutionPlanException {
        LongArray input = new LongArray(4096);
        LongArray result = new LongArray(1);
        IntStream.range(0, 4096).parallel().forEach(idx -> input.set(idx, 100L));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLong::minReductionAnnotation2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        LongArray sequential = new LongArray(1);
        TestReductionsLong.minReductionAnnotation2(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }
}

