/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsIntegers
extends TornadoTestBase {
    private static final int SMALL_SIZE = 512;
    private static final int BIG_SIZE = 1024;
    private static final int LARGE_SIZE = 262144;
    private static final int SIZE = 4096;

    private static void reductionAnnotation(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    private static void reductionAnnotationConstant(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < 512; ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    private static void reductionAnnotation2(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    private static void reductionAnnotationLarge(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    private static void multReductionAnnotation(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) * input.get(i));
        }
    }

    private static void maxReductionAnnotation(IntArray input, @Reduce IntArray result, int neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((int)result.get(0), (int)input.get(i)));
        }
    }

    private static void minReductionAnnotation(IntArray input, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((int)result.get(0), (int)input.get(i)));
        }
    }

    private static void reductionSequentialSmall(IntArray input, IntArray result) {
        int acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        result.set(0, acc);
    }

    private static void reduction01(IntArray a, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < a.getSize(); ++i) {
            result.set(0, result.get(0) + a.get(i));
        }
    }

    private static void mapReduce01(IntArray a, IntArray b, IntArray c, @Reduce IntArray result) {
        int i;
        for (i = 0; i < a.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
        result.set(0, 0);
        for (i = 0; i < c.getSize(); ++i) {
            result.set(0, result.get(0) + c.get(i));
        }
    }

    private static void map01(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    private static void reduce01(IntArray c, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < c.getSize(); ++i) {
            result.set(0, result.get(0) + c.get(i));
        }
    }

    private static void map02(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i) * a.get(i));
        }
    }

    private static void reduce02(IntArray b, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < b.getSize(); ++i) {
            result.set(0, result.get(0) + b.get(i));
        }
    }

    private static void mapReduce2(IntArray a, IntArray b, @Reduce IntArray result) {
        int i;
        for (i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(0) * b.get(i));
        }
        result.set(0, 0);
        for (i = 0; i < a.getSize(); ++i) {
            result.set(0, result.get(0) + a.get(i));
        }
    }

    private static void reductionAddInts2(IntArray input, @Reduce IntArray result) {
        int error = 2;
        result.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + (error + input.get(i)));
        }
    }

    private static void reductionAddInts3(IntArray inputA, IntArray inputB, @Reduce IntArray result) {
        result.set(0, 0);
        for (int i = 0; i < inputA.getSize(); ++i) {
            result.set(0, result.get(0) + (inputA.get(i) + inputB.get(i)));
        }
    }

    private static void maxReductionAnnotation2(IntArray input, @Reduce IntArray result, int neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((int)result.get(0), (int)(input.get(i) * 100)));
        }
    }

    private static void minReductionAnnotation2(IntArray input, @Reduce IntArray result, int neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((int)result.get(0), (int)(input.get(i) * 50)));
        }
    }

    @Test
    public void testReductionSimple() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(512);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 512).parallel().forEach(i -> input.set(i, 2));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testReductionIntsLarge() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(262144);
        IntArray result = new IntArray(256);
        boolean neutral = false;
        result.init(0);
        IntStream.range(0, input.getSize()).parallel().forEach(i -> input.set(i, 2));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionAnnotationLarge, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAnnotationLarge(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testReductionAnnotation() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(4096);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 4096).parallel().forEach(i -> input.set(i, 2));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionAnnotation2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAnnotation2(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testReductionConstant() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(512);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 512).parallel().forEach(i -> input.set(i, 2));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionAnnotationConstant, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAnnotationConstant(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMultiplicationReduction() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(64);
        IntArray result = new IntArray(1);
        result.init(0);
        input.set(10, new Random().nextInt(100));
        input.set(50, new Random().nextInt(100));
        boolean neutral = true;
        result.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::multReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        sequential.init(0);
        TestReductionsIntegers.multReductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMaxReduction() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, r.nextInt(10000)));
        IntArray result = new IntArray(1);
        int neutral = -2147483647;
        result.init(neutral);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::maxReductionAnnotation, (Object)input, (Object)result, (Object)neutral).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.maxReductionAnnotation(input, sequential, neutral);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMinReduction() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(4096);
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, idx + 1));
        IntArray result = new IntArray(1);
        result.init(Integer.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsIntegers::minReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        sequential.init(Integer.MAX_VALUE);
        TestReductionsIntegers.minReductionAnnotation(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testSequentialReduction() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(1024);
        IntArray result = new IntArray(1);
        result.init(0);
        Random r = new Random();
        IntStream.range(0, 1024).parallel().forEach(i -> input.set(i, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionSequentialSmall, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionSequentialSmall(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.001f);
    }

    @Test
    public void testReduction01() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(512);
        IntArray result = new IntArray(1);
        result.init(0);
        Random r = new Random();
        IntStream.range(0, 512).parallel().forEach(i -> input.set(i, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reduction01, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reduction01(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMapReduce() throws TornadoExecutionPlanException {
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray c = new IntArray(1024);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 1024).parallel().forEach(i -> {
            a.set(i, 10);
            b.set(i, 2);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b, c}).task("t0", TestReductionsIntegers::map01, (Object)a, (Object)b, (Object)c).task("t1", TestReductionsIntegers::reduce01, (Object)c, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1024);
        TestReductionsIntegers.mapReduce01(a, b, c, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMapReduce3() throws TornadoExecutionPlanException {
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray seq = new IntArray(1024);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 1024).parallel().forEach(i -> {
            a.set(i, 10);
            b.set(i, 2);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestReductionsIntegers::map02, (Object)a, (Object)b).task("t1", TestReductionsIntegers::reduce02, (Object)b, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1024);
        TestReductionsIntegers.map02(a, seq);
        TestReductionsIntegers.reduce02(seq, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Ignore
    public void testMapReduceSameKernel() throws TornadoExecutionPlanException {
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray c = new IntArray(1024);
        IntArray result = new IntArray(1);
        result.init(0);
        Random r = new Random();
        IntStream.range(0, 1024).parallel().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b, c}).task("t0", TestReductionsIntegers::mapReduce01, (Object)a, (Object)b, (Object)c, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1024);
        TestReductionsIntegers.mapReduce01(a, b, c, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Ignore
    public void testMapReduce2() throws TornadoExecutionPlanException {
        IntArray a = new IntArray(1024);
        IntArray b = new IntArray(1024);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 1024).parallel().forEach(i -> {
            a.set(i, 1);
            b.set(i, 2);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestReductionsIntegers::mapReduce2, (Object)a, (Object)b, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1024);
        TestReductionsIntegers.mapReduce2(a, b, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testSumInts2() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(512);
        IntArray result = new IntArray(1);
        IntStream.range(0, 512).sequential().forEach(i -> input.set(i, 2));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::reductionAddInts2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAddInts2(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testSumInts3() throws TornadoExecutionPlanException {
        IntArray inputA = new IntArray(4096);
        IntArray inputB = new IntArray(4096);
        IntArray result = new IntArray(1);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            inputA.set(i, r.nextInt());
            inputB.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{inputA, inputB}).task("t0", TestReductionsIntegers::reductionAddInts3, (Object)inputA, (Object)inputB, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.reductionAddInts3(inputA, inputB, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMaxReduction2() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(4096);
        IntArray result = new IntArray(1);
        IntStream.range(0, 4096).forEach(idx -> input.set(idx, idx));
        int neutral = -2147483647;
        result.init(neutral);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::maxReductionAnnotation2, (Object)input, (Object)result, (Object)neutral).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        sequential.init(0);
        TestReductionsIntegers.maxReductionAnnotation2(input, sequential, neutral);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    @Test
    public void testMinReduction2() throws TornadoExecutionPlanException {
        IntArray input = new IntArray(4096);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 4096).parallel().forEach(idx -> input.set(idx, 100));
        result.init(Integer.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegers::minReductionAnnotation2, (Object)input, (Object)result, (Object)Integer.MAX_VALUE).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        TestReductionsIntegers.minReductionAnnotation2(input, sequential, Integer.MAX_VALUE);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }
}

