/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsFloats
extends TornadoTestBase {
    private static final int LARGE_SIZE = 65536;
    private static final int PI_SIZE = 32768;
    private static final int SIZE = 8192;
    private static final int SIZE2 = 32;

    private static void reductionAddFloats(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testSumFloats() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        boolean neutral = false;
        result.init(0.0f);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::reductionAddFloats, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloats(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    private static void reductionAddFloatsConstant(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < 8192; ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testSumFloatsConstant() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        boolean neutral = false;
        result.init(0.0f);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::reductionAddFloatsConstant, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloatsConstant(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    private static void reductionAddFloatsLarge(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testSumFloatsLarge() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(65536);
        FloatArray result = new FloatArray(1024);
        boolean neutral = false;
        result.init(0.0f);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::reductionAddFloatsLarge, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloatsLarge(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)1.0f);
    }

    private static void reductionAddFloats2(FloatArray input, @Reduce FloatArray result) {
        float error = 2.0f;
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            float v = error * input.get(i);
            result.set(0, result.get(0) + v);
        }
    }

    private static void reductionAddFloats3(FloatArray input, @Reduce FloatArray result) {
        float error = 2.0f;
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            float v = error * input.get(i);
            result.set(0, result.get(0) + v);
        }
    }

    private static void reductionAddFloats4(FloatArray inputA, FloatArray inputB, @Reduce FloatArray result) {
        float error = 2.0f;
        result.set(0, 0.0f);
        for (int i = 0; i < inputA.getSize(); ++i) {
            result.set(0, result.get(0) + error * (inputA.get(i) + inputB.get(i)));
        }
    }

    @Test
    public void testSumFloats2() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::reductionAddFloats3, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloats3(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    @Test
    public void testSumFloats3() throws TornadoExecutionPlanException {
        FloatArray inputA = new FloatArray(8192);
        FloatArray inputB = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> {
            inputA.set(i, r.nextFloat());
            inputB.set(i, r.nextFloat());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{inputA, inputB}).task("t0", TestReductionsFloats::reductionAddFloats4, (Object)inputA, (Object)inputB, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloats4(inputA, inputB, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    private static void multiplyFloats(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 1.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) * input.get(i));
        }
    }

    private static void computeSum(FloatArray values, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < values.getSize(); ++i) {
            result.set(0, result.get(0) + values.get(i));
        }
    }

    private static void computeAvg(int length, FloatArray result) {
        result.set(0, result.get(0) / (float)length);
    }

    @Test
    public void testComputeAverage() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("tSum", TestReductionsFloats::computeSum, (Object)input, (Object)result).task("tAverage", TestReductionsFloats::computeAvg, (Object)input.getSize(), (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.computeSum(input, sequential);
        TestReductionsFloats.computeAvg(input.getSize(), sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    @Test
    public void testMultFloats() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        boolean neutral = true;
        result.init(1.0f);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> input.set(i, 1.0f));
        input.set(10, r.nextFloat());
        input.set(12, r.nextFloat());
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::multiplyFloats, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        sequential.init(1.0f);
        TestReductionsFloats.multiplyFloats(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    private static void reductionAddFloatsConditionally(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            float v = 0.0f;
            if (input.get(0) == -1.0f) {
                v = 1.0f;
            }
            result.set(0, result.get(0) + v);
        }
    }

    @Ignore
    public void testSumFloatsCondition() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(32);
        FloatArray result = new FloatArray(1);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::reductionAddFloatsConditionally, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.reductionAddFloatsConditionally(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    private static void computePi(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 1; i < input.getSize(); ++i) {
            float value = input.get(i) + TornadoMath.pow((float)-1.0f, (float)(i + 1)) / (float)(2 * i - 1);
            result.set(0, result.get(0) + value);
        }
    }

    @Test
    public void testComputePi() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(32768);
        FloatArray result = new FloatArray(1);
        IntStream.range(0, 32768).sequential().forEach(i -> input.set(i, 0.0f));
        result.init(0.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsFloats::computePi, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        float piValue = result.get(0) * 4.0f;
        Assert.assertEquals((double)3.14, (double)piValue, (double)0.01f);
    }

    private static void maxReductionAnnotation(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((float)result.get(0), (float)input.get(i)));
        }
    }

    @Test
    public void testMaxReduction() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, (float)idx));
        result.init(Float.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::maxReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        sequential.init(Float.MIN_VALUE);
        TestReductionsFloats.maxReductionAnnotation(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    private static void maxReductionAnnotation2(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((float)result.get(0), (float)(input.get(i) * 100.0f)));
        }
    }

    @Test
    public void testMaxReduction2() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, (float)idx));
        result.init(Float.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::maxReductionAnnotation2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        sequential.init(Float.MIN_VALUE);
        TestReductionsFloats.maxReductionAnnotation2(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    private static void minReductionAnnotation(FloatArray input, @Reduce FloatArray result, float neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((float)result.get(0), (float)input.get(i)));
        }
    }

    @Test
    public void testMinReduction() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        IntStream.range(0, 8192).parallel().forEach(idx -> input.set(idx, (float)idx));
        result.init(Float.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::minReductionAnnotation, (Object)input, (Object)result, (Object)Float.valueOf(Float.MAX_VALUE)).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.minReductionAnnotation(input, sequential, Float.MAX_VALUE);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    private static void minReductionAnnotation2(FloatArray input, @Reduce FloatArray result, float neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((float)result.get(0), (float)(input.get(i) * 50.0f)));
        }
    }

    @Test
    public void testMinReduction2() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(8192);
        FloatArray result = new FloatArray(1);
        IntStream.range(0, 8192).parallel().forEach(idx -> input.set(idx, 100.0f));
        result.init(Float.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::minReductionAnnotation2, (Object)input, (Object)result, (Object)Float.valueOf(Float.MAX_VALUE)).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsFloats.minReductionAnnotation2(input, sequential, Float.MAX_VALUE);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.01f);
    }

    public static float f(float x) {
        return 1.0f / ((x + 1.0f) * TornadoMath.sqrt((float)(x * TornadoMath.exp((float)x))));
    }

    public static void integrationTornado(FloatArray input, @Reduce FloatArray sum, float a, float b) {
        int size = input.getSize();
        sum.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            float value = TestReductionsFloats.f(a + (float)(i + 1) * ((b - a) / (float)size));
            sum.set(0, sum.get(0) + (input.get(i) + value));
        }
    }

    @Test
    public void testIntegrate() throws TornadoExecutionPlanException {
        int size = 8192;
        FloatArray input = new FloatArray(size);
        FloatArray result = new FloatArray(1);
        FloatArray resultSeq = new FloatArray(1);
        result.init(0.0f);
        float a = -1.0f;
        float b = 1.0f;
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloats::integrationTornado, (Object)input, (Object)result, (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(1.0f)).transferToHost(1, new Object[]{result});
        IntStream.range(0, size).sequential().forEach(idx -> input.set(idx, 0.0f));
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 10; ++i) {
                executionPlan.execute();
            }
        }
        TestReductionsFloats.integrationTornado(input, resultSeq, -1.0f, 1.0f);
        float finalValueTornado = 2.0f / (float)size * result.get(0);
        float finalValueSeq = 2.0f / (float)size * resultSeq.get(0);
        Assert.assertEquals((float)finalValueSeq, (float)finalValueTornado, (float)0.01f);
    }
}

