/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsDoubles
extends TornadoTestBase {
    private static final int SIZE_LARGE = 65536;
    private static final int SIZE = 8192;
    private static final int SIZE2 = 32;

    private static void reductionAddDoubles(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testSumDoubles() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).parallel().forEach(i -> input.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsDoubles::reductionAddDoubles, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionAddDoubles(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }

    private static double myFunction(double a, double b) {
        return a + b;
    }

    private static void reductionWithFunctionCall(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TestReductionsDoubles.myFunction(input.get(i), result.get(0)));
        }
    }

    @Test
    public void testSumWithFunctionCall() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).parallel().forEach(i -> input.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsDoubles::reductionWithFunctionCall, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionWithFunctionCall(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }

    private static void reductionAddDoublesLarge(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    @Test
    public void testSumDoublesLarge() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(65536);
        DoubleArray result = new DoubleArray(257);
        Random r = new Random();
        IntStream.range(0, 65536).parallel().forEach(i -> input.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsDoubles::reductionAddDoublesLarge, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionAddDoubles(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }

    private static void reductionAddDoubles2(DoubleArray input, @Reduce DoubleArray result) {
        double error = 2.0;
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            double v = error * input.get(i);
            result.set(0, result.get(0) + v);
        }
    }

    private static void reductionAddDoubles3(DoubleArray input, @Reduce DoubleArray result) {
        double error = 2.0;
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            double v = error * input.get(i);
            result.set(0, result.get(0) + v);
        }
    }

    private static void reductionAddDoubles4(DoubleArray inputA, DoubleArray inputB, @Reduce DoubleArray result) {
        double error = 2.0;
        result.set(0, 0.0);
        for (int i = 0; i < inputA.getSize(); ++i) {
            result.set(0, result.get(0) + error * (inputA.get(i) + inputB.get(i)));
        }
    }

    @Test
    public void testSumDoubles2() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(32);
        DoubleArray result = new DoubleArray(1);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> input.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::reductionAddDoubles2, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionAddDoubles2(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }

    @Test
    public void testSumDoubles3() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> input.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::reductionAddDoubles3, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionAddDoubles3(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.1f);
    }

    @Test
    public void testSumDoubles4() throws TornadoExecutionPlanException {
        DoubleArray inputA = new DoubleArray(8192);
        DoubleArray inputB = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> {
            inputA.set(i, r.nextDouble());
            inputB.set(i, r.nextDouble());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{inputA, inputB}).task("t0", TestReductionsDoubles::reductionAddDoubles4, (Object)inputA, (Object)inputB, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.reductionAddDoubles4(inputA, inputB, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.1f);
    }

    private static void multiplyDoubles(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 1.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) * input.get(i));
        }
    }

    @Test
    public void testMultDoubles() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        result.init(1.0);
        Random r = new Random();
        IntStream.range(0, 8192).sequential().forEach(i -> input.set(i, 1.0));
        input.set(10, r.nextDouble());
        input.set(12, r.nextDouble());
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t1", TestReductionsDoubles::multiplyDoubles, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.multiplyDoubles(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.1f);
    }

    private static void maxReductionAnnotation(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((double)result.get(0), (double)input.get(i)));
        }
    }

    @Test
    public void testMaxReduction() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        Random r = new Random();
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, r.nextDouble()));
        DoubleArray result = new DoubleArray(1);
        result.init(Double.MIN_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::maxReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        sequential.init(Double.MIN_VALUE);
        TestReductionsDoubles.maxReductionAnnotation(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01);
    }

    private static void minReductionAnnotation(DoubleArray input, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((double)result.get(0), (double)input.get(i)));
        }
    }

    @Test
    public void testMinReduction() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        Random r = new Random();
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, r.nextDouble()));
        DoubleArray result = new DoubleArray(1);
        result.init(Double.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::minReductionAnnotation, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        sequential.init(Double.MAX_VALUE);
        TestReductionsDoubles.minReductionAnnotation(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01);
    }

    private static void tornadoRemoveOutliers(DoubleArray values, @Reduce DoubleArray result) {
        double sqrt = TornadoMath.sqrt((double)(12.2321 / (double)values.getSize()));
        double min = result.get(0) - 2.0 * sqrt;
        double max = result.get(0) + 2.0 * sqrt;
        for (int i = 0; i < values.getSize(); ++i) {
            if (!(values.get(i) > max) && !(values.get(i) < min)) continue;
            result.set(0, result.get(0) + 1.0);
        }
    }

    @TornadoNotSupported
    public void testRemoveOutliers() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, 2.0));
        DoubleArray result = new DoubleArray(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::tornadoRemoveOutliers, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.tornadoRemoveOutliers(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01);
    }

    private static void prepareTornadoSumForMeanComputation(DoubleArray values, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < values.getSize(); ++i) {
            result.set(0, result.get(0) + values.get(i));
        }
    }

    private static void computeMapWithReduceValue(DoubleArray values, @Reduce DoubleArray result) {
        for (int i = 0; i < values.getSize(); ++i) {
            values.set(i, result.get(0) + (double)i);
        }
    }

    @Test
    public void testMultipleReductions() throws TornadoExecutionPlanException {
        DoubleArray data = new DoubleArray(8192);
        DoubleArray sequentialReduce = new DoubleArray(1);
        DoubleArray sequentialResult = new DoubleArray(data.getSize());
        IntStream.range(0, data.getSize()).forEach(idx -> {
            data.set(idx, Math.random());
            sequentialResult.set(idx, data.get(idx));
        });
        DoubleArray reduceResult = new DoubleArray(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestReductionsDoubles::prepareTornadoSumForMeanComputation, (Object)data, (Object)reduceResult).task("t1", TestReductionsDoubles::computeMapWithReduceValue, (Object)data, (Object)reduceResult).transferToHost(1, new Object[]{data, reduceResult});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestReductionsDoubles.prepareTornadoSumForMeanComputation(sequentialResult, sequentialReduce);
        TestReductionsDoubles.computeMapWithReduceValue(sequentialResult, sequentialReduce);
        for (int i = 0; i < data.getSize(); ++i) {
            Assert.assertEquals((double)sequentialResult.get(i), (double)data.get(i), (double)0.01f);
        }
    }

    private static void computeStandardDeviation(DoubleArray values, DoubleArray sum, @Reduce DoubleArray std) {
        double s = sum.get(0) / (double)values.getSize();
        std.set(0, 0.0);
        for (int i = 0; i < values.getSize(); ++i) {
            std.set(0, std.get(0) + TornadoMath.pow((double)(values.get(i) - s), (double)2.0));
        }
    }

    @Test
    public void testMultipleReductions2() throws TornadoExecutionPlanException {
        DoubleArray data = new DoubleArray(32);
        DoubleArray data2 = new DoubleArray(32);
        DoubleArray resultSum = new DoubleArray(1);
        DoubleArray resultStd = new DoubleArray(1);
        DoubleArray sequentialSum = new DoubleArray(1);
        DoubleArray sequentialStd = new DoubleArray(1);
        DoubleArray sequentialData = new DoubleArray(data.getSize());
        IntStream.range(0, data.getSize()).forEach(idx -> {
            data.set(idx, Math.random());
            data2.set(idx, data.get(idx));
            sequentialData.set(idx, data.get(idx));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{data, data2}).task("t0", TestReductionsDoubles::prepareTornadoSumForMeanComputation, (Object)data, (Object)resultSum).task("t1", TestReductionsDoubles::computeStandardDeviation, (Object)data2, (Object)resultSum, (Object)resultStd).transferToHost(1, new Object[]{resultSum, resultStd});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestReductionsDoubles.prepareTornadoSumForMeanComputation(sequentialData, sequentialSum);
        TestReductionsDoubles.computeStandardDeviation(sequentialData, sequentialSum, sequentialStd);
        Assert.assertEquals((double)sequentialStd.get(0), (double)resultStd.get(0), (double)0.01);
    }

    private static void prepareTornadoSum(DoubleArray values, @Reduce DoubleArray result) {
        result.set(0, 0.0);
        for (int i = 0; i < values.getSize(); ++i) {
            result.set(0, result.get(0) + values.get(i));
        }
    }

    private static void compute2(DoubleArray values, @Reduce DoubleArray std) {
        std.set(0, 0.0);
        for (int i = 0; i < values.getSize(); ++i) {
            std.set(0, std.get(0) + values.get(i));
        }
    }

    @Test
    public void testMultipleReductions3() throws TornadoExecutionPlanException {
        int size = 8;
        DoubleArray data = new DoubleArray(8);
        DoubleArray resultSum = new DoubleArray(1);
        DoubleArray resultStd = new DoubleArray(1);
        DoubleArray sequentialSum = new DoubleArray(1);
        DoubleArray sequentialStd = new DoubleArray(1);
        DoubleArray sequentialData = new DoubleArray(data.getSize());
        Random r = new Random();
        IntStream.range(0, data.getSize()).forEach(idx -> {
            data.set(idx, r.nextDouble());
            sequentialData.set(idx, data.get(idx));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{data}).task("t0", TestReductionsDoubles::prepareTornadoSum, (Object)data, (Object)resultSum).task("t1", TestReductionsDoubles::compute2, (Object)data, (Object)resultStd).transferToHost(1, new Object[]{resultSum, resultStd});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestReductionsDoubles.prepareTornadoSum(sequentialData, sequentialSum);
        TestReductionsDoubles.compute2(sequentialData, sequentialStd);
        Assert.assertEquals((double)sequentialSum.get(0), (double)resultSum.get(0), (double)0.01);
        Assert.assertEquals((double)sequentialStd.get(0), (double)resultStd.get(0), (double)0.01);
    }

    private static void maxReductionAnnotation2(DoubleArray input, @Reduce DoubleArray result, double neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.max((double)result.get(0), (double)(input.get(i) * 100.0)));
        }
    }

    @Test
    public void testMultipleReductions4() throws TornadoExecutionPlanException {
        int size = 8;
        DoubleArray data1 = new DoubleArray(8);
        DoubleArray data2 = new DoubleArray(8);
        DoubleArray resultStd1 = new DoubleArray(1);
        DoubleArray resultStd2 = new DoubleArray(1);
        DoubleArray sequentialStd1 = new DoubleArray(1);
        DoubleArray sequentialStd2 = new DoubleArray(1);
        DoubleArray sequentialData1 = new DoubleArray(data1.getSize());
        DoubleArray sequentialData2 = new DoubleArray(data2.getSize());
        Random r = new Random();
        IntStream.range(0, data1.getSize()).forEach(idx -> {
            data1.set(idx, r.nextDouble());
            sequentialData1.set(idx, data1.get(idx));
        });
        IntStream.range(0, data2.getSize()).forEach(idx -> {
            data2.set(idx, r.nextDouble());
            sequentialData2.set(idx, data2.get(idx));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{data1, data2}).task("t1", TestReductionsDoubles::compute2, (Object)data1, (Object)resultStd1).task("t2", TestReductionsDoubles::compute2, (Object)data2, (Object)resultStd2).transferToHost(1, new Object[]{resultStd1, resultStd2});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestReductionsDoubles.compute2(sequentialData1, sequentialStd1);
        TestReductionsDoubles.compute2(sequentialData2, sequentialStd2);
        Assert.assertEquals((double)sequentialStd1.get(0), (double)resultStd1.get(0), (double)0.01);
        Assert.assertEquals((double)sequentialStd2.get(0), (double)resultStd2.get(0), (double)0.01);
    }

    @Test
    public void testMultipleReductions5() throws TornadoExecutionPlanException {
        int size = 8;
        DoubleArray data1 = new DoubleArray(8);
        DoubleArray data2 = new DoubleArray(8);
        DoubleArray data3 = new DoubleArray(8);
        DoubleArray resultStd1 = new DoubleArray(1);
        DoubleArray resultStd2 = new DoubleArray(1);
        DoubleArray resultStd3 = new DoubleArray(1);
        DoubleArray sequentialStd1 = new DoubleArray(1);
        DoubleArray sequentialStd2 = new DoubleArray(1);
        DoubleArray sequentialStd3 = new DoubleArray(1);
        DoubleArray sequentialData1 = new DoubleArray(data1.getSize());
        DoubleArray sequentialData2 = new DoubleArray(data2.getSize());
        DoubleArray sequentialData3 = new DoubleArray(data3.getSize());
        Random r = new Random();
        IntStream.range(0, data1.getSize()).forEach(idx -> {
            data1.set(idx, r.nextDouble());
            sequentialData1.set(idx, data1.get(idx));
        });
        IntStream.range(0, data2.getSize()).forEach(idx -> {
            data2.set(idx, r.nextDouble());
            sequentialData2.set(idx, data2.get(idx));
        });
        IntStream.range(0, data3.getSize()).forEach(idx -> {
            data3.set(idx, r.nextDouble());
            sequentialData3.set(idx, data3.get(idx));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{data1, data2, data3}).task("t1", TestReductionsDoubles::compute2, (Object)data1, (Object)resultStd1).task("t2", TestReductionsDoubles::compute2, (Object)data2, (Object)resultStd2).task("t3", TestReductionsDoubles::compute2, (Object)data3, (Object)resultStd3).transferToHost(1, new Object[]{resultStd1, resultStd2, resultStd3});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestReductionsDoubles.compute2(sequentialData1, sequentialStd1);
        TestReductionsDoubles.compute2(sequentialData2, sequentialStd2);
        TestReductionsDoubles.compute2(sequentialData3, sequentialStd3);
        Assert.assertEquals((double)sequentialStd1.get(0), (double)resultStd1.get(0), (double)0.01);
        Assert.assertEquals((double)sequentialStd2.get(0), (double)resultStd2.get(0), (double)0.01);
        Assert.assertEquals((double)sequentialStd3.get(0), (double)resultStd3.get(0), (double)0.01);
    }

    @Test
    public void testMaxReduction2() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        IntStream.range(0, 8192).forEach(idx -> input.set(idx, (double)idx));
        double neutral = 1.0;
        result.init(neutral);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::maxReductionAnnotation2, (Object)input, (Object)result, (Object)neutral).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        sequential.init(neutral);
        TestReductionsDoubles.maxReductionAnnotation2(input, sequential, neutral);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }

    private static void minReductionAnnotation2(DoubleArray input, @Reduce DoubleArray result, double neutral) {
        result.set(0, neutral);
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, TornadoMath.min((double)result.get(0), (double)(input.get(i) * 50.0)));
        }
    }

    @Test
    public void testMinReduction2() throws TornadoExecutionPlanException {
        DoubleArray input = new DoubleArray(8192);
        DoubleArray result = new DoubleArray(1);
        IntStream.range(0, 8192).parallel().forEach(idx -> input.set(idx, 100.0));
        result.init(Double.MAX_VALUE);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoubles::minReductionAnnotation2, (Object)input, (Object)result, (Object)Double.MAX_VALUE).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsDoubles.minReductionAnnotation2(input, sequential, Double.MAX_VALUE);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01f);
    }
}

