/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsAutomatic
extends TornadoTestBase {
    public static void test(IntArray input, @Reduce IntArray output) {
        output.set(0, 0);
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(0, output.get(0) + input.get(i));
        }
    }

    private static void testFloat(FloatArray input, @Reduce FloatArray output) {
        output.set(0, 0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(0, output.get(0) + input.get(i));
        }
    }

    @Test
    public void testIrregularSize01() throws TornadoExecutionPlanException {
        int size = 0x200000F;
        IntArray input = new IntArray(0x200000F);
        IntArray result = new IntArray(1);
        result.init(0);
        IntStream.range(0, 0x200000F).parallel().forEach(i -> input.set(i, i));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsAutomatic::test, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        IntArray sequential = new IntArray(1);
        sequential.init(0);
        TestReductionsAutomatic.test(input, sequential);
        Assert.assertEquals((long)sequential.get(0), (long)result.get(0));
    }

    private void testIrregular(int inputSize) throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(inputSize);
        FloatArray result = new FloatArray(1);
        result.init(0.0f);
        Random r = new Random();
        IntStream.range(0, inputSize).parallel().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsAutomatic::testFloat, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        FloatArray sequential = new FloatArray(1);
        TestReductionsAutomatic.testFloat(input, sequential);
        Assert.assertEquals((float)sequential.get(0), (float)result.get(0), (float)0.1f);
    }

    @Test
    public void testIrregularSize02() throws TornadoExecutionPlanException {
        this.testIrregular(2130);
        this.testIrregular(18);
    }

    @Test
    public void testIrregularSize03() throws TornadoExecutionPlanException {
        int[] dataSizes = new int[11];
        Random r = new Random();
        IntStream.range(0, dataSizes.length).forEach(idx -> {
            dataSizes[idx] = r.nextInt(1000);
        });
        int[] nArray = dataSizes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer size = nArray[i];
            if (size == 0) continue;
            this.testIrregular(size);
        }
    }

    private static void testDouble(DoubleArray input, @Reduce DoubleArray output) {
        output.set(0, 0.0);
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(0, output.get(0) + input.get(i));
        }
    }

    @Test
    public void testIrregularSize04() throws TornadoExecutionPlanException {
        int size = 17;
        DoubleArray input = new DoubleArray(17);
        DoubleArray result = new DoubleArray(1);
        result.init(0.0);
        IntStream.range(0, 17).parallel().forEach(i -> input.set(i, (double)i));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsAutomatic::testDouble, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        DoubleArray sequential = new DoubleArray(1);
        TestReductionsAutomatic.testDouble(input, sequential);
        Assert.assertEquals((double)sequential.get(0), (double)result.get(0), (double)0.01);
    }
}

