/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.stream.IntStream;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class MultipleReductions
extends TornadoTestBase {
    public static void test(IntArray input, @Reduce IntArray output1, @Reduce IntArray output2) {
        for (int i = 0; i < input.getSize(); ++i) {
            output1.set(0, output1.get(0) + input.get(i));
        }
    }

    @Test
    public void test() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray input = new IntArray(128);
        IntArray result1 = new IntArray(1);
        IntArray result2 = new IntArray(1);
        result1.init(0);
        result2.init(0);
        IntStream.range(0, 128).parallel().forEach(i -> input.set(i, i));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", MultipleReductions::test, (Object)input, (Object)result1, (Object)result2).transferToHost(1, new Object[]{result1, result2});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }
}

