/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class InstanceReduction
extends TornadoTestBase {
    public static final int N = 1024;

    @Test
    public void testReductionInstanceClass() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(1024);
        FloatArray result = new FloatArray(1);
        FloatArray expected = new FloatArray(1);
        Random rand = new Random();
        IntStream.range(0, 1024).forEach(i -> input.set(i, rand.nextFloat()));
        for (int i2 = 0; i2 < 1024; ++i2) {
            expected.set(0, expected.get(0) + input.get(i2));
        }
        ReduceTest rd = new ReduceTest(this);
        TaskGraph taskGraph = new TaskGraph("ts").transferToDevice(1, new Object[]{input}).task("reduce", rd::reduce, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((float)expected.get(0), (float)result.get(0), (float)0.1f);
    }

    public class ReduceTest {
        public ReduceTest(InstanceReduction this$0) {
        }

        public void reduce(FloatArray input, @Reduce FloatArray result) {
            result.set(0, 0.0f);
            for (int i = 0; i < input.getSize(); ++i) {
                result.set(0, result.get(0) + input.get(i));
            }
        }
    }
}

