/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.profiler;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.TornadoProfilerResult;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.TestHello;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestProfiler
extends TornadoTestBase {
    private static void reduction(float[] input, @Reduce float[] output) {
        for (int i = 0; i < input.length; ++i) {
            output[0] = output[0] + input[i];
        }
    }

    private boolean isBackendPTXOrSPIRV(int driverIndex) {
        TornadoVMBackendType type = TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex).getBackendType();
        return switch (type) {
            case TornadoVMBackendType.PTX, TornadoVMBackendType.SPIRV -> true;
            default -> false;
        };
    }

    @Test
    public void testProfilerEnabled() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice().clean();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        int driverIndex = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice().getBackendIndex();
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan plan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = plan.withProfiler(ProfilerMode.SILENT).execute();
            Assert.assertTrue((executionResult.getProfilerResult().getTotalTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getTornadoCompilerTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getCompileTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDataTransfersTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceReadTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            if (!this.isBackendPTXOrSPIRV(driverIndex)) {
                Assert.assertTrue((executionResult.getProfilerResult().getDataTransferDispatchTime() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((executionResult.getProfilerResult().getKernelDispatchTime() > 0L ? 1 : 0) != 0);
            }
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceReadTime() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)(executionResult.getProfilerResult().getDeviceWriteTime() + executionResult.getProfilerResult().getDeviceReadTime()), (long)executionResult.getProfilerResult().getDataTransfersTime());
            Assert.assertEquals((long)(executionResult.getProfilerResult().getTornadoCompilerTime() + executionResult.getProfilerResult().getDriverInstallTime()), (long)executionResult.getProfilerResult().getCompileTime());
            plan.withoutProfiler();
        }
    }

    @Test
    public void testProfilerDisabled() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.withoutProfiler().execute();
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getTotalTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getTornadoCompilerTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getCompileTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDataTransfersTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDeviceReadTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDeviceWriteTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDataTransferDispatchTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getKernelDispatchTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDeviceKernelTime());
            Assert.assertEquals((long)0L, (long)executionResult.getProfilerResult().getDeviceKernelTime());
        }
    }

    @Test
    public void testProfilerFromExecutionPlan() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withProfiler(ProfilerMode.CONSOLE);
            TornadoExecutionResult executionResult = executionPlan.execute();
            int driverIndex = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice().getBackendIndex();
            TornadoProfilerResult profilerResult = executionResult.getProfilerResult();
            Assert.assertTrue((profilerResult.getTotalTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getTornadoCompilerTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getCompileTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getDataTransfersTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getDeviceReadTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            if (!this.isBackendPTXOrSPIRV(driverIndex)) {
                Assert.assertTrue((profilerResult.getDataTransferDispatchTime() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((profilerResult.getKernelDispatchTime() > 0L ? 1 : 0) != 0);
            }
            Assert.assertTrue((profilerResult.getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((profilerResult.getDeviceReadTime() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)(profilerResult.getDeviceWriteTime() + profilerResult.getDeviceReadTime()), (long)profilerResult.getDataTransfersTime());
            Assert.assertEquals((long)(profilerResult.getTornadoCompilerTime() + profilerResult.getDriverInstallTime()), (long)profilerResult.getCompileTime());
        }
    }

    @Test
    public void testProfilerOnAndOff() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withProfiler(ProfilerMode.SILENT);
            TornadoExecutionResult executionResult = executionPlan.execute();
            int driverIndex = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice().getBackendIndex();
            Assert.assertTrue((executionResult.getProfilerResult().getTotalTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getTornadoCompilerTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getCompileTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDataTransfersTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceReadTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            if (!this.isBackendPTXOrSPIRV(driverIndex)) {
                Assert.assertTrue((executionResult.getProfilerResult().getDataTransferDispatchTime() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((executionResult.getProfilerResult().getKernelDispatchTime() > 0L ? 1 : 0) != 0);
            }
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceWriteTime() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((executionResult.getProfilerResult().getDeviceReadTime() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)(executionResult.getProfilerResult().getDeviceWriteTime() + executionResult.getProfilerResult().getDeviceReadTime()), (long)executionResult.getProfilerResult().getDataTransfersTime());
            Assert.assertEquals((long)(executionResult.getProfilerResult().getTornadoCompilerTime() + executionResult.getProfilerResult().getDriverInstallTime()), (long)executionResult.getProfilerResult().getCompileTime());
            executionPlan.withoutProfiler().execute();
        }
    }

    @Test
    public void testProfilerReduction() throws TornadoExecutionPlanException {
        int size = 1024;
        float[] inputArray = new float[1024];
        float[] outputArray = new float[1];
        Random r = new Random();
        IntStream.range(0, 1024).forEach(i -> {
            inputArray[i] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("compute");
        taskGraph.transferToDevice(0, new Object[]{inputArray}).task("reduce", TestProfiler::reduction, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        ImmutableTaskGraph itg = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{itg});){
            executionPlan.withProfiler(ProfilerMode.CONSOLE);
            TornadoExecutionResult executionResult = executionPlan.execute();
            long kernelTime = executionResult.getProfilerResult().getDeviceKernelTime();
            Assert.assertTrue((kernelTime > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProfilerReductionOnAndOff() throws TornadoExecutionPlanException {
        int size = 1024;
        float[] inputArray = new float[1024];
        float[] outputArray = new float[1];
        Random r = new Random();
        IntStream.range(0, 1024).forEach(i -> {
            inputArray[i] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("compute");
        taskGraph.transferToDevice(0, new Object[]{inputArray}).task("reduce", TestProfiler::reduction, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        ImmutableTaskGraph itg = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{itg});){
            executionPlan.withProfiler(ProfilerMode.CONSOLE);
            TornadoExecutionResult executionResult = executionPlan.execute();
            long kernelTime = executionResult.getProfilerResult().getDeviceKernelTime();
            Assert.assertTrue((kernelTime > 0L ? 1 : 0) != 0);
            executionPlan.withoutProfiler();
            executionPlan.execute();
            executionPlan.execute();
        }
    }

    @Test
    public void testProfilerReductionOffAndOn() throws TornadoExecutionPlanException {
        int size = 1024;
        float[] inputArray = new float[1024];
        float[] outputArray = new float[1];
        Random r = new Random(71L);
        IntStream.range(0, 1024).forEach(i -> {
            inputArray[i] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("compute");
        taskGraph.transferToDevice(0, new Object[]{inputArray}).task("reduce", TestProfiler::reduction, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        ImmutableTaskGraph itg = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{itg});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            long kernelTime = executionResult.getProfilerResult().getDeviceKernelTime();
            Assert.assertEquals((long)0L, (long)kernelTime);
            executionResult = executionPlan.withProfiler(ProfilerMode.SILENT).execute();
            kernelTime = executionResult.getProfilerResult().getDeviceKernelTime();
            Assert.assertTrue((kernelTime > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testKernelOnAndOff() throws TornadoExecutionPlanException {
        int size = 1024;
        float[] inputArray = new float[1024];
        float[] outputArray = new float[1];
        Random r = new Random(71L);
        IntStream.range(0, 1024).forEach(i -> {
            inputArray[i] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("compute");
        taskGraph.transferToDevice(0, new Object[]{inputArray}).task("reduce", TestProfiler::reduction, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withPrintKernel().execute();
            executionPlan.withoutPrintKernel().execute();
        }
    }

    @Test
    public void testThreadInfoOnAndOff() throws TornadoExecutionPlanException {
        int size = 1024;
        float[] inputArray = new float[1024];
        float[] outputArray = new float[1];
        Random r = new Random(71L);
        IntStream.range(0, 1024).forEach(i -> {
            inputArray[i] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("compute");
        taskGraph.transferToDevice(0, new Object[]{inputArray}).task("reduce", TestProfiler::reduction, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withThreadInfo().execute();
            executionPlan.withoutThreadInfo().execute();
        }
    }
}

