/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.pointers;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestCopyDevicePointers
extends TornadoTestBase {
    public static void iterativeUpdate(FloatArray array) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, array.get(i) + 1.0f);
        }
    }

    public static void iterativeUpdate2D(FloatArray array, int m, int n) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                array.set(i * n + j, (float)i);
            }
        }
    }

    public static void compute(FloatArray array) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, array.get(i) * 2.0f);
        }
    }

    public static void computeRow(FloatArray array) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, array.get(i) + 0.1f);
        }
    }

    @Test
    public void testCopyDevicePointers() throws TornadoExecutionPlanException {
        int size = 32;
        FloatArray srcArray = new FloatArray(32);
        srcArray.init(0.5f);
        TaskGraph taskGraph1 = new TaskGraph("s0").transferToDevice(0, new Object[]{srcArray}).task("s0", TestCopyDevicePointers::iterativeUpdate, (Object)srcArray).transferToHost(2, new Object[]{srcArray});
        FloatArray destArray = new FloatArray(32);
        TaskGraph taskGraph2 = new TaskGraph("s1").transferToDevice(2, new Object[]{destArray}).task("s1", TestCopyDevicePointers::compute, (Object)destArray).transferToHost(1, new Object[]{destArray});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph1.snapshot(), taskGraph2.snapshot()});){
            for (int i2 = 0; i2 < 3; ++i2) {
                executionPlan.withGraph(0).execute();
            }
            boolean offset = false;
            boolean fromGraphIndex = false;
            boolean toGraphIndex = true;
            executionPlan.mapOnDeviceMemoryRegion((Object)destArray, (Object)srcArray, 0L, 0, 1);
            executionPlan.withGraph(1).execute();
            IntStream.range(0, destArray.getSize()).forEach(i -> Assert.assertEquals((float)7.0f, (float)destArray.get(i), (float)0.01f));
        }
    }

    @Test
    public void testCopyDevicePointersMatrix() throws TornadoExecutionPlanException {
        int size = 32;
        FloatArray matrix = new FloatArray(1024);
        TaskGraph taskGraph1 = new TaskGraph("s0").task("s0", TestCopyDevicePointers::iterativeUpdate2D, (Object)matrix, (Object)32, (Object)32).transferToHost(2, new Object[]{matrix});
        FloatArray row = new FloatArray(32);
        TaskGraph taskGraph2 = new TaskGraph("s1").transferToDevice(2, new Object[]{row}).task("s1", TestCopyDevicePointers::computeRow, (Object)row).transferToHost(1, new Object[]{row});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph1.snapshot(), taskGraph2.snapshot()});){
            executionPlan.withGraph(0).execute();
            int offset = 480;
            int fromGraphIndex = 0;
            int toGraphIndex = 1;
            executionPlan.mapOnDeviceMemoryRegion((Object)row, (Object)matrix, (long)offset, fromGraphIndex, toGraphIndex);
            executionPlan.withGraph(1).execute();
            IntStream.range(0, row.getSize()).forEach(i -> Assert.assertEquals((float)15.1f, (float)row.get(i), (float)0.01f));
        }
    }
}

