/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.parameters;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class ParameterTests
extends TornadoTestBase {
    private static void testWithOnlyScalarValues(int x, int y, int z) {
        z = x + y;
    }

    private static void testWithOnlyScalarValues2(int z) {
        z = 0;
    }

    private static void testWithScalarValues03(LongArray x, long y, IntArray z) {
        for (int i = 0; i < x.getSize(); ++i) {
            long tmp = x.get(i) + y;
            z.set(i, (int)tmp);
        }
    }

    @Test(expected=TornadoRuntimeException.class)
    public void testScalarParameters01() {
        int x = 10;
        int y = 20;
        int z = 0;
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{x, y}).task("t0", ParameterTests::testWithOnlyScalarValues, (Object)x, (Object)y, (Object)z).transferToHost(1, new Object[]{z});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
    }

    @Test(expected=TornadoRuntimeException.class)
    public void testScalarParameters02() {
        int z = 0;
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", ParameterTests::testWithOnlyScalarValues2, (Object)z).transferToHost(1, new Object[]{z});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
    }

    @Test
    public void testScalarParameters03() {
        int size = 16;
        LongArray x = new LongArray(16);
        long y = 10L;
        IntArray z = new IntArray(16);
        for (int i = 0; i < 16; ++i) {
            x.set(i, (long)i);
            z.set(i, -1);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{x}).task("t0", ParameterTests::testWithScalarValues03, (Object)x, (Object)y, (Object)z).transferToHost(1, new Object[]{z});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < z.getSize(); ++i) {
            Assert.assertEquals((long)(y + x.get(i)), (long)z.get(i));
        }
    }
}

