/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.numpromotion;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class Types
extends TornadoTestBase {
    private static void b2b(ByteArray input, ByteArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, input.get(i));
        }
    }

    private static void b2s(ByteArray input, ShortArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (short)input.get(i));
        }
    }

    private static void b2i(ByteArray input, IntArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (int)input.get(i));
        }
    }

    private static void b2l(ByteArray input, LongArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (long)input.get(i));
        }
    }

    private static void i2l(IntArray input, LongArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (long)input.get(i));
        }
    }

    private static void s2i(ShortArray input, IntArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (int)input.get(i));
        }
    }

    private static void f2d(FloatArray input, DoubleArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (double)input.get(i));
        }
    }

    private static void i2d(IntArray input, DoubleArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(i, (double)input.get(i));
        }
    }

    @Test
    public void testByteToByte() throws TornadoExecutionPlanException {
        int size = 512;
        ByteArray input = new ByteArray(size);
        ByteArray output = new ByteArray(size);
        ByteArray seq = new ByteArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (byte)r.nextInt(127)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::b2b, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.b2b(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @Test
    public void testByteToByte2() throws TornadoExecutionPlanException {
        int size = 512;
        ByteArray input = new ByteArray(size);
        ByteArray output = new ByteArray(size);
        ByteArray seq = new ByteArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (byte)r.nextInt(127)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::b2b, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.b2b(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @TornadoNotSupported
    public void testByteToInt() throws TornadoExecutionPlanException {
        int size = 512;
        ByteArray input = new ByteArray(size);
        IntArray output = new IntArray(size);
        IntArray seq = new IntArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (byte)r.nextInt(127)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::b2i, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.b2i(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @Test
    public void testByteToShort() throws TornadoExecutionPlanException {
        int size = 512;
        ByteArray input = new ByteArray(size);
        ShortArray output = new ShortArray(size);
        ShortArray seq = new ShortArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (byte)r.nextInt(127)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::b2s, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.b2s(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @Test
    public void testByteToLong() throws TornadoExecutionPlanException {
        int size = 512;
        ByteArray input = new ByteArray(size);
        LongArray output = new LongArray(size);
        LongArray seq = new LongArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (byte)r.nextInt(127)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::b2l, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.b2l(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @Test
    public void testIntToLong() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray input = new IntArray(size);
        LongArray output = new LongArray(size);
        LongArray seq = new LongArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::i2l, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.i2l(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @TornadoNotSupported
    public void testShortToInt() throws TornadoExecutionPlanException {
        int size = 512;
        ShortArray input = new ShortArray(size);
        IntArray output = new IntArray(size);
        IntArray seq = new IntArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, (short)r.nextInt(256)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::s2i, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.s2i(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((long)seq.get(i), (long)output.get(i));
        }
    }

    @Test
    public void testFloatToDouble() throws TornadoExecutionPlanException {
        int size = 512;
        FloatArray input = new FloatArray(size);
        DoubleArray output = new DoubleArray(size);
        DoubleArray seq = new DoubleArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::f2d, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.f2d(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((double)seq.get(i), (double)output.get(i), (double)0.001f);
        }
    }

    @Test
    public void testIntToDouble() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray input = new IntArray(size);
        DoubleArray output = new DoubleArray(size);
        DoubleArray seq = new DoubleArray(size);
        Random r = new Random(System.nanoTime());
        IntStream.range(0, input.getSize()).forEach(x -> input.set(x, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", Types::i2d, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Types.i2d(input, seq);
        for (int i = 0; i < seq.getSize(); ++i) {
            Assert.assertEquals((double)seq.get(i), (double)output.get(i), (double)0.001f);
        }
    }
}

