/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.numpromotion;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;

public class TestZeroExtend {
    public static void narrowByte(ByteArray a, IntArray result, int size) {
        for (int i = 0; i < size; ++i) {
            result.set(i, a.get(i) & 0xFF);
        }
    }

    public static void narrowShort(ShortArray a, LongArray result, int size) {
        for (int i = 0; i < size; ++i) {
            result.set(i, (long)(a.get(i) & 0xFFFF));
        }
    }

    public static void narrowInt(IntArray a, LongArray result, int size) {
        for (int i = 0; i < size; ++i) {
            result.set(i, (long)a.get(i) & 0xFFFFFFFFL);
        }
    }

    @Test
    public void testByte() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 1024;
        ByteArray a = new ByteArray(size);
        for (int i = 0; i < size / 2; ++i) {
            a.set(i, (byte)(128 + r.nextInt(128)));
            a.set(i + size / 2, (byte)r.nextInt(128));
        }
        IntArray expected = new IntArray(size);
        IntArray result = new IntArray(size);
        expected.init(0);
        result.init(0);
        TaskGraph graph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, result}).task("t0", TestZeroExtend::narrowByte, (Object)a, (Object)result, (Object)size).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            TestZeroExtend.narrowByte(a, expected, size);
        }
        for (int i = 0; i < expected.getSize(); ++i) {
            Assert.assertEquals((long)expected.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testShort() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 1024;
        ShortArray a = new ShortArray(size);
        for (int i = 0; i < size / 2; ++i) {
            a.set(i, (short)(Short.MAX_VALUE + (short)r.nextInt(Short.MAX_VALUE)));
            a.set(i + size / 2, (short)r.nextInt(Short.MAX_VALUE));
        }
        LongArray expected = new LongArray(size);
        LongArray result = new LongArray(size);
        expected.init(0L);
        result.init(0L);
        TaskGraph graph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, result}).task("t0", TestZeroExtend::narrowShort, (Object)a, (Object)result, (Object)size).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            TestZeroExtend.narrowShort(a, expected, size);
        }
        for (int i = 0; i < expected.getSize(); ++i) {
            Assert.assertEquals((long)expected.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testInt() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 1024;
        IntArray a = new IntArray(size);
        for (int i = 0; i < size / 2; ++i) {
            a.set(i, Integer.MAX_VALUE + r.nextInt(Integer.MAX_VALUE));
            a.set(i + size / 2, r.nextInt(Integer.MAX_VALUE));
        }
        LongArray expected = new LongArray(size);
        LongArray result = new LongArray(size);
        expected.init(0L);
        result.init(0L);
        TaskGraph graph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, result}).task("t0", TestZeroExtend::narrowInt, (Object)a, (Object)result, (Object)size).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
            TestZeroExtend.narrowInt(a, expected, size);
        }
        for (int i = 0; i < expected.getSize(); ++i) {
            Assert.assertEquals((long)expected.get(i), (long)result.get(i));
        }
    }
}

