/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.numpromotion;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestNumericPromotion
extends TornadoTestBase {
    public static void bitwiseOr(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) | input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void bitwiseAnd(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) & input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void bitwiseXor(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) ^ input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void bitwiseNot(ByteArray result, ByteArray input) {
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(i, ~input.get(i));
        }
    }

    public static void addition(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) + input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void subtraction(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) - input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void multiplication(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) * input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void division(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) / input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void signedLeftShift(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) << input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void signedRightShift(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) >> input.get(i * elements.get(0) + j)));
            }
        }
    }

    public static void unsignedRightShift(ByteArray result, ByteArray input, ByteArray elements) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < elements.get(0); ++j) {
                result.set(j, (byte)(result.get(j) >>> input.get(i * elements.get(0) + j)));
            }
        }
    }

    @Test
    public void testBitwiseOr() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{127, 127, 127, 127, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::bitwiseOr, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        TestNumericPromotion.bitwiseOr(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testBitwiseAnd() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{127, 127, 127, 127, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::bitwiseAnd, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        TestNumericPromotion.bitwiseAnd(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testBitwiseXor() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{127, 127, 127, 127, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::bitwiseXor, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        TestNumericPromotion.bitwiseXor(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testBitwiseNot() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        ByteArray result = new ByteArray(8);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{0, 0, 127, -127, 1, -1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestNumericPromotion::bitwiseNot, (Object)result, (Object)input).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(8);
        TestNumericPromotion.bitwiseNot(sequential, input);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testAddition() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{127, 127, 127, 127, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::addition, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        TestNumericPromotion.addition(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testSubtraction() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{125, 125, 125, 125, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::subtraction, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        TestNumericPromotion.subtraction(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testMultiplication() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        result.init((byte)1);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{125, 125, 125, 125, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::multiplication, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        sequential.init((byte)1);
        TestNumericPromotion.multiplication(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testDivision() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        result.init((byte)8);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{2, 2, 2, 2, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::division, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        sequential.init((byte)8);
        TestNumericPromotion.division(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testSignedLeftShift() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        result.init((byte)8);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{2, 2, 2, 2, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::signedLeftShift, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        sequential.init((byte)8);
        TestNumericPromotion.signedLeftShift(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testSignedRightShift() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        result.init((byte)8);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{2, 2, 2, 2, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::signedRightShift, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        sequential.init((byte)8);
        TestNumericPromotion.signedRightShift(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }

    @Test
    public void testUnsignedRightShift() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        result.init((byte)8);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{2, 2, 2, 2, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", TestNumericPromotion::unsignedRightShift, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        ByteArray sequential = new ByteArray(4);
        sequential.init((byte)8);
        TestNumericPromotion.unsignedRightShift(sequential, input, elements);
        for (int i = 0; i < result.getSize(); ++i) {
            Assert.assertEquals((long)sequential.get(i), (long)result.get(i));
        }
    }
}

