/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.numpromotion;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class Inlining
extends TornadoTestBase {
    public static void bitwiseOr(ByteArray result, ByteArray input, ByteArray elements) {
        result.set(0, (byte)(result.get(0) | input.get(1)));
    }

    public static int b2i(byte v) {
        return v < 0 ? 255 + v : v;
    }

    public static void b2i(ByteArray v, IntArray result) {
        result.set(0, v.get(0) < 0 ? 255 + v.get(0) : v.get(0));
    }

    public static int grey(byte r, byte g, byte b) {
        return (29 * Inlining.b2i(r) + 60 * Inlining.b2i(g) + 11 * Inlining.b2i(b)) / 100;
    }

    public static int grey(byte r) {
        return Inlining.b2i(r) / 100;
    }

    public static int grey(int r, int g, int b) {
        return (29 * Inlining.b2i((byte)r) + 60 * Inlining.b2i((byte)g) + 11 * Inlining.b2i((byte)b)) / 100;
    }

    public static void rgbToGreyKernel(ByteArray rgbBytes, IntArray greyInts) {
        for (int i = 0; i < greyInts.getSize(); ++i) {
            byte r = rgbBytes.get(i * 3);
            byte g = rgbBytes.get(i * 3 + 1);
            byte b = rgbBytes.get(i * 3 + 2);
            greyInts.set(i, Inlining.grey(r, g, b));
        }
    }

    public static void rgbToGreyKernelInt(IntArray rgbBytes, IntArray greyInts) {
        for (int i = 0; i < greyInts.getSize(); ++i) {
            int r = rgbBytes.get(i * 3);
            int g = rgbBytes.get(i * 3 + 1);
            int b = rgbBytes.get(i * 3 + 2);
            greyInts.set(i, Inlining.grey(r, g, b));
        }
    }

    public static void rgbToGreyKernelSmall(ByteArray rgbBytes, IntArray greyInts) {
        for (int i = 0; i < greyInts.getSize(); ++i) {
            byte r = rgbBytes.get(i);
            greyInts.set(i, Inlining.grey(r));
        }
    }

    @Test
    public void test0() throws TornadoExecutionPlanException {
        ByteArray elements = new ByteArray(1);
        elements.init((byte)4);
        ByteArray result = new ByteArray(4);
        ByteArray input = ByteArray.fromElements((byte[])new byte[]{127, 127, 127, 127, 1, 1, 1, 1});
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{result, input, elements}).task("t0", Inlining::bitwiseOr, (Object)result, (Object)input, (Object)elements).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @TornadoNotSupported
    public void rgbToGreyKernel() throws TornadoExecutionPlanException {
        int size = 256;
        ByteArray rgbBytes = new ByteArray(768);
        IntArray greyInts = new IntArray(256);
        IntArray seq = new IntArray(256);
        Random r = new Random();
        IntStream.range(0, rgbBytes.getSize()).forEach(i -> rgbBytes.set(i, (byte)r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("foo");
        taskGraph.transferToDevice(1, new Object[]{rgbBytes}).task("grey", Inlining::rgbToGreyKernel, (Object)rgbBytes, (Object)greyInts).transferToHost(1, new Object[]{greyInts});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Inlining.rgbToGreyKernel(rgbBytes, seq);
        for (int i2 = 0; i2 < seq.getSize(); ++i2) {
            Assert.assertEquals((long)seq.get(i2), (long)greyInts.get(i2));
        }
    }

    @Test
    public void rgbToGreyKernelInt() throws TornadoExecutionPlanException {
        int size = 256;
        IntArray rgbBytes = new IntArray(768);
        IntArray greyInts = new IntArray(256);
        IntArray seq = new IntArray(256);
        IntStream.range(0, rgbBytes.getSize()).forEach(i -> rgbBytes.set(i, 1));
        TaskGraph taskGraph = new TaskGraph("foo");
        taskGraph.transferToDevice(1, new Object[]{rgbBytes}).task("grey", Inlining::rgbToGreyKernelInt, (Object)rgbBytes, (Object)greyInts).transferToHost(1, new Object[]{greyInts});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Inlining.rgbToGreyKernelInt(rgbBytes, seq);
        for (int i2 = 0; i2 < seq.getSize(); ++i2) {
            Assert.assertEquals((long)seq.get(i2), (long)greyInts.get(i2));
        }
    }

    @TornadoNotSupported
    public void rgbToGreyKernelSmall() throws TornadoExecutionPlanException {
        int size = 256;
        ByteArray rgbBytes = new ByteArray(256);
        IntArray greyInts = new IntArray(256);
        IntArray seq = new IntArray(256);
        Random r = new Random();
        IntStream.range(0, rgbBytes.getSize()).forEach(i -> rgbBytes.set(i, (byte)-10));
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{rgbBytes}).task("t0", Inlining::rgbToGreyKernelSmall, (Object)rgbBytes, (Object)greyInts).transferToHost(1, new Object[]{greyInts});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Inlining.rgbToGreyKernelSmall(rgbBytes, seq);
        for (int i2 = 0; i2 < seq.getSize(); ++i2) {
            Assert.assertEquals((long)seq.get(i2), (long)greyInts.get(i2));
        }
    }

    @TornadoNotSupported
    public void b2i() throws TornadoExecutionPlanException {
        ByteArray rgbBytes = new ByteArray(1);
        IntArray greyInts = new IntArray(1);
        IntArray seq = new IntArray(1);
        IntStream.range(0, rgbBytes.getSize()).forEach(i -> rgbBytes.set(i, (byte)-10));
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{rgbBytes}).task("t0", Inlining::b2i, (Object)rgbBytes, (Object)greyInts).transferToHost(1, new Object[]{greyInts});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Inlining.b2i(rgbBytes, seq);
        for (int i2 = 0; i2 < seq.getSize(); ++i2) {
            Assert.assertEquals((long)seq.get(i2), (long)greyInts.get(i2));
        }
    }
}

