/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.neurocom;

import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestCase
extends TornadoTestBase {
    private static final int N = 512;

    private static void KMeansCalculateCentroids(ShortArray cache_dqsize, IntArray cache_dstart, IntArray cache_dqid, FloatArray cache_dqtfidf, FloatArray cache_kmeans, IntArray doc_group, IntArray sizes) {
        int N = sizes.get(0);
        int V = sizes.get(1);
        int K = sizes.get(5);
        for (int j = 0; j < K; ++j) {
            int k;
            int kj_len = 1;
            for (k = 0; k < V; ++k) {
                cache_kmeans.set(V * j + k, 0.0f);
            }
            for (int i = 0; i < N; ++i) {
                if (doc_group.get(i) != j) continue;
                ++kj_len;
                int di_start = cache_dstart.get(i);
                int di_end = cache_dqsize.get(i) + di_start;
                for (int di_idx = di_start; di_idx < di_end; ++di_idx) {
                    int qi = cache_dqid.get(di_idx);
                    cache_kmeans.set(V * j + qi, cache_kmeans.get(V * j + qi) + cache_dqtfidf.get(di_idx));
                }
            }
            for (k = 0; k < V; ++k) {
                cache_kmeans.set(V * j + k, cache_kmeans.get(V * j + k) / (float)kj_len);
            }
        }
    }

    @Test
    public void test() throws TornadoExecutionPlanException {
        ShortArray cache_dqsize = new ShortArray(512);
        IntArray cache_dstart = new IntArray(512);
        FloatArray cache_kmeans = new FloatArray(262144);
        IntArray doc_group = new IntArray(512);
        int total_len = 10;
        IntArray cache_dqid = new IntArray(total_len);
        FloatArray cache_dqtfidf = new FloatArray(total_len);
        IntArray sizes = new IntArray(6);
        TaskGraph taskGraph = new TaskGraph("foo").transferToDevice(0, new Object[]{cache_dqsize, cache_dqid, cache_dqtfidf, cache_kmeans, doc_group}).task("bar", TestCase::KMeansCalculateCentroids, (Object)cache_dqsize, (Object)cache_dstart, (Object)cache_dqid, (Object)cache_dqtfidf, (Object)cache_kmeans, (Object)doc_group, (Object)sizes).transferToHost(1, new Object[]{cache_dstart});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
    }
}

