/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.memory.leak;

import java.time.Duration;
import java.time.Instant;
import java.util.stream.IntStream;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMemoryLeak
extends TornadoTestBase {
    public static final int TEST_TIME_MINUTES = 5;

    public static void vectorAddLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorAddLongPrimitive(long[] a, long[] b, long[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
    }

    @Test
    public void test_no_cached_hot_loop() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        while (Instant.now().isBefore(end)) {
            LongArray a = new LongArray(0x200000);
            LongArray b = new LongArray(0x200000);
            LongArray c = new LongArray(0x200000);
            IntStream.range(0, 0x200000).parallel().forEach(i -> {
                a.set(i, (long)i);
                b.set(i, (long)i);
            });
            TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
                executionPlan.execute();
            }
            catch (TornadoExecutionPlanException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void test_no_cached_hot_loop_primitive() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        while (Instant.now().isBefore(end)) {
            long[] a = new long[0x200000];
            long[] b = new long[0x200000];
            long[] c = new long[0x200000];
            IntStream.range(0, 0x200000).parallel().forEach(i -> {
                a[i] = i;
                b[i] = i;
            });
            TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLongPrimitive, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
                executionPlan.execute();
            }
            catch (TornadoExecutionPlanException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void test_cached_task_graph_and_input_output_primitive() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        long[] a = new long[0x200000];
        long[] b = new long[0x200000];
        long[] c = new long[0x200000];
        IntStream.range(0, 0x200000).parallel().forEach(i -> {
            a[i] = i;
            b[i] = i;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLongPrimitive, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        while (Instant.now().isBefore(end)) {
            try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
                executionPlan.execute();
            }
            catch (TornadoExecutionPlanException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void test_cached_task_graph_and_input_output() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        LongArray a = new LongArray(0x200000);
        LongArray b = new LongArray(0x200000);
        LongArray c = new LongArray(0x200000);
        IntStream.range(0, 0x200000).parallel().forEach(i -> {
            a.set(i, (long)i);
            b.set(i, (long)i);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        while (Instant.now().isBefore(end)) {
            try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
                executionPlan.execute();
            }
            catch (TornadoExecutionPlanException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void test_cached_everything_primitive() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        long[] a = new long[0x200000];
        long[] b = new long[0x200000];
        long[] c = new long[0x200000];
        IntStream.range(0, 0x200000).parallel().forEach(i -> {
            a[i] = i;
            b[i] = i;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLongPrimitive, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            while (Instant.now().isBefore(end)) {
                executionPlan.execute();
            }
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void test_cached_everything() {
        Instant end = Instant.now().plus(Duration.ofMinutes(5L));
        int numElements = 0x200000;
        LongArray a = new LongArray(0x200000);
        LongArray b = new LongArray(0x200000);
        LongArray c = new LongArray(0x200000);
        IntStream.range(0, 0x200000).parallel().forEach(i -> {
            a.set(i, (long)i);
            b.set(i, (long)i);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestMemoryLeak::vectorAddLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            while (Instant.now().isBefore(end)) {
                executionPlan.execute();
            }
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
    }
}

