/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.memory;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestStressDeviceMemory
extends TornadoTestBase {
    public static void moveData(FloatArray inputArray, FloatArray outputArray) {
        for (int i = 0; i < inputArray.getSize(); ++i) {
            outputArray.set(i, inputArray.get(i));
        }
    }

    public static void stressDataAllocationTest(int dataSizeFactor) throws TornadoExecutionPlanException {
        System.out.println("SIZE: " + dataSizeFactor + " Allocating size: " + dataSizeFactor * 4 + " (bytes)");
        FloatArray inputArray = new FloatArray(dataSizeFactor);
        FloatArray outputArray = new FloatArray(dataSizeFactor);
        inputArray.init(0.1f);
        TaskGraph taskGraph = new TaskGraph("stress" + dataSizeFactor).transferToDevice(1, new Object[]{inputArray}).task("moveData", TestStressDeviceMemory::moveData, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void test01() {
        int minSize = 0x10000000;
        for (int i = 0; i < 10; ++i) {
            try {
                TestStressDeviceMemory.stressDataAllocationTest(0x10000000);
                Assert.assertTrue((boolean)true);
                continue;
            }
            catch (TornadoExecutionPlanException e) {
                Assert.fail();
            }
        }
    }

    @Test
    public void test02() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long twelveGB = 0x300000000L;
        if (maxMemory < 0x300000000L) {
            Assert.fail();
        } else {
            for (int i = 400; i < 500; i += 10) {
                int size = 0x100000 * i;
                try {
                    TestStressDeviceMemory.stressDataAllocationTest(size);
                    Assert.assertTrue((boolean)true);
                    continue;
                }
                catch (TornadoExecutionPlanException e) {
                    Assert.fail();
                }
            }
        }
    }
}

