/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.memory;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.TestHello;
import uk.ac.manchester.tornado.unittests.memory.TestMemoryCommon;

public class TestMemoryLimit
extends TestMemoryCommon {
    @BeforeClass
    public static void setUpBeforeClass() {
        a = new IntArray(0x4B00000);
        b = new IntArray(0x4B00000);
        c = new IntArray(0x4B00000);
        a.init(1);
        b.init(2);
    }

    public static void add(IntArray a, IntArray b, IntArray c, int value) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i) + value);
        }
    }

    @Test
    public void testWithMemoryLimitOver() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMemoryLimit::add, (Object)a, (Object)b, (Object)c, (Object)value).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withMemoryLimit("1GB").execute();
            for (int i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((double)(a.get(i) + b.get(i) + value), (double)c.get(i), (double)0.001);
            }
        }
    }

    @Test(expected=TornadoMemoryException.class)
    public void testWithMemoryLimitUnder() {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withMemoryLimit("512MB").execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((double)(a.get(i) + b.get(i)), (double)c.get(i), (double)0.001);
        }
    }

    @Test
    public void enableAndDisable() {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withMemoryLimit("1GB").execute();
        executionPlan.withoutMemoryLimit().execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((double)(a.get(i) + b.get(i)), (double)c.get(i), (double)0.001);
        }
        executionPlan.freeDeviceMemory();
    }
}

