/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.memory;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.unittests.memory.TestMemoryCommon;
import uk.ac.manchester.tornado.unittests.memory.TestMemoryLimit;

public class MemoryConsumptionTest
extends TestMemoryCommon {
    @Test
    public void testMemoryTransferBytes() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMemoryLimit::add, (Object)a, (Object)b, (Object)c, (Object)value).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.withProfiler(ProfilerMode.SILENT).execute();
            long totalBytesTransferred = executionResult.getProfilerResult().getTotalBytesTransferred();
            long copyInBytes = executionResult.getProfilerResult().getTotalBytesCopyIn();
            long copyOutBytes = executionResult.getProfilerResult().getTotalBytesCopyOut();
            Assert.assertEquals((long)(copyInBytes + copyOutBytes), (long)totalBytesTransferred);
        }
    }

    @Test
    public void testTotalMemoryUsage() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMemoryLimit::add, (Object)a, (Object)b, (Object)c, (Object)value).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.withProfiler(ProfilerMode.SILENT).execute();
            long totalMemoryUsedInBytes = executionResult.getProfilerResult().getTotalDeviceMemoryUsage();
            long sizeAllocated = a.getNumBytesOfSegmentWithHeader() * 3L;
            Assert.assertEquals((long)sizeAllocated, (long)totalMemoryUsedInBytes);
        }
    }

    @Test
    public void testCurrentMemoryUsage() throws TornadoExecutionPlanException {
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMemoryLimit::add, (Object)a, (Object)b, (Object)c, (Object)value).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withProfiler(ProfilerMode.SILENT).execute();
            long currentMemoryUsageInBytes = executionPlan.getCurrentDeviceMemoryUsage();
            long sizeAllocated = a.getNumBytesOfSegmentWithHeader() * 3L;
            Assert.assertEquals((long)sizeAllocated, (long)currentMemoryUsageInBytes);
        }
    }
}

