/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.matrices;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.collections.VectorInt;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DDouble;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat4;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DInt;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DDouble;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DFloat4;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DInt;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DLong;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DShort;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMatrixTypes
extends TornadoTestBase {
    public static void computeMatrixSum(Matrix2DFloat a, Matrix2DFloat b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                b.set(i, j, a.get(i, j) + a.get(i, j));
            }
        }
    }

    public static void computeMatrixSum(Matrix3DFloat a, Matrix3DFloat b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    b.set(i, j, k, a.get(i, j, k) + a.get(i, j, k));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix3DInt a, Matrix3DInt b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    b.set(i, j, k, a.get(i, j, k) + a.get(i, j, k));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix3DDouble a, Matrix3DDouble b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    b.set(i, j, k, a.get(i, j, k) + a.get(i, j, k));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix3DLong a, Matrix3DLong b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    b.set(i, j, k, a.get(i, j, k) + a.get(i, j, k));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix3DShort a, Matrix3DShort b, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < N; ++k) {
                    b.set(i, j, k, (short)(a.get(i, j, k) + a.get(i, j, k)));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix3DFloat a, Matrix3DFloat b, int X, int Y, int Z) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                for (int k = 0; k < Z; ++k) {
                    b.set(i, j, k, a.get(i, j, k) + a.get(i, j, k));
                }
            }
        }
    }

    public static void computeMatrixSum(Matrix2DFloat a, Matrix2DFloat b, int X, int Y) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                b.set(i, j, a.get(i, j) + a.get(i, j));
            }
        }
    }

    public static void computeMatrixSum(Matrix2DInt a, Matrix2DInt b, int X, int Y) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                b.set(i, j, a.get(i, j) + a.get(i, j));
            }
        }
    }

    public static void computeMatrixSum(Matrix2DDouble a, Matrix2DDouble b, int X, int Y) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                b.set(i, j, a.get(i, j) + a.get(i, j));
            }
        }
    }

    public static void computeMatrixMultiplication(Matrix2DFloat a, Matrix2DFloat b, Matrix2DFloat c) {
        for (int i = 0; i < a.getNumRows(); ++i) {
            for (int j = 0; j < a.getNumColumns(); ++j) {
                float sum = 0.0f;
                for (int k = 0; k < a.getNumColumns(); ++k) {
                    sum += a.get(i, k) + a.get(k, j);
                }
                c.set(i, j, sum);
            }
        }
    }

    public static void computeMatrixSum(Matrix2DFloat4 a, Matrix2DFloat4 b, int X, int Y) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                b.set(i, j, Float4.add((Float4)a.get(i, j), (Float4)a.get(i, j)));
            }
        }
    }

    public static void computeMatrixSum(Matrix3DFloat4 a, Matrix3DFloat4 b, int X, int Y, int Z) {
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                for (int k = 0; k < Z; ++k) {
                    b.set(i, j, k, Float4.add((Float4)a.get(i, j, k), (Float4)a.get(i, j, k)));
                }
            }
        }
    }

    public static void testMatrix2DVectorType(int X, int Y) throws TornadoExecutionPlanException {
        Matrix2DFloat4 matrixA = new Matrix2DFloat4(X, Y);
        Matrix2DFloat4 matrixB = new Matrix2DFloat4(X, Y);
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Float4 vector = new Float4();
                for (int k = 0; k < vector.size(); ++k) {
                    vector.set(k, r.nextFloat());
                }
                matrixA.set(i, j, vector);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0&" + Y).transferToDevice(0, new Object[]{matrixA}).task("t0&" + X, TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)X, (Object)Y).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Float4 expected = Float4.add((Float4)matrixA.get(i, j), (Float4)matrixA.get(i, j));
                Assert.assertTrue((boolean)Float4.isEqual((Float4)expected, (Float4)matrixB.get(i, j)));
            }
        }
    }

    public static void testMatrix3DVectorType(int X, int Y, int Z) throws TornadoExecutionPlanException {
        Matrix3DFloat4 matrixA = new Matrix3DFloat4(X, Y, Z);
        Matrix3DFloat4 matrixB = new Matrix3DFloat4(X, Y, Z);
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                for (int k = 0; k < Z; ++k) {
                    Float4 vector = new Float4();
                    for (int v = 0; v < vector.size(); ++v) {
                        vector.set(v, r.nextFloat());
                    }
                    matrixA.set(i, j, k, vector);
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0_" + X).transferToDevice(0, new Object[]{matrixA}).task("t0_" + Y, TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)X, (Object)Y, (Object)Z).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                for (int k = 0; k < Z; ++k) {
                    Float4 expected = Float4.add((Float4)matrixA.get(i, j, k), (Float4)matrixA.get(i, j, k));
                    if (!Float4.isEqual((Float4)expected, (Float4)matrixB.get(i, j, k))) {
                        Assert.fail();
                        continue;
                    }
                    Assert.assertTrue((boolean)true);
                }
            }
        }
    }

    private static void testMatricesFloats(int X, int Y) throws TornadoExecutionPlanException {
        float[][] a = new float[X][Y];
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                a[i][j] = r.nextFloat();
            }
        }
        Matrix2DFloat matrixA = new Matrix2DFloat(a);
        Matrix2DFloat matrixB = new Matrix2DFloat(X, Y);
        TaskGraph taskGraph = new TaskGraph("suoa").transferToDevice(0, new Object[]{matrixA}).task("tpsefs", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)X, (Object)Y).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((float)(matrixA.get(i, j) + matrixA.get(i, j)), (float)matrixB.get(i, j), (float)0.01f);
            }
        }
    }

    private static void testMatrixIntegers(int X, int Y) throws TornadoExecutionPlanException {
        int[][] a = new int[X][Y];
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                a[i][j] = r.nextInt();
            }
        }
        Matrix2DInt matrixA = new Matrix2DInt(a);
        Matrix2DInt matrixB = new Matrix2DInt(X, Y);
        TaskGraph taskGraph = new TaskGraph("sgjegje").transferToDevice(0, new Object[]{matrixA}).task("t3242", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)X, (Object)Y).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((long)(matrixA.get(i, j) + matrixA.get(i, j)), (long)matrixB.get(i, j));
            }
        }
    }

    private static void testMatrixDoubles(int X, int Y) throws TornadoExecutionPlanException {
        double[][] a = new double[X][Y];
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                a[i][j] = r.nextInt();
            }
        }
        Matrix2DDouble matrixA = new Matrix2DDouble(a);
        Matrix2DDouble matrixB = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("sebaby").transferToDevice(0, new Object[]{matrixA}).task("tqegs", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)X, (Object)Y).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)(matrixA.get(i, j) + matrixA.get(i, j)), (double)matrixB.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testMatrixRowInt01() {
        int[][] array = new int[3][2];
        array[0][0] = 1;
        array[0][1] = 2;
        array[1][0] = 3;
        array[1][1] = 4;
        array[2][0] = 5;
        array[2][1] = 6;
        Matrix2DInt matrix = new Matrix2DInt(array);
        VectorInt row0 = matrix.row(0);
        VectorInt row1 = matrix.row(1);
        VectorInt row2 = matrix.row(2);
        Assert.assertEquals((float)1.0f, (float)row0.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)row0.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)3.0f, (float)row1.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)4.0f, (float)row1.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)5.0f, (float)row2.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)6.0f, (float)row2.getArray().get(1), (float)0.01f);
    }

    @Test
    public void testMatrixRowInt02() {
        int[][] array = new int[2][3];
        array[0][0] = 1;
        array[0][1] = 2;
        array[0][2] = 3;
        array[1][0] = 4;
        array[1][1] = 5;
        array[1][2] = 6;
        Matrix2DInt matrix = new Matrix2DInt(array);
        VectorInt row0 = matrix.row(0);
        VectorInt row1 = matrix.row(1);
        Assert.assertEquals((float)1.0f, (float)row0.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)row0.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)3.0f, (float)row0.getArray().get(2), (float)0.01f);
        Assert.assertEquals((float)4.0f, (float)row1.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)5.0f, (float)row1.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)6.0f, (float)row1.getArray().get(2), (float)0.01f);
    }

    @Test
    public void testMatrixRowFloat01() {
        float[][] array = new float[3][2];
        array[0][0] = 1.0f;
        array[0][1] = 2.0f;
        array[1][0] = 3.0f;
        array[1][1] = 4.0f;
        array[2][0] = 5.0f;
        array[2][1] = 6.0f;
        Matrix2DFloat matrix = new Matrix2DFloat(array);
        VectorFloat row0 = matrix.row(0);
        VectorFloat row1 = matrix.row(1);
        VectorFloat row2 = matrix.row(2);
        Assert.assertEquals((float)1.0f, (float)row0.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)row0.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)3.0f, (float)row1.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)4.0f, (float)row1.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)5.0f, (float)row2.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)6.0f, (float)row2.getArray().get(1), (float)0.01f);
    }

    @Test
    public void testMatrixRowFloat02() {
        float[][] array = new float[2][3];
        array[0][0] = 1.0f;
        array[0][1] = 2.0f;
        array[0][2] = 3.0f;
        array[1][0] = 4.0f;
        array[1][1] = 5.0f;
        array[1][2] = 6.0f;
        Matrix2DFloat matrix = new Matrix2DFloat(array);
        VectorFloat row0 = matrix.row(0);
        VectorFloat row1 = matrix.row(1);
        Assert.assertEquals((float)1.0f, (float)row0.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)row0.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)3.0f, (float)row0.getArray().get(2), (float)0.01f);
        Assert.assertEquals((float)4.0f, (float)row1.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)5.0f, (float)row1.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)6.0f, (float)row1.getArray().get(2), (float)0.01f);
    }

    @Test
    public void testMatrixRowFloat4() {
        FloatArray array = new FloatArray(6);
        array.set(0, 1.0f);
        array.set(1, 2.0f);
        array.set(2, 3.0f);
        array.set(3, 4.0f);
        array.set(4, 5.0f);
        array.set(5, 6.0f);
        Matrix2DFloat4 matrix = new Matrix2DFloat4(2, 3, array);
        VectorFloat row0 = matrix.row(0);
        VectorFloat row1 = matrix.row(1);
        Assert.assertEquals((float)1.0f, (float)row0.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)row0.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)3.0f, (float)row0.getArray().get(2), (float)0.01f);
        Assert.assertEquals((float)4.0f, (float)row1.getArray().get(0), (float)0.01f);
        Assert.assertEquals((float)5.0f, (float)row1.getArray().get(1), (float)0.01f);
        Assert.assertEquals((float)6.0f, (float)row1.getArray().get(2), (float)0.01f);
    }

    @Test
    public void testMatrixRowDouble01() {
        double[][] array = new double[3][2];
        array[0][0] = 1.0;
        array[0][1] = 2.0;
        array[1][0] = 3.0;
        array[1][1] = 4.0;
        array[2][0] = 5.0;
        array[2][1] = 6.0;
        Matrix2DDouble matrix = new Matrix2DDouble(array);
        VectorDouble row0 = matrix.row(0);
        VectorDouble row1 = matrix.row(1);
        VectorDouble row2 = matrix.row(2);
        Assert.assertEquals((double)1.0, (double)row0.getArray().get(0), (double)0.01f);
        Assert.assertEquals((double)2.0, (double)row0.getArray().get(1), (double)0.01f);
        Assert.assertEquals((double)3.0, (double)row1.getArray().get(0), (double)0.01f);
        Assert.assertEquals((double)4.0, (double)row1.getArray().get(1), (double)0.01f);
        Assert.assertEquals((double)5.0, (double)row2.getArray().get(0), (double)0.01f);
        Assert.assertEquals((double)6.0, (double)row2.getArray().get(1), (double)0.01f);
    }

    @Test
    public void testMatrixRowDouble02() {
        double[][] array = new double[2][3];
        array[0][0] = 1.0;
        array[0][1] = 2.0;
        array[0][2] = 3.0;
        array[1][0] = 4.0;
        array[1][1] = 5.0;
        array[1][2] = 6.0;
        Matrix2DDouble matrix = new Matrix2DDouble(array);
        VectorDouble row0 = matrix.row(0);
        VectorDouble row1 = matrix.row(1);
        Assert.assertEquals((double)1.0, (double)row0.getArray().get(0), (double)0.01f);
        Assert.assertEquals((double)2.0, (double)row0.getArray().get(1), (double)0.01f);
        Assert.assertEquals((double)3.0, (double)row0.getArray().get(2), (double)0.01f);
        Assert.assertEquals((double)4.0, (double)row1.getArray().get(0), (double)0.01f);
        Assert.assertEquals((double)5.0, (double)row1.getArray().get(1), (double)0.01f);
        Assert.assertEquals((double)6.0, (double)row1.getArray().get(2), (double)0.01f);
    }

    @Test
    public void testMatrix00() {
        Matrix2DInt matrix = new Matrix2DInt(2, 3);
        matrix.set(0, 0, 1);
        matrix.set(0, 1, 2);
        matrix.set(0, 2, 3);
        matrix.set(1, 0, 4);
        matrix.set(1, 1, 5);
        matrix.set(1, 2, 6);
        Assert.assertEquals((long)1L, (long)matrix.get(0, 0));
        Assert.assertEquals((long)2L, (long)matrix.get(0, 1));
        Assert.assertEquals((long)3L, (long)matrix.get(0, 2));
        Assert.assertEquals((long)4L, (long)matrix.get(1, 0));
        Assert.assertEquals((long)5L, (long)matrix.get(1, 1));
        Assert.assertEquals((long)6L, (long)matrix.get(1, 2));
    }

    @Test
    public void testMatrix01() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixIntegers(640, 480);
    }

    @Test
    public void testMatrix02() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixIntegers(480, 640);
    }

    @Test
    public void testMatrix03() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixIntegers(640, 640);
    }

    @Test
    public void testMatrix04() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixDoubles(640, 480);
    }

    @Test
    public void testMatrix05() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixDoubles(480, 640);
    }

    @Test
    public void testMatrix06() throws TornadoExecutionPlanException {
        TestMatrixTypes.testMatrixDoubles(640, 640);
    }

    @Test
    public void testMatrix07() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix2DFloat matrixA = new Matrix2DFloat(256, 256);
        Matrix2DFloat matrixB = new Matrix2DFloat(256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                matrixA.set(i, j, r.nextFloat());
            }
        }
        TaskGraph taskGraph = new TaskGraph("mgka").transferToDevice(0, new Object[]{matrixA}).task("t24", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((float)(matrixA.get(i, j) + matrixA.get(i, j)), (float)matrixB.get(i, j), (float)0.01f);
            }
        }
    }

    @Test
    public void testMatrix08() throws TornadoExecutionPlanException {
        int N = 256;
        float[][] a = new float[256][256];
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                a[i][j] = r.nextFloat();
            }
        }
        Matrix2DFloat matrixA = new Matrix2DFloat(a);
        Matrix2DFloat matrixB = new Matrix2DFloat(256, 256);
        TaskGraph taskGraph = new TaskGraph("srkyr").transferToDevice(0, new Object[]{matrixA}).task("tfd", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((float)(matrixA.get(i, j) + matrixA.get(i, j)), (float)matrixB.get(i, j), (float)0.01f);
            }
        }
    }

    @Test
    public void testMatrix09() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix2DFloat matrixA = new Matrix2DFloat(256, 256);
        Matrix2DFloat matrixB = new Matrix2DFloat(256, 256);
        Matrix2DFloat matrixC = new Matrix2DFloat(256, 256);
        Matrix2DFloat sequential = new Matrix2DFloat(256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                matrixA.set(i, j, r.nextFloat());
                matrixB.set(i, j, r.nextFloat());
            }
        }
        TaskGraph taskGraph = new TaskGraph("smmmmmm").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixMultiplication, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrixTypes.computeMatrixMultiplication(matrixA, matrixB, sequential);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((float)sequential.get(i, j), (float)matrixC.get(i, j), (float)0.01f);
            }
        }
    }

    @Test
    public void testMatrix10() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix3DFloat matrixA = new Matrix3DFloat(256, 256, 256);
        Matrix3DFloat matrixB = new Matrix3DFloat(256, 256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    matrixA.set(i, j, k, r.nextFloat());
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("nnnnnnn").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Assert.assertEquals((float)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (float)matrixB.get(i, j, k), (float)0.01f);
                }
            }
        }
    }

    @Test
    public void testMatrix11() throws TornadoExecutionPlanException {
        int X = 512;
        TestMatrixTypes.testMatrix2DVectorType(512, 512);
    }

    @Test
    public void testMatrix12() throws TornadoExecutionPlanException {
        int X = 512;
        int Y = 128;
        TestMatrixTypes.testMatrix2DVectorType(512, 128);
    }

    @Test
    public void testMatrix13() throws TornadoExecutionPlanException {
        int X = 512;
        int Y = 128;
        TestMatrixTypes.testMatrix2DVectorType(128, 512);
    }

    @Test
    public void testMatrix14() throws TornadoExecutionPlanException {
        int X = 128;
        TestMatrixTypes.testMatrix3DVectorType(128, 128, 128);
    }

    @Test
    public void testMatrix15() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 64;
        int Z = 2;
        TestMatrixTypes.testMatrix3DVectorType(128, 64, 2);
    }

    @Test
    public void testMatrix16() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 64;
        int Z = 2;
        TestMatrixTypes.testMatrix3DVectorType(64, 128, 2);
    }

    @Test
    public void testMatrix17() throws TornadoExecutionPlanException {
        int SMALL_SIZE = 128;
        Matrix3DFloat4 matrixA = new Matrix3DFloat4(128, 128, 128);
        Matrix3DFloat4 matrixB = new Matrix3DFloat4(128, 128, 128);
        Random r = new Random();
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 128; ++k) {
                    Float4 vector = new Float4();
                    for (int v = 0; v < vector.size(); ++v) {
                        vector.set(v, r.nextFloat());
                    }
                    matrixA.set(i, j, k, vector);
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s9").transferToDevice(0, new Object[]{matrixA}).task("t9", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)128, (Object)128, (Object)128).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 128; ++k) {
                    Float4 expected = Float4.add((Float4)matrixA.get(i, j, k), (Float4)matrixA.get(i, j, k));
                    Assert.assertTrue((boolean)Float4.isEqual((Float4)expected, (Float4)matrixB.get(i, j, k)));
                }
            }
        }
    }

    @Test
    public void testMatrix18() throws TornadoExecutionPlanException {
        int X = 480;
        int Y = 854;
        int Z = 3;
        float[][][] a = new float[480][854][3];
        Random r = new Random();
        for (int i = 0; i < 480; ++i) {
            for (int j = 0; j < 854; ++j) {
                for (int k = 0; k < 3; ++k) {
                    a[i][j][k] = r.nextFloat();
                }
            }
        }
        Matrix3DFloat matrixA = new Matrix3DFloat(a);
        Matrix3DFloat matrixB = new Matrix3DFloat(480, 854, 3);
        TaskGraph taskGraph = new TaskGraph("iiiii").transferToDevice(0, new Object[]{matrixA}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)480, (Object)854, (Object)3).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 480; ++i) {
            for (int j = 0; j < 854; ++j) {
                for (int k = 0; k < 3; ++k) {
                    Assert.assertEquals((float)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (float)matrixB.get(i, j, k), (float)0.01f);
                }
            }
        }
    }

    @Test
    public void testMatrix19() throws TornadoExecutionPlanException {
        int X = 854;
        int Y = 480;
        TestMatrixTypes.testMatricesFloats(854, 480);
    }

    @Test
    public void testMatrix20() throws TornadoExecutionPlanException {
        int X = 854;
        int Y = 480;
        TestMatrixTypes.testMatricesFloats(480, 854);
    }

    @Test
    public void testMatrix21() throws TornadoExecutionPlanException {
        int X = 854;
        TestMatrixTypes.testMatricesFloats(854, 854);
    }

    @Test
    public void testMatrix22() throws TornadoExecutionPlanException {
        int Y = 2160;
        int X = 3840;
        float[][] a = new float[3840][2160];
        Random r = new Random();
        for (int i = 0; i < 3840; ++i) {
            for (int j = 0; j < 2160; ++j) {
                a[i][j] = r.nextFloat();
            }
        }
        Matrix2DFloat matrixA = new Matrix2DFloat(a);
        Matrix2DFloat matrixB = new Matrix2DFloat(3840, 2160);
        TaskGraph taskGraph = new TaskGraph("aaa").transferToDevice(0, new Object[]{matrixA}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)3840, (Object)2160).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 3840; ++i) {
            for (int j = 0; j < 2160; ++j) {
                Assert.assertEquals((float)(matrixA.get(i, j) + matrixA.get(i, j)), (float)matrixB.get(i, j), (float)0.01f);
            }
        }
    }

    @Test
    public void testMatrix23() throws TornadoExecutionPlanException {
        int X = 2160;
        int Y = 3840;
        float[][] a = new float[2160][3840];
        Random r = new Random();
        for (int i = 0; i < 2160; ++i) {
            for (int j = 0; j < 3840; ++j) {
                a[i][j] = r.nextFloat();
            }
        }
        Matrix2DFloat matrixA = new Matrix2DFloat(a);
        Matrix2DFloat matrixB = new Matrix2DFloat(2160, 3840);
        TaskGraph taskGraph = new TaskGraph("s5324").transferToDevice(0, new Object[]{matrixA}).task("toyeg", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)2160, (Object)3840).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 2160; ++i) {
            for (int j = 0; j < 3840; ++j) {
                Assert.assertEquals((float)(matrixA.get(i, j) + matrixA.get(i, j)), (float)matrixB.get(i, j), (float)0.01f);
            }
        }
    }

    @Test
    public void testMatrix24() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix3DInt matrixA = new Matrix3DInt(256, 256, 256);
        Matrix3DInt matrixB = new Matrix3DInt(256, 256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    matrixA.set(i, j, k, r.nextInt());
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Assert.assertEquals((long)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (long)matrixB.get(i, j, k));
                }
            }
        }
    }

    @Test
    public void testMatrix25() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix3DDouble matrixA = new Matrix3DDouble(256, 256, 256);
        Matrix3DDouble matrixB = new Matrix3DDouble(256, 256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    matrixA.set(i, j, k, r.nextDouble());
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Assert.assertEquals((double)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (double)matrixB.get(i, j, k), (double)0.01);
                }
            }
        }
    }

    @Test
    public void testMatrix26() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix3DLong matrixA = new Matrix3DLong(256, 256, 256);
        Matrix3DLong matrixB = new Matrix3DLong(256, 256, 256);
        Random r = new Random();
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    matrixA.set(i, j, k, r.nextLong());
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Assert.assertEquals((long)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (long)matrixB.get(i, j, k));
                }
            }
        }
    }

    @Test
    public void testMatrix27() throws TornadoExecutionPlanException {
        int N = 256;
        Matrix3DShort matrixA = new Matrix3DShort(256, 256, 256);
        Matrix3DShort matrixB = new Matrix3DShort(256, 256, 256);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    matrixA.set(i, j, k, (short)i);
                }
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrixTypes::computeMatrixSum, (Object)matrixA, (Object)matrixB, (Object)256).transferToHost(1, new Object[]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Assert.assertEquals((long)(matrixA.get(i, j, k) + matrixA.get(i, j, k)), (long)matrixB.get(i, j, k));
                }
            }
        }
    }
}

