/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.matrices;

import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

@Ignore
public class TestMatrices
extends TornadoTestBase {
    public static void fillMatrix(int[][] values) {
        for (int i = 0; i < values.length; ++i) {
            Arrays.fill(values[i], i);
        }
    }

    public static void fillMatrix2(int[][] values) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                values[i][j] = i;
            }
        }
    }

    public static void fillMatrix3(int[][] values) {
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                values[i][j] = i;
            }
        }
    }

    public static void matrixVector(float[] matrix, float[] vector, float[] result, int size) {
        for (int i = 0; i < size; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < size; ++j) {
                sum += matrix[i * size + j] * vector[j];
            }
            result[i] = sum;
        }
    }

    public static void matrixInit1D(float[] result, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                result[i * size + j] = 100 + i;
            }
        }
    }

    public static void matrixInit2D(float[] result, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                result[i * size + j] = 120.0f;
            }
        }
    }

    public static void matrixAddition1D(float[] matrixA, float[] matrixB, float[] result, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int position = i * size + j;
                result[position] = matrixA[position] + matrixB[position];
            }
        }
    }

    public static void matrixAddition2D(float[] matrixA, float[] matrixB, float[] result, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                result[i * size + j] = matrixA[i * size + j] + matrixB[i * size + j];
            }
        }
    }

    public static void matrixMultiplication(float[] A2, float[] B2, float[] C, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < size; ++k) {
                    sum += A2[i * size + k] * B2[k * size + j];
                }
                C[i * size + j] = sum;
            }
        }
    }

    public static void matrixMultiplicationParallelInduction(float[] A2, float[] B2, float[] C, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < size; ++k) {
                    sum += A2[i * size + k] * B2[k * size + j];
                }
                C[i * size + j] = sum;
            }
        }
    }

    public static void matrixUsageOfParallelInduction(float[] A2, float[] B2, float[] C, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < i; ++k) {
                    sum += A2[i * size + k] * B2[k * size + j];
                }
                C[i * size + j] = sum;
            }
        }
    }

    public static void copyMatrix2D(float[][] matrixA, float[][] matrixB) {
        for (int i = 0; i < matrixA.length; ++i) {
            for (int j = 0; j < matrixA[i].length; ++j) {
                matrixB[i][j] = matrixA[i][j];
            }
        }
    }

    public static void testAdd(long[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = matrix[i][j] + (long)i;
            }
        }
    }

    public static void testAddMultiple(float[][] first, float[][] second) {
        for (int i = 0; i < first.length; ++i) {
            for (int j = 0; j < first.length; ++j) {
                first[i][j] = first[i][j] + second[i][j];
            }
        }
    }

    @Ignore
    @Test
    public void testFillMatrix() throws TornadoExecutionPlanException {
        int numElements = 16;
        int[][] a = new int[16][16];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::fillMatrix, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                Assert.assertEquals((long)i, (long)a[i][j]);
            }
        }
    }

    @Test
    public void testFillMatrix2() throws TornadoExecutionPlanException {
        int numElements = 4;
        int[][] a = new int[4][4];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::fillMatrix2, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                Assert.assertEquals((long)i, (long)a[i][j]);
            }
        }
    }

    @Test
    public void testFillMatrix3() throws TornadoExecutionPlanException {
        int numElements = 16;
        int[][] a = new int[16][16];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::fillMatrix3, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                Assert.assertEquals((long)i, (long)a[i][j]);
            }
        }
    }

    @Test
    public void testMatrixVectorSmall() throws TornadoExecutionPlanException {
        int N = 4;
        float[] matrix = new float[16];
        float[] vector = new float[4];
        float[] result = new float[4];
        float[] resultSeq = new float[4];
        Random r = new Random();
        IntStream.range(0, 4).parallel().forEach(idx -> {
            vector[idx] = r.nextFloat();
        });
        IntStream.range(0, 16).parallel().forEach(idx -> {
            matrix[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrix, vector}).task("t0", TestMatrices::matrixVector, (Object)matrix, (Object)vector, (Object)result, (Object)4).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixVector(matrix, vector, resultSeq, 4);
        for (int i = 0; i < vector.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixVector() throws TornadoExecutionPlanException {
        int N = 256;
        float[] matrix = new float[65536];
        float[] vector = new float[256];
        float[] result = new float[256];
        float[] resultSeq = new float[256];
        Random r = new Random();
        IntStream.range(0, 256).parallel().forEach(idx -> {
            vector[idx] = r.nextFloat();
        });
        IntStream.range(0, 65536).parallel().forEach(idx -> {
            matrix[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrix, vector}).task("t0", TestMatrices::matrixVector, (Object)matrix, (Object)vector, (Object)result, (Object)256).transferToHost(1, new Object[]{result});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.execute();
        }
        TestMatrices.matrixVector(matrix, vector, resultSeq, 256);
        for (int i = 0; i < vector.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixInit1DSmall() throws TornadoExecutionPlanException {
        int N = 4;
        float[] matrix = new float[16];
        float[] resultSeq = new float[16];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::matrixInit1D, (Object)matrix, (Object)4).transferToHost(1, new Object[]{matrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixInit1D(resultSeq, 4);
        for (int i = 0; i < matrix.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)matrix[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixInit1D() throws TornadoExecutionPlanException {
        int N = 256;
        float[] matrix = new float[65536];
        float[] resultSeq = new float[65536];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::matrixInit1D, (Object)matrix, (Object)256).transferToHost(1, new Object[]{matrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixInit1D(resultSeq, 256);
        for (int i = 0; i < matrix.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)matrix[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixInit2DSmall() throws TornadoExecutionPlanException {
        int N = 4;
        float[] matrix = new float[16];
        float[] resultSeq = new float[16];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::matrixInit2D, (Object)matrix, (Object)4).transferToHost(1, new Object[]{matrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixInit2D(resultSeq, 4);
        for (int i = 0; i < matrix.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)matrix[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixInit2D() throws TornadoExecutionPlanException {
        int N = 1024;
        float[] matrix = new float[0x100000];
        float[] resultSeq = new float[0x100000];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestMatrices::matrixInit2D, (Object)matrix, (Object)1024).transferToHost(1, new Object[]{matrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixInit2D(resultSeq, 1024);
        for (int i = 0; i < matrix.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)matrix[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixAddition1DSmall() throws TornadoExecutionPlanException {
        int N = 4;
        float[] matrixA = new float[16];
        float[] matrixB = new float[16];
        float[] result = new float[16];
        float[] resultSeq = new float[16];
        Random r = new Random();
        IntStream.range(0, 16).parallel().forEach(idx -> {
            matrixB[idx] = r.nextFloat();
        });
        IntStream.range(0, 16).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixAddition1D, (Object)matrixA, (Object)matrixB, (Object)result, (Object)4).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixAddition1D(matrixA, matrixB, resultSeq, 4);
        for (int i = 0; i < matrixB.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixAddition1D() throws TornadoExecutionPlanException {
        int N = 1024;
        float[] matrixA = new float[0x100000];
        float[] matrixB = new float[0x100000];
        float[] result = new float[0x100000];
        float[] resultSeq = new float[0x100000];
        Random r = new Random();
        IntStream.range(0, 0x100000).parallel().forEach(idx -> {
            matrixB[idx] = r.nextFloat();
        });
        IntStream.range(0, 0x100000).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixAddition1D, (Object)matrixA, (Object)matrixB, (Object)result, (Object)1024).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixAddition1D(matrixA, matrixB, resultSeq, 1024);
        for (int i = 0; i < matrixB.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixAddition2DSmall() throws TornadoExecutionPlanException {
        int N = 4;
        float[] matrixA = new float[16];
        float[] matrixB = new float[16];
        float[] result = new float[16];
        float[] resultSeq = new float[16];
        Random r = new Random();
        IntStream.range(0, 4).parallel().forEach(idx -> {
            matrixB[idx] = r.nextFloat();
        });
        IntStream.range(0, 16).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixAddition2D, (Object)matrixA, (Object)matrixB, (Object)result, (Object)4).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixAddition2D(matrixA, matrixB, resultSeq, 4);
        for (int i = 0; i < matrixB.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testMatrixAddition2D() throws TornadoExecutionPlanException {
        int N = 1024;
        float[] matrixA = new float[0x100000];
        float[] matrixB = new float[0x100000];
        float[] result = new float[0x100000];
        float[] resultSeq = new float[0x100000];
        Random r = new Random();
        IntStream.range(0, 1024).parallel().forEach(idx -> {
            matrixB[idx] = r.nextFloat();
        });
        IntStream.range(0, 0x100000).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixAddition2D, (Object)matrixA, (Object)matrixB, (Object)result, (Object)1024).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixAddition2D(matrixA, matrixB, resultSeq, 1024);
        for (int i = 0; i < matrixB.length; ++i) {
            Assert.assertEquals((float)resultSeq[i], (float)result[i], (float)0.01f);
        }
    }

    @Test
    public void testCopyMatrix2D() throws TornadoExecutionPlanException {
        int N = 32;
        float[][] matrixA = new float[32][32];
        float[][] matrixB = new float[32][32];
        Random random = new Random();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                matrixA[i][j] = random.nextFloat();
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestMatrices::copyMatrix2D, (Object)matrixA, (Object)matrixB).transferToHost(1, (Object[])new float[][][]{matrixB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                Assert.assertEquals((double)matrixA[i][j], (double)matrixB[i][j], (double)0.01);
            }
        }
    }

    @Test
    public void testMatrixMultiplicationSmall() throws TornadoExecutionPlanException {
        int j;
        int i;
        int N = 32;
        float[] matrixA = new float[1024];
        float[] matrixB = new float[1024];
        float[] matrixC = new float[1024];
        float[] resultSeq = new float[1024];
        Random r = new Random();
        IntStream.range(0, 1024).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
            matrixB[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixMultiplication, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)32).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 32; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < 32; ++k) {
                    sum += matrixA[i * 32 + k] * matrixB[k * 32 + j];
                }
                resultSeq[i * 32 + j] = sum;
            }
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 32; ++j) {
                Assert.assertEquals((double)resultSeq[i * 32 + j], (double)matrixC[i * 32 + j], (double)0.1);
            }
        }
    }

    @Test
    public void testMatrixMultiplication() throws TornadoExecutionPlanException {
        int j;
        int i;
        int N = 256;
        float[] matrixA = new float[65536];
        float[] matrixB = new float[65536];
        float[] matrixC = new float[65536];
        float[] resultSeq = new float[65536];
        Random r = new Random();
        IntStream.range(0, 65536).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
            matrixB[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixMultiplication, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)256).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (i = 0; i < 256; ++i) {
            for (j = 0; j < 256; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < 256; ++k) {
                    sum += matrixA[i * 256 + k] * matrixB[k * 256 + j];
                }
                resultSeq[i * 256 + j] = sum;
            }
        }
        for (i = 0; i < 256; ++i) {
            for (j = 0; j < 256; ++j) {
                Assert.assertEquals((double)resultSeq[i * 256 + j], (double)matrixC[i * 256 + j], (double)0.1);
            }
        }
    }

    @Test
    public void testParallelInductionVariablesAsBounds() throws TornadoExecutionPlanException {
        int N = 256;
        float[] matrixA = new float[65536];
        float[] matrixB = new float[65536];
        float[] matrixC = new float[65536];
        float[] resultSeq = new float[65536];
        Random r = new Random();
        IntStream.range(0, 65536).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
            matrixB[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixMultiplicationParallelInduction, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)256).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixMultiplicationParallelInduction(matrixA, matrixB, resultSeq, 256);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((float)resultSeq[i * 256 + j], (float)matrixC[i * 256 + j], (float)0.1f);
            }
        }
    }

    @Test
    public void testMultipleParallelInductionVariableLoopUsage() throws TornadoExecutionPlanException {
        int N = 256;
        float[] matrixA = new float[65536];
        float[] matrixB = new float[65536];
        float[] matrixC = new float[65536];
        float[] resultSeq = new float[65536];
        Random r = new Random();
        IntStream.range(0, 65536).parallel().forEach(idx -> {
            matrixA[idx] = r.nextFloat();
            matrixB[idx] = r.nextFloat();
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", TestMatrices::matrixUsageOfParallelInduction, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)256).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMatrices.matrixUsageOfParallelInduction(matrixA, matrixB, resultSeq, 256);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((float)resultSeq[i * 256 + j], (float)matrixC[i * 256 + j], (float)0.1f);
            }
        }
    }

    @Test
    public void testAddMatrix() throws TornadoExecutionPlanException {
        int N = 128;
        Random random = new Random();
        int[] secondDimSizes = new int[]{10, 400, 7, 29, 44, 1001};
        long[][] matrix = new long[N][];
        long[][] matrixSeq = new long[N][];
        int counter = 0;
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = new long[secondDimSizes[counter % secondDimSizes.length]];
            matrixSeq[i] = new long[secondDimSizes[counter % secondDimSizes.length]];
            ++counter;
            for (int j = 0; j < matrix[i].length; ++j) {
                int someNumber = random.nextInt();
                matrix[i][j] = someNumber;
                matrixSeq[i][j] = someNumber;
            }
        }
        TestMatrices.testAdd(matrixSeq);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, (Object[])matrix).task("t0", TestMatrices::testAdd, (Object)matrix).transferToHost(1, (Object[])new long[][][]{matrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < matrix.length; ++i) {
            Assert.assertArrayEquals((long[])matrixSeq[i], (long[])matrix[i]);
        }
    }

    @Test
    public void testAddMatrixMultiple() throws TornadoExecutionPlanException {
        int N = 128;
        Random random = new Random();
        float[][] firstMatrix = new float[N][];
        float[][] secondMatrix = new float[N][];
        float[][] firstMatrixSeq = new float[N][];
        float[][] secondMatrixSeq = new float[N][];
        for (int i = 0; i < firstMatrix.length; ++i) {
            firstMatrix[i] = new float[N];
            secondMatrix[i] = new float[N];
            firstMatrixSeq[i] = new float[N];
            secondMatrixSeq[i] = new float[N];
            for (int j = 0; j < firstMatrix[i].length; ++j) {
                float someNumber;
                firstMatrix[i][j] = someNumber = random.nextFloat() * 10.0f;
                firstMatrixSeq[i][j] = someNumber;
                secondMatrix[i][j] = someNumber = random.nextFloat() * 100.0f;
                secondMatrixSeq[i][j] = someNumber;
            }
        }
        TestMatrices.testAddMultiple(firstMatrixSeq, secondMatrixSeq);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{firstMatrixSeq, secondMatrixSeq}).task("t0", TestMatrices::testAddMultiple, (Object)firstMatrix, (Object)secondMatrix).transferToHost(1, (Object[])new float[][][]{firstMatrix});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < firstMatrix.length; ++i) {
            Assert.assertArrayEquals((float[])firstMatrixSeq[i], (float[])firstMatrix[i], (float)0.01f);
        }
    }
}

