/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.math;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestTornadoMathCollection
extends TornadoTestBase {
    public static void testTornadoCos(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.cos((float)a.get(i)));
        }
    }

    public static void testTornadoAcosh(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.acosh((float)a.get(i)));
        }
    }

    public static void testTornadoSignum(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.signum((float)a.get(i)));
        }
    }

    public static void testTornadoCosPI(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.cospi((float)a.get(i)));
        }
    }

    public static void testTornadoCosPIDouble(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.cospi((double)a.get(i)));
        }
    }

    public static void testTornadoSinPI(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.sinpi((float)a.get(i)));
        }
    }

    public static void testTornadoSinPIDouble(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.sinpi((double)a.get(i)));
        }
    }

    public static void testTornadoSignum(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.signum((double)a.get(i)));
        }
    }

    public static void testTornadoSin(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.sin((float)a.get(i)));
        }
    }

    public static void testTornadoAcos(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.acos((float)a.get(i)));
        }
    }

    public static void testTornadoAsin(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.asin((float)a.get(i)));
        }
    }

    public static void testTornadoAsinh(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.asinh((float)a.get(i)));
        }
    }

    public static void testTornadoMin(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.min((float)a.get(i), (float)1.0f));
        }
    }

    public static void testTornadoMax(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.max((float)a.get(i), (float)10.0f));
        }
    }

    public static void testTornadoSqrt(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.sqrt((double)a.get(i)));
        }
    }

    public static void testTornadoAtan(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.atan((float)a.get(i)));
        }
    }

    public static void testTornadoAtan(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.atan((double)a.get(i)));
        }
    }

    public static void testTornadoAtan2(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.atan2((float)a.get(i), (float)b.get(i)));
        }
    }

    public static void testTornadoAtan2(DoubleArray a, DoubleArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.atan2((double)a.get(i), (double)b.get(i)));
        }
    }

    public static void testTornadoTan(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.tan((float)a.get(i)));
        }
    }

    public static void testTornadoTan(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.tan((double)a.get(i)));
        }
    }

    public static void testTornadoTanh(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.tanh((float)a.get(i)));
        }
    }

    public static void testTornadoTanh(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.tanh((double)a.get(i)));
        }
    }

    public static void testTornadoExp(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.exp((double)a.get(i)));
        }
    }

    public static void testTornadoExp(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.exp((float)a.get(i)));
        }
    }

    public static void testTornadoClamp(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.clamp((double)a.get(i), (double)10.0, (double)20.0));
        }
    }

    public static void testTornadoFract(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.fract((double)a.get(i)));
        }
    }

    public static void testTornadoLog(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.log((double)a.get(i)));
        }
    }

    public static void testTornadoLog(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.log((float)a.get(i)));
        }
    }

    public static void testTornadoLog2(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.log2((double)a.get(i)));
        }
    }

    public static void testTornadoPI(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.PI());
        }
    }

    public static void testFloor(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.floor((double)a.get(i)));
        }
    }

    public static void testClamp(LongArray a, LongArray b) {
        long min = 1L;
        long max = 10000L;
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, TornadoMath.clamp((long)a.get(i), (long)min, (long)max));
        }
    }

    public static void testTornadoRadians(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.toRadians((float)a.get(i)));
        }
    }

    public static void testTornadoRadians(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.toRadians((double)a.get(i)));
        }
    }

    @Test
    public void testTornadoMathCos() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoCos, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoCos(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathAcosh() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoAcosh, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAcosh(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathCosPI() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoCosPI, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoCosPI(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathCosPIDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoCosPIDouble, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.OPENCL, "-cl-opt-disable");
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoCosPIDouble(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathSinPI() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSinPI, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSinPI(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathSinPIDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSinPIDouble, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.OPENCL, "-cl-opt-disable");
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSinPIDouble(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathSignumFloat() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSignum, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSignum(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathSignumFloatNaN() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Float.NaN);
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSignum, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSignum(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathSignumDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSignum, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSignum(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathSignumDoubleNaN() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Double.NaN);
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSignum, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSignum(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathSin() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSin, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSin(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathAtan() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoAtan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAtan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathAtanDouble() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoAtan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.OPENCL, "-cl-opt-disable");
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAtan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathTan() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoTan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoTan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathTanDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoTan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoTan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathTanh() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoTanh, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoTanh(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathTanhDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoTanh, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoTanh(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathMin() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoMin, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoMin(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathMax() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoMax, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoMax(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathSqrt() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoSqrt, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoSqrt(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathExpDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoExp, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoExp(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathExpFloat() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoExp, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoExp(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathClamp() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoClamp, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoClamp(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathFract() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoFract, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoFract(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathLog2() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoLog2, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoLog2(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testTornadoMathLogDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoLog, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoLog(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testTornadoMathLogFloat() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoLog, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoLog(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathPI() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoPI, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoPI(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testMathFloor() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testFloor, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testFloor(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testMathClamp() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 8192;
        LongArray a = new LongArray(8192);
        LongArray b = new LongArray(8192);
        LongArray seq = new LongArray(8192);
        IntStream.range(0, 8192).parallel().forEach(i -> {
            a.set(i, r.nextLong());
            b.set(i, r.nextLong());
            seq.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestTornadoMathCollection::testClamp, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testClamp(a, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((long)b.get(i2), (long)seq.get(i2));
        }
    }

    @Test
    public void testTornadoMathRadians() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoRadians, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoRadians(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testTornadoMathRadiansDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestTornadoMathCollection::testTornadoRadians, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoRadians(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathATan2() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray b = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        FloatArray seqB = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
            seqA.set(i, a.get(i));
            seqB.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestTornadoMathCollection::testTornadoAtan2, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAtan2(seqA, seqB);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)a.get(i2), (float)seqA.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathATan2Double() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray b = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        DoubleArray seqB = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, Math.random());
            b.set(i, Math.random());
            seqA.set(i, a.get(i));
            seqB.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestTornadoMathCollection::testTornadoAtan2, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAtan2(seqA, seqB);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathAcos() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, (float)Math.random());
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestTornadoMathCollection::testTornadoAcos, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAcos(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)a.get(i2), (float)seqA.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathASin() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, (float)Math.random());
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestTornadoMathCollection::testTornadoAsin, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAsin(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)a.get(i2), (float)seqA.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathASinh() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, (float)Math.random());
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestTornadoMathCollection::testTornadoAsinh, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestTornadoMathCollection.testTornadoAsinh(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)a.get(i2), (float)seqA.get(i2), (float)0.01f);
        }
    }
}

