/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.math;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMath
extends TornadoTestBase {
    public static void testCos(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.cos(a.get(i)));
        }
    }

    public static void testAtan(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.atan(a.get(i)));
        }
    }

    public static void testTan(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.tan(a.get(i)));
        }
    }

    public static void testAtan2(DoubleArray a, DoubleArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.atan2(a.get(i), b.get(i)));
        }
    }

    public static void testTanh(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.tanh(a.get(i)));
        }
    }

    public static void testLog(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.log(a.get(i)));
        }
    }

    public static void testSqrt(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.sqrt(a.get(i)));
        }
    }

    public static void testExp(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.exp(a.get(i)));
        }
    }

    public static void testExpDouble(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.exp(a.get(i)));
        }
    }

    public static void testExpLong(LongArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (long)Math.exp(a.get(i)));
        }
    }

    public static void testExpFloat(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (float)Math.exp(a.get(i)));
        }
    }

    public static void testPow(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (float)Math.pow(2.0, a.get(i)));
        }
    }

    public static void testPowDouble(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.pow(a.get(i), 2.0));
        }
    }

    public static void testAcos(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.acos(a.get(i)));
        }
    }

    public static void testAsin(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.asin(a.get(i)));
        }
    }

    public static void testAbs(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.abs(a.get(i)));
        }
    }

    public static void testMin(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            c.set(i, Math.min(a.get(i), b.get(i)));
        }
    }

    public static void testMax(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            c.set(i, Math.max(a.get(i), b.get(i)));
        }
    }

    public static void testNegate(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, -a.get(i));
        }
    }

    public static void testRemainder(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, b.get(i) % a.get(i));
        }
    }

    public static void testFMA(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i) + b.get(i) * a.get(i));
        }
    }

    public static void testFMA2(FloatArray a, DoubleArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, (double)a.get(i) + b.get(i) * (double)a.get(i));
        }
    }

    private static void testSignumFloat(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.signum(a.get(i)));
        }
    }

    private static void testSignumDouble(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, Math.signum(a.get(i)));
        }
    }

    public static void testCeil(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, TornadoMath.ceil((float)a.get(i)));
        }
    }

    public static void testInverseSquareRootJavaMath(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 1.0 / Math.sqrt(a.get(i)));
        }
    }

    public static void testInverseSquareRootTornadoMath(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 1.0 / TornadoMath.sqrt((double)a.get(i)));
        }
    }

    @Test
    public void testOptimizedInverseSquareRoot() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            double value = Math.random() + 0.1;
            data.set(i, value);
            seq.set(i, value);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testInverseSquareRootTornadoMath, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testInverseSquareRootTornadoMath(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testOptimizedInverseSquareRootJavaMath() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            double value = Math.random() + 0.1;
            data.set(i, value);
            seq.set(i, value);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testInverseSquareRootJavaMath, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testInverseSquareRootJavaMath(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathCos() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testCos, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testCos(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathAtan() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testAtan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.OPENCL, "-cl-opt-disable");
            executionPlan.execute();
        }
        TestMath.testAtan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathTan() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testTan, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testTan(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathTanh() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testTanh, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testTanh(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathLog() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testLog, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testLog(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathSqrt() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testSqrt, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testSqrt(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathExp() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testExp, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testExp(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathExpFloat() throws TornadoExecutionPlanException {
        int size = 128;
        FloatArray data = new FloatArray(128);
        FloatArray seq = new FloatArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testExpFloat, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testExpFloat(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathExpDouble() throws TornadoExecutionPlanException {
        int size = 128;
        DoubleArray data = new DoubleArray(128);
        DoubleArray seq = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            data.set(i, Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testExpDouble, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testExpDouble(seq);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testMathPowDouble() throws TornadoExecutionPlanException {
        int size = 32;
        FloatArray data = new FloatArray(32);
        FloatArray seq = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testPow, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testPow(seq);
        for (int i2 = 0; i2 < 32; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathPow() throws TornadoExecutionPlanException {
        int size = 8192;
        DoubleArray data = new DoubleArray(8192);
        DoubleArray seq = new DoubleArray(8192);
        IntStream.range(0, 8192).parallel().forEach(i -> {
            data.set(i, (double)((float)Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testPowDouble, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testPowDouble(seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)data.get(i2), (double)seq.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testMathAbs() throws TornadoExecutionPlanException {
        int size = 8192;
        FloatArray data = new FloatArray(8192);
        FloatArray seq = new FloatArray(8192);
        IntStream.range(0, 8192).parallel().forEach(i -> {
            data.set(i, (float)(-Math.random()));
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testAbs, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testAbs(seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testMathMin() throws TornadoExecutionPlanException {
        int size = 8192;
        FloatArray a = new FloatArray(8192);
        FloatArray b = new FloatArray(8192);
        FloatArray c = new FloatArray(8192);
        FloatArray seq = new FloatArray(8192);
        IntStream.range(0, 8192).parallel().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMath::testMin, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testMin(a, b, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)c.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathMax() throws TornadoExecutionPlanException {
        int size = 8192;
        DoubleArray a = new DoubleArray(8192);
        DoubleArray b = new DoubleArray(8192);
        DoubleArray c = new DoubleArray(8192);
        DoubleArray seq = new DoubleArray(8192);
        IntStream.range(0, 8192).parallel().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestMath::testMax, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testMax(a, b, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)c.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testNegate() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 8192;
        FloatArray a = new FloatArray(8192);
        FloatArray b = new FloatArray(8192);
        FloatArray seq = new FloatArray(8192);
        float min = -10000.0f;
        float max = 10000.0f;
        IntStream.range(0, 8192).parallel().forEach(i -> a.set(i, min + r.nextFloat() * (max - min)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testNegate, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testNegate(a, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)b.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testRem() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 8192;
        IntArray a = new IntArray(8192);
        IntArray b = new IntArray(8192);
        IntArray seq = new IntArray(8192);
        IntStream.range(0, 8192).forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
            seq.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testRemainder, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testRemainder(a, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)b.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testFMA() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 8192;
        FloatArray a = new FloatArray(8192);
        FloatArray b = new FloatArray(8192);
        FloatArray seq = new FloatArray(8192);
        IntStream.range(0, 8192).forEach(i -> {
            a.set(i, r.nextFloat());
            b.set(i, r.nextFloat());
            seq.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testFMA, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testFMA(a, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)b.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testFMA2() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 8192;
        FloatArray a = new FloatArray(8192);
        DoubleArray b = new DoubleArray(8192);
        DoubleArray seq = new DoubleArray(8192);
        IntStream.range(0, 8192).forEach(i -> {
            a.set(i, r.nextFloat());
            b.set(i, (double)r.nextFloat());
            seq.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testFMA2, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testFMA2(a, seq);
        for (int i2 = 0; i2 < 8192; ++i2) {
            Assert.assertEquals((double)b.get(i2), (double)seq.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathATan2() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray b = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        DoubleArray seqB = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, Math.random());
            b.set(i, Math.random());
            seqA.set(i, a.get(i));
            seqB.set(i, b.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestMath::testAtan2, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testAtan2(seqA, seqB);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathAcos() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, Math.random());
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testAcos, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testAcos(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathASin() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        IntStream.range(0, 128).parallel().forEach(i -> {
            a.set(i, Math.random());
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testAsin, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testAsin(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathSignumFloat() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        IntStream.range(0, 128).forEach(i -> {
            a.set(i, r.nextFloat() * (float)(r.nextBoolean() ? -1 : 1));
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testSignumFloat, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testSignumFloat(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathSignumFloatNaN() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 128;
        FloatArray a = new FloatArray(128);
        FloatArray seqA = new FloatArray(128);
        IntStream.range(0, 128).forEach(i -> {
            a.set(i, Float.NaN);
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testSignumFloat, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testSignumFloat(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathSignumDouble() throws TornadoExecutionPlanException {
        Random r = new Random();
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        IntStream.range(0, 128).forEach(i -> {
            a.set(i, r.nextDouble() * (double)(r.nextBoolean() ? -1 : 1));
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testSignumDouble, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testSignumDouble(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathSignumDoubleNaN() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 128;
        DoubleArray a = new DoubleArray(128);
        DoubleArray seqA = new DoubleArray(128);
        IntStream.range(0, 128).forEach(i -> {
            a.set(i, Double.NaN);
            seqA.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestMath::testSignumDouble, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testSignumDouble(seqA);
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((double)a.get(i2), (double)seqA.get(i2), (double)0.01);
        }
    }

    @Test
    public void testMathCeil() throws TornadoExecutionPlanException {
        int size = 32;
        FloatArray data = new FloatArray(32);
        FloatArray seq = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            data.set(i, (float)Math.random());
            seq.set(i, data.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{data}).task("t0", TestMath::testCeil, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestMath.testCeil(seq);
        for (int i2 = 0; i2 < 32; ++i2) {
            Assert.assertEquals((float)data.get(i2), (float)seq.get(i2), (float)0.01f);
        }
    }
}

