/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.loops;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestParallelDimensions
extends TornadoTestBase {
    public static void forLoopOneD(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 10);
        }
    }

    @Test
    public void test1DParallel() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray a = new IntArray(128);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestParallelDimensions::forLoopOneD, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    public static void forLoop2D(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                a.set(i * size + j, 10);
            }
        }
    }

    @Test
    public void test2DParallel() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray a = new IntArray(16384);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestParallelDimensions::forLoop2D, (Object)a, (Object)128).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                Assert.assertEquals((long)10L, (long)a.get(i * 128 + j));
            }
        }
    }

    public static void forLoop3D(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                for (int y = 0; y < size; ++y) {
                    a.set(size * size * y + size * j + i, 10);
                }
            }
        }
    }

    @Test
    public void test3DParallel() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray a = new IntArray(0x200000);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestParallelDimensions::forLoop3D, (Object)a, (Object)128).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int y = 0; y < 128; ++y) {
                    Assert.assertEquals((long)10L, (long)a.get(16384 * y + 128 * j + i));
                }
            }
        }
    }

    public static void forLoop3DMap(IntArray a, IntArray b, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                for (int y = 0; y < size; ++y) {
                    int threeDindex = size * size * y + size * j + i;
                    a.set(threeDindex, b.get(threeDindex));
                }
            }
        }
    }

    @Test
    public void test3DParallelMap() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray a = new IntArray(0x200000);
        IntArray b = new IntArray(0x200000);
        a.init(1);
        b.init(110);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestParallelDimensions::forLoop3DMap, (Object)a, (Object)b, (Object)128).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                for (int y = 0; y < 128; ++y) {
                    Assert.assertEquals((long)110L, (long)a.get(16384 * y + 128 * j + i));
                }
            }
        }
    }
}

