/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.loops;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;
import uk.ac.manchester.tornado.unittests.common.TornadoNotSupported;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLoops
extends TornadoTestBase {
    public static void forConstant01(IntArray a, int n) {
        for (int i = 0; i < n; ++i) {
            a.set(i, 10);
        }
    }

    public static void forConstant02(IntArray a, int n) {
        for (int i = 0; i <= n; ++i) {
            a.set(i, 10);
        }
    }

    public static void forConstant03(IntArray a, int n) {
        for (int i = 0; i < n; ++i) {
            a.set(i, 10);
        }
    }

    public static void forConstant04(Matrix2DFloat m, int n) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                m.set(i, j, 10.0f);
            }
        }
    }

    public static void forConstant05(Matrix2DFloat m, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                m.set(i, j, 10.0f);
            }
        }
    }

    public static void forConstant06(Matrix2DFloat m2, int n, int m) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= m; ++j) {
                m2.set(i, j, 10.0f);
            }
        }
    }

    public static void forLoopOneD(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 10);
        }
    }

    public static void steppedLoop(IntArray a, int size) {
        for (int i = 0; i < size; i += 2) {
            a.set(i, 200);
        }
    }

    public static void steppedLoop2(IntArray a, int size) {
        for (int i = 0; i < size; i += 2) {
            a.set(i, 200);
            a.set(i + 1, 200);
        }
    }

    public static void steppedLoop3(IntArray a, int size) {
        for (int i = 0; i < size; i += 3) {
            a.set(i, 200);
            a.set(i + 1, 200);
            a.set(i + 2, 200);
        }
    }

    public static void steppedLoop4(IntArray a, int size) {
        for (int i = 0; i < size; i += 4) {
            a.set(i, 200);
        }
    }

    public static void steppedLoop5(IntArray a, int size) {
        for (int i = 0; i < size; i += 3) {
            a.set(i, 200);
        }
    }

    public static void steppedLoop7(IntArray a, int size) {
        for (int i = 0; i < size; i += 7) {
            a.set(i, 200);
        }
    }

    public static void steppedLoop10(IntArray a, int size) {
        for (int i = 0; i < size; i += 10) {
            a.set(i, 200);
        }
    }

    public static void conditionalInLoop(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                a.set(i, 4);
                continue;
            }
            a.set(i, 10);
        }
    }

    public static void conditionalInLoop2(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) continue;
            a.set(i, 10);
        }
    }

    public static void conditionalIfElseLoop(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                a.set(i, 4);
                continue;
            }
            if (i == 5) {
                a.set(i, 5);
                continue;
            }
            a.set(i, 10);
        }
    }

    public static void twoDLoop(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                a[i][j] = 10;
            }
        }
    }

    public static void nestedForLoopOneDArray(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                a.set(i * size + j, 10);
            }
        }
    }

    public static void nestedForLoopTwoDArray(int[][] a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                a[i][j] = 10;
            }
        }
    }

    public static void controlFlowBreak(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (i != 4) continue;
            a.set(i, 4);
            break;
        }
    }

    public static void controlFlowBreak2(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) != 2) continue;
            a.set(i, 10);
            break;
        }
    }

    public static void controlFlowContinue(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) continue;
            a.set(i, 150);
        }
    }

    public static void nested2ParallelLoops(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                a.set(i * size + j, 10);
            }
        }
    }

    public static void whileLoop(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            for (int y = 0; y < size; ++y) {
                a.set(i * size + y, 10);
            }
        }
    }

    public static void dowWhileLoop(IntArray a, int size) {
        for (int i = 0; i < size; ++i) {
            int y = 1;
            do {
                a.set(i * size + y, 10);
            } while (++y < size);
        }
    }

    public static void forEach(int[] a, int[] c, int size) {
        for (int i = 0; i < size; ++i) {
            int idx = 0;
            for (int j : a) {
                c[idx] = j + 1;
                ++idx;
            }
        }
    }

    public static void reverseLoop(IntArray a) {
        for (int i = a.getSize() - 1; i >= 0; --i) {
            a.set(i, 10);
        }
    }

    private static void testSingleThreadLoopCond(IntArray in, IntArray out) {
        int someNumber;
        int i;
        int otherCompVal = in.get(0);
        for (i = 0; i < in.getSize() / 4 - 1; ++i) {
            someNumber = TestLoops.getNumber(in, i, i % 4, 4);
            in.set(i, someNumber + i);
        }
        if (i == otherCompVal) {
            someNumber = TestLoops.getNumber(in, i, i % 4, 4) + 1000;
            out.set(i, someNumber);
        }
    }

    private static int getNumber(IntArray in, int base, int offset, int multiplier) {
        return in.get(base * multiplier + offset);
    }

    private static void testMultipleThreadLoopCond(IntArray in, IntArray out) {
        int someNumber;
        int i;
        int otherCompVal = in.get(0);
        for (i = 0; i < in.getSize() / 4 - 1; ++i) {
            someNumber = TestLoops.getNumber(in, i, i % 4, 4);
            in.set(i, someNumber + i);
        }
        if (i == otherCompVal) {
            someNumber = TestLoops.getNumber(in, i, i % 4, 4) + 1000;
            out.set(i, someNumber);
        }
    }

    @Test
    public void testForConstant01() throws TornadoExecutionPlanException {
        int size = 256;
        IntArray a = new IntArray(256);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant01, (Object)a, (Object)256).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testForConstant02() throws TornadoExecutionPlanException {
        int size = 256;
        IntArray a = new IntArray(256);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant02, (Object)a, (Object)255).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testForConstant03() throws TornadoExecutionPlanException {
        int size = 256;
        IntArray a = new IntArray(size);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant03, (Object)a, (Object)size).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testForConstant04() throws TornadoExecutionPlanException {
        int size = 255;
        Matrix2DFloat m = new Matrix2DFloat(size, size);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant04, (Object)m, (Object)(size - 1)).transferToHost(1, new Object[]{m});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < m.getNumRows(); ++i) {
            for (int j = 0; j < m.getNumColumns(); ++j) {
                Assert.assertEquals((float)10.0f, (float)m.get(i, j), (float)0.001f);
            }
        }
    }

    @Test
    public void testForConstant05() throws TornadoExecutionPlanException {
        int size = 256;
        Matrix2DFloat m = new Matrix2DFloat(size, size);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant05, (Object)m, (Object)size).transferToHost(1, new Object[]{m});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < m.getNumRows(); ++i) {
            for (int j = 0; j < m.getNumColumns(); ++j) {
                Assert.assertEquals((float)10.0f, (float)m.get(i, j), (float)0.001f);
            }
        }
    }

    @Test
    public void testForConstant06() throws TornadoExecutionPlanException {
        int m = 256;
        int n = 64;
        Matrix2DFloat m2 = new Matrix2DFloat(m, n);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forConstant06, (Object)m2, (Object)(m - 1), (Object)(n - 1)).transferToHost(1, new Object[]{m2});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < m2.getNumRows(); ++i) {
            for (int j = 0; j < m2.getNumColumns(); ++j) {
                Assert.assertEquals((float)10.0f, (float)m2.get(i, j), (float)0.001f);
            }
        }
    }

    @Test
    public void testForLoopOneD() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::forLoopOneD, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testStepLoop() throws TornadoExecutionPlanException {
        int size = 16;
        IntArray a = new IntArray(16);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestLoops::steppedLoop, (Object)a, (Object)16).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 16; i += 2) {
            Assert.assertEquals((long)200L, (long)a.get(i));
            Assert.assertEquals((long)75L, (long)a.get(i + 1));
        }
    }

    @Test
    public void testStepLoop2() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray a = new IntArray(512);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop2, (Object)a, (Object)512).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            Assert.assertEquals((long)200L, (long)a.get(i));
        }
    }

    @Test
    public void testStepLoop3() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray a = new IntArray(512);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop3, (Object)a, (Object)512).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            Assert.assertEquals((long)200L, (long)a.get(i));
        }
    }

    @Test
    public void testStepLoop4() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray a = new IntArray(512);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop4, (Object)a, (Object)512).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; i += 4) {
            Assert.assertEquals((long)200L, (long)a.get(i));
            for (int j = i + 1; j < i + 4 && j < 512; ++j) {
                Assert.assertEquals((long)75L, (long)a.get(j));
            }
        }
    }

    @Test
    public void testStepLoop5() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray a = new IntArray(512);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop5, (Object)a, (Object)512).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; i += 3) {
            Assert.assertEquals((long)200L, (long)a.get(i));
            for (int j = i + 1; j < i + 3 && j < 512; ++j) {
                Assert.assertEquals((long)75L, (long)a.get(j));
            }
        }
    }

    @Test
    public void testStepLoop7() throws TornadoExecutionPlanException {
        int size = 512;
        IntArray a = new IntArray(512);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop7, (Object)a, (Object)512).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; i += 7) {
            Assert.assertEquals((long)200L, (long)a.get(i));
            for (int j = i + 1; j < i + 7 && j < 512; ++j) {
                Assert.assertEquals((long)75L, (long)a.get(j));
            }
        }
    }

    @Test
    public void testStepLoop10() throws TornadoExecutionPlanException {
        int size = 2048;
        IntArray a = new IntArray(2048);
        a.init(75);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::steppedLoop10, (Object)a, (Object)2048).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 2048; i += 10) {
            Assert.assertEquals((long)200L, (long)a.get(i));
            for (int j = i + 1; j < i + 10 && j < 2048; ++j) {
                Assert.assertEquals((long)75L, (long)a.get(j));
            }
        }
    }

    @Test
    public void testIfInsideForLoop() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestLoops::conditionalInLoop, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                Assert.assertEquals((long)4L, (long)a.get(i));
                continue;
            }
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testIfInsideForLoop2() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestLoops::conditionalInLoop2, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                Assert.assertEquals((long)1L, (long)a.get(i));
                continue;
            }
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testIfElseElseInLoop() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::conditionalIfElseLoop, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                Assert.assertEquals((long)4L, (long)a.get(i));
                continue;
            }
            if (i == 5) {
                Assert.assertEquals((long)5L, (long)a.get(i));
                continue;
            }
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Ignore
    public void testTwoDLoopTwoDArray() throws TornadoExecutionPlanException {
        int size = 10;
        int[][] a = new int[10][10];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::twoDLoop, (Object)a).transferToHost(1, (Object[])a);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int[][] nArray = a;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] ints;
            for (int anInt : ints = nArray[i]) {
                Assert.assertEquals((long)10L, (long)anInt);
            }
        }
    }

    @Test
    public void testNestedForLoopOneDArray() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(100);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::nestedForLoopOneDArray, (Object)a, (Object)10).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)10L, (long)a.get(i * 10 + j));
            }
        }
    }

    @Ignore
    public void testNestedForLoopTwoDArray() throws TornadoExecutionPlanException {
        int size = 10;
        int[][] a = new int[10][10];
        for (int i = 0; i < 10; ++i) {
            Arrays.fill(a[i], 1);
        }
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestLoops::nestedForLoopTwoDArray, (Object)a, (Object)10).transferToHost(1, (Object[])a);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int[][] nArray = a;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] ints;
            for (int anInt : ints = nArray[i]) {
                Assert.assertEquals((long)10L, (long)anInt);
            }
        }
    }

    @Test
    public void testLoopControlFlowBreak() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestLoops::controlFlowBreak, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 4) {
                Assert.assertEquals((long)4L, (long)a.get(i));
                continue;
            }
            Assert.assertEquals((long)1L, (long)a.get(i));
        }
    }

    @Test
    public void testLoopControlFlowBreak2() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1000);
        a.set(2, 2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestLoops::controlFlowBreak2, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            if (i == 2) {
                Assert.assertEquals((long)10L, (long)a.get(i));
                continue;
            }
            Assert.assertEquals((long)1000L, (long)a.get(i));
        }
    }

    @Test
    public void testLoopControlFlowContinue() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray foo = new IntArray(10);
        foo.init(50);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{foo}).task("t0", TestLoops::controlFlowContinue, (Object)foo).transferToHost(1, new Object[]{foo});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < foo.getSize(); ++i) {
            if (i == 4) {
                Assert.assertEquals((long)50L, (long)foo.get(i));
                continue;
            }
            Assert.assertEquals((long)150L, (long)foo.get(i));
        }
    }

    @Test
    public void testNestedForLoopOneDArray2() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(100);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestLoops::nested2ParallelLoops, (Object)a, (Object)10).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((long)10L, (long)a.get(i * 10 + j));
            }
        }
    }

    @Test
    public void testInnerWhileLoop() throws TornadoExecutionPlanException {
        int size = 100;
        IntArray a = new IntArray(10000);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestLoops::whileLoop, (Object)a, (Object)100).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 100; ++i) {
            for (int y = 0; y < 100; ++y) {
                Assert.assertEquals((long)10L, (long)a.get(i * 100 + y));
            }
        }
    }

    @Ignore
    public void testInnerDoWhileLoop() throws TornadoExecutionPlanException {
        int size = 100;
        IntArray a = new IntArray(10000);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestLoops::dowWhileLoop, (Object)a, (Object)100).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 100; ++i) {
            for (int y = 0; y < 100; ++y) {
                Assert.assertEquals((long)10L, (long)a.get(i * 100 + y));
            }
        }
    }

    @Test
    public void testInnerForEach() throws TornadoExecutionPlanException {
        int size = 10;
        int[] a = new int[10];
        int[] c = new int[10];
        Arrays.fill(a, 1);
        Arrays.fill(c, 0);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestLoops::forEach, (Object)a, (Object)c, (Object)10).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)2L, (long)c[i]);
        }
    }

    @TornadoNotSupported
    public void testReverseOrderLoops() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestLoops::reverseLoop, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int j = 0; j < 10; ++j) {
            Assert.assertEquals((long)10L, (long)a.get(j));
        }
    }

    @Test
    public void testSingleThreadLoopCondition() throws TornadoExecutionPlanException {
        int size = 1024;
        IntArray inTor = new IntArray(size);
        IntArray outTor = new IntArray(size);
        IntArray inSeq = new IntArray(size);
        IntArray outSeq = new IntArray(size);
        for (int i = 0; i < size; ++i) {
            inTor.set(i, i);
            outTor.set(i, i);
            inSeq.set(i, i);
            outSeq.set(i, i);
        }
        inTor.set(0, size / 4 - 1);
        inSeq.set(0, size / 4 - 1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{inTor}).task("t0", TestLoops::testSingleThreadLoopCond, (Object)inTor, (Object)outTor).transferToHost(1, new Object[]{inTor, outTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoops.testSingleThreadLoopCond(inSeq, outSeq);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)outSeq.get(i), (long)outTor.get(i));
        }
    }

    @Test
    public void testMultipleThreadLoopCondition() throws TornadoExecutionPlanException {
        int size = 1024;
        IntArray inTor = new IntArray(size);
        IntArray outTor = new IntArray(size);
        IntArray inSeq = new IntArray(size);
        IntArray outSeq = new IntArray(size);
        for (int i = 0; i < size; ++i) {
            inTor.set(i, i);
            outTor.set(i, i);
            inSeq.set(i, i);
            outSeq.set(i, i);
        }
        inTor.set(0, size / 4 - 1);
        inSeq.set(0, size / 4 - 1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{inTor}).task("t0", TestLoops::testMultipleThreadLoopCond, (Object)inTor, (Object)outTor).transferToHost(1, new Object[]{inTor, outTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoops.testMultipleThreadLoopCond(inSeq, outSeq);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)outSeq.get(i), (long)outTor.get(i));
        }
    }
}

