/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.logic;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLogic
extends TornadoTestBase {
    public static void logic01(IntArray data, IntArray output) {
        for (int i = 0; i < data.getSize(); ++i) {
            output.set(i, data.get(i) & data.get(i) - 1);
        }
    }

    public static void logic02(IntArray data, IntArray output) {
        for (int i = 0; i < data.getSize(); ++i) {
            output.set(i, data.get(i) | data.get(i) - 1);
        }
    }

    public static void logic03(IntArray data, IntArray output) {
        for (int i = 0; i < data.getSize(); ++i) {
            output.set(i, data.get(i) ^ data.get(i) - 1);
        }
    }

    public static void logic04(IntArray data, IntArray output) {
        for (int i = 0; i < data.getSize(); ++i) {
            int value = data.get(i);
            if ((value & value - 1) != 0) {
                int condition = value & value - 1;
                while (condition != 0) {
                    value &= value - 1;
                    condition = value & value - 1;
                }
            }
            output.set(i, value);
        }
    }

    @Test
    public void testLogic01() throws TornadoExecutionPlanException {
        int N = 1024;
        IntArray data = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntArray sequential = new IntArray(1024);
        IntStream.range(0, data.getSize()).sequential().forEach(i -> data.set(i, i));
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(0, new Object[]{data}).task("t0", TestLogic::logic01, (Object)data, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLogic.logic01(data, sequential);
        for (int i2 = 0; i2 < data.getSize(); ++i2) {
            Assert.assertEquals((long)sequential.get(i2), (long)output.get(i2));
        }
    }

    @Test
    public void testLogic02() throws TornadoExecutionPlanException {
        int N = 1024;
        IntArray data = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntArray sequential = new IntArray(1024);
        IntStream.range(0, data.getSize()).sequential().forEach(i -> data.set(i, i));
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(0, new Object[]{data}).task("t0", TestLogic::logic02, (Object)data, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLogic.logic02(data, sequential);
        for (int i2 = 0; i2 < data.getSize(); ++i2) {
            Assert.assertEquals((long)sequential.get(i2), (long)output.get(i2));
        }
    }

    @Test
    public void testLogic03() throws TornadoExecutionPlanException {
        int N = 1024;
        IntArray data = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntArray sequential = new IntArray(1024);
        IntStream.range(0, data.getSize()).sequential().forEach(i -> data.set(i, i));
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(0, new Object[]{data}).task("t0", TestLogic::logic03, (Object)data, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLogic.logic03(data, sequential);
        for (int i2 = 0; i2 < data.getSize(); ++i2) {
            Assert.assertEquals((long)sequential.get(i2), (long)output.get(i2));
        }
    }

    @Ignore
    public void testLogic04() throws TornadoExecutionPlanException {
        int N = 1024;
        IntArray data = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntArray sequential = new IntArray(1024);
        IntStream.range(0, data.getSize()).sequential().forEach(i -> data.set(i, i));
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(0, new Object[]{data}).task("t0", TestLogic::logic04, (Object)data, (Object)output).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLogic.logic04(data, sequential);
        for (int i2 = 0; i2 < data.getSize(); ++i2) {
            Assert.assertEquals((long)sequential.get(i2), (long)output.get(i2));
        }
    }
}

