/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.lambdas;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLambdas
extends TornadoTestBase {
    @Test
    public void testLambda01() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(256);
        IntArray b = new IntArray(256);
        Random r = new Random();
        IntStream.range(0, a.getSize()).forEach(i -> a.set(i, r.nextInt(100)));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", (x, y) -> {
            for (int i = 0; i < x.getSize(); ++i) {
                x.set(i, y.get(i) * y.get(i));
            }
        }, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < b.getSize(); ++i2) {
            Assert.assertEquals((long)(b.get(i2) * b.get(i2)), (long)a.get(i2));
        }
    }
}

