/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsLongKernelContext
extends TornadoTestBase {
    public static long computeAddSequential(LongArray input) {
        long acc = 0L;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void longReductionAddGlobalMemory(KernelContext context, LongArray a, LongArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, a.get(id) + a.get(id + stride));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void longReductionAddLocalMemory(KernelContext context, LongArray a, LongArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        long[] localA = context.allocateLongLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static void longReductionAddLocalMemory(KernelContext context, LongArray a, LongArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        long[] localA = context.allocateLongLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static long computeMaxSequential(LongArray input) {
        long acc = 0L;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((long)acc, (long)input.get(i));
        }
        return acc;
    }

    private static void longReductionMaxGlobalMemory(KernelContext context, LongArray a, LongArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.max((long)a.get(id), (long)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void longReductionMaxLocalMemory(KernelContext context, LongArray a, LongArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        long[] localA = context.allocateLongLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((long)localA[localIdx], (long)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static long computeMinSequential(LongArray input) {
        long acc = 0L;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((long)acc, (long)input.get(i));
        }
        return acc;
    }

    private static void longReductionMinGlobalMemory(KernelContext context, LongArray a, LongArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.min((long)a.get(id), (long)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void longReductionMinLocalMemory(KernelContext context, LongArray a, LongArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        long[] localA = context.allocateLongLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((long)localA[localIdx], (long)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void testLongReductionsAddGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionAddGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler();
        gridScheduler.addWorkerGrid("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler();
        gridScheduler.addWorkerGrid("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsMaxGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionMaxGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((long)finalSum, (long)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((long)finalSum, (long)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsMinGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionMinGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((long)finalSum, (long)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testLongReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        LongArray input = new LongArray(1024);
        LongArray reduce = new LongArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (long)i));
        long sequential = TestReductionsLongKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("taskGraph.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("taskGraph").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsLongKernelContext::longReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        long finalSum = 0L;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((long)finalSum, (long)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }
}

