/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsIntegersKernelContext
extends TornadoTestBase {
    public static int computeAddSequential(IntArray input) {
        int acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void intReductionAddGlobalMemory(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, a.get(id) + a.get(id + stride));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(localIdx));
        }
    }

    public static void basicAccessThreadIds(KernelContext context, IntArray a) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int idx = localGroupSize * groupID + localIdx;
        a.set(idx, idx);
    }

    public static void basicAccessThreadIds02(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int idx = localGroupSize * groupID + localIdx;
        int[] localA = context.allocateIntLocalArray(256);
        localA[localIdx] = a.get(idx);
        b.set(idx, localA[localIdx]);
    }

    public static void basicAccessThreadIds03(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int idx = localGroupSize * groupID + localIdx;
        int[] localA = context.allocateIntLocalArray(256);
        localA[localIdx] = a.get(idx);
        int n = localIdx;
        localA[n] = localA[n] * 2;
        b.set(idx, localA[localIdx]);
    }

    public static void basicAccessThreadIds04(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int idx = localGroupSize * groupID + localIdx;
        int[] localA = context.allocateIntLocalArray(1024);
        for (int i = 0; i < 256; ++i) {
            localA[i] = 2;
        }
        b.set(idx, localA[localIdx]);
    }

    public static void basicAccessThreadIds05(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int idx = localGroupSize * groupID + localIdx;
        int[] localA = context.allocateIntLocalArray(256);
        for (int i = 0; i < localGroupSize; ++i) {
            localA[i] = 2;
        }
        b.set(idx, localA[localIdx]);
    }

    public static void intReductionAddLocalMemory(KernelContext context, IntArray a, IntArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int[] localA = context.allocateIntLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        context.localBarrier();
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            if (localIdx < stride) {
                int n = localIdx;
                localA[n] = localA[n] + localA[localIdx + stride];
            }
            context.localBarrier();
        }
        if (localIdx == 0) {
            b.set(groupID, localA[localIdx]);
        }
    }

    public static void intReductionAddLocalMemory(KernelContext context, IntArray a, IntArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int[] localA = context.allocateIntLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        context.localBarrier();
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            if (localIdx < stride) {
                int n = localIdx;
                localA[n] = localA[n] + localA[localIdx + stride];
            }
            context.localBarrier();
        }
        if (localIdx == 0) {
            b.set(groupID, localA[localIdx]);
        }
    }

    public static int computeMaxSequential(IntArray input) {
        int acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((int)acc, (int)input.get(i));
        }
        return acc;
    }

    private static void intReductionMaxGlobalMemory(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.max((int)a.get(id), (int)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void intReductionMaxLocalMemory(KernelContext context, IntArray a, IntArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int[] localA = context.allocateIntLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((int)localA[localIdx], (int)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static int computeMinSequential(IntArray input) {
        int acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((int)acc, (int)input.get(i));
        }
        return acc;
    }

    private static void intReductionMinGlobalMemory(KernelContext context, IntArray a, IntArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.min((int)a.get(id), (int)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void intReductionMinLocalMemory(KernelContext context, IntArray a, IntArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int[] localA = context.allocateIntLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((int)localA[localIdx], (int)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void basic() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::basicAccessThreadIds, (Object)context, (Object)input).transferToHost(1, new Object[]{input});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)i, (long)input.get(i));
        }
    }

    @Test
    public void basic02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntStream.range(0, 1024).forEach(x -> input.set(x, x));
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::basicAccessThreadIds02, (Object)context, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)input.get(i), (long)output.get(i));
        }
    }

    @Test
    public void basic03() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntStream.range(0, 1024).forEach(x -> input.set(x, x));
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::basicAccessThreadIds03, (Object)context, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(input.get(i) * 2), (long)output.get(i));
        }
    }

    @Test
    public void basic04() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntStream.range(0, 1024).forEach(x -> input.set(x, x));
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::basicAccessThreadIds04, (Object)context, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((double)2.0, (double)output.get(i), (double)0.0);
        }
    }

    @Test
    public void basic05() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray output = new IntArray(1024);
        IntStream.range(0, 1024).forEach(x -> input.set(x, x));
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::basicAccessThreadIds05, (Object)context, (Object)input, (Object)output).transferToHost(1, new Object[]{output});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((double)2.0, (double)output.get(i), (double)0.0);
        }
    }

    @Test
    public void testIntReductionsAddGlobalMemory() throws TornadoExecutionPlanException {
        int size = 32;
        boolean localSize = true;
        IntArray input = new IntArray(32);
        IntArray reduce = new IntArray(32);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, 2));
        int sequential = TestReductionsIntegersKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegersKernelContext::intReductionAddGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce, input});
        worker.setGlobalWork(32L, 1L, 1L);
        worker.setLocalWork(1L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testIntReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 256;
        int localSize = 256;
        IntArray input = new IntArray(256);
        IntArray reduce = new IntArray(1);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, i));
        int sequential = TestReductionsIntegersKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(256);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsIntegersKernelContext::intReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(256L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((long)sequential, (long)finalSum);
    }

    @Test
    public void testIntReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 256;
        int localSize = 256;
        IntArray input = new IntArray(256);
        IntArray reduce = new IntArray(1);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, i));
        int sequential = TestReductionsIntegersKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(256);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{input}).task("t0", TestReductionsIntegersKernelContext::intReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(256L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((long)sequential, (long)finalSum);
    }

    @Test
    public void testIntReductionsMaxGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray reduce = new IntArray(4);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextInt()));
        int sequential = TestReductionsIntegersKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::intReductionMaxGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((int)finalSum, (int)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testIntReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray reduce = new IntArray(4);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextInt()));
        int sequential = TestReductionsIntegersKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::intReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((int)finalSum, (int)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testIntReductionsMinGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray reduce = new IntArray(4);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextInt(10000000)));
        int sequential = TestReductionsIntegersKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsIntegersKernelContext::intReductionMinGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((int)finalSum, (int)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testIntReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        IntArray input = new IntArray(1024);
        IntArray reduce = new IntArray(4);
        Random r = new Random();
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, r.nextInt(100000)));
        int sequential = TestReductionsIntegersKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsIntegersKernelContext::intReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        int finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((int)finalSum, (int)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }
}

