/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsFloatsKernelContext
extends TornadoTestBase {
    public static float computeAddSequential(FloatArray input) {
        float acc = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void floatReductionAddGlobalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = context.globalIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, a.get(id) + a.get(id + stride));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void floatReductionAddLocalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        float[] localA = context.allocateFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static void floatReductionAddLocalMemory(KernelContext context, FloatArray a, FloatArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        float[] localA = context.allocateFloatLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static float computeMaxSequential(FloatArray input) {
        float acc = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((float)acc, (float)input.get(i));
        }
        return acc;
    }

    private static void floatReductionMaxGlobalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.max((float)a.get(id), (float)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void floatReductionMaxLocalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        float[] localA = context.allocateFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((float)localA[localIdx], (float)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static float computeMinSequential(FloatArray input) {
        float acc = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((float)acc, (float)input.get(i));
        }
        return acc;
    }

    private static void floatReductionMinGlobalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.min((float)a.get(id), (float)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void floatReductionMinLocalMemory(KernelContext context, FloatArray a, FloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        float[] localA = context.allocateFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((float)localA[localIdx], (float)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void testFloatReductionsAddGlobalMemory() throws TornadoExecutionPlanException {
        int size = 512;
        int localSize = 32;
        FloatArray input = new FloatArray(512);
        FloatArray reduce = new FloatArray(16);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(512);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 32}).task("t0", TestReductionsFloatsKernelContext::floatReductionAddGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(512L, 1L, 1L);
        worker.setLocalWork(32L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsFloatsKernelContext::floatReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsFloatsKernelContext::floatReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsMaxGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsFloatsKernelContext::floatReductionMaxGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((float)finalSum, (float)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsFloatsKernelContext::floatReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((float)finalSum, (float)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsMinGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsFloatsKernelContext::floatReductionMinGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((float)finalSum, (float)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testFloatReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = TestReductionsFloatsKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsFloatsKernelContext::floatReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        float finalSum = 0.0f;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((float)finalSum, (float)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }
}

